package com.liquidnet.client.admin.web.controller.zhengzai.candy;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyCouponAdminService;
import com.liquidnet.service.candy.dto.admin.CandyCouponListParam;
import com.liquidnet.service.candy.entity.CandyCoupon;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("candy/coupon")
public class CandyCouponAdminController extends BaseController {

    @Autowired
    ICandyCouponAdminService candyCouponAdminService;

    @PostMapping("list")
    @ResponseBody
    public TableDataInfo list(CandyCouponListParam listParam) {
        LambdaQueryWrapper<CandyCoupon> queryWrapper = Wrappers.lambdaQuery(CandyCoupon.class);
        queryWrapper.select(CandyCoupon::getCouponId, CandyCoupon::getTitle);
        queryWrapper.orderByDesc(CandyCoupon::getCreatedAt);

        if (null != listParam) {
            if (StringUtils.isNotBlank(listParam.getKeyword())) {
                queryWrapper.like(CandyCoupon::getTitle, listParam.getKeyword());
            }
            if (null != listParam.getBusiType()) {
                queryWrapper.eq(CandyCoupon::getBusiType, listParam.getBusiType());
            }
            if (null != listParam.getCouType()) {
                queryWrapper.eq(CandyCoupon::getCouType, listParam.getCouType());
            }
            if (null != listParam.getBindType()) {
                queryWrapper.eq(CandyCoupon::getBindType, listParam.getBindType());
            }
        }

        startPage();
        return getDataTable(candyCouponAdminService.list(queryWrapper));
    }
}
