package com.liquidnet.service.platform.service.refund;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.UserPathDto;
import com.liquidnet.service.kylin.constant.KylinTableStatusConst;
import com.liquidnet.service.kylin.dto.param.RefundCallbackParam;
import com.liquidnet.service.kylin.dto.vo.mongo.*;
import com.liquidnet.service.kylin.dto.vo.returns.KylinOrderRefundsVo;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.platform.utils.DataUtils;
import com.liquidnet.service.platform.utils.MongoVoUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.client.result.UpdateResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 订单退款表 服务实现类 处理数据 退款后状态的变化
 * </p>
 *
 * @author jiaangxiulong
 * @since 2021-05-26
 */
@Slf4j
@Service
public class KylinRefundsStatusServiceImpl {

    @Autowired
    private KylinOrderTicketsMapper kylinOrderTicketsMapper;

    @Autowired
    private KylinOrderTicketStatusMapper kylinOrderTicketStatusMapper;

    @Autowired
    private KylinOrderRefundsMapper kylinOrderRefundsMapper;

    @Autowired
    private KylinOrderTicketEntitiesMapper kylinOrderTicketEntitiesMapper;

    @Autowired
    private KylinOrderRefundsEntitiesMapper kylinOrderRefundsEntitiesMapper;

    @Autowired
    private KylinOrderTicketRelationsMapper kylinOrderTicketRelationsMapper;

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private MongoConverter mongoConverter;

    @Autowired
    private DataUtils dataUtils;

    @Autowired
    private MongoVoUtils mongoVoUtils;

    public boolean orderTicketRefunded(RefundCallbackParam refundCallbackParam, KylinOrderRefunds refundInfo) {
        List<KylinOrderRefundEntities> refundEntities = kylinOrderRefundsEntitiesMapper.selectList(
                new QueryWrapper<KylinOrderRefundEntities>().eq("order_refunds_id", refundInfo.getOrderRefundsId())
        );
        List<String> orderTicketEntitiesIdsArr = refundEntities.stream().map(KylinOrderTicketEntities -> KylinOrderTicketEntities.getOrderTicketEntitiesId()).collect(Collectors.toList());
        String orderTicketsId = refundInfo.getOrderTicketsId();

        KylinOrderTicketRelations orderRelations = kylinOrderTicketRelationsMapper.selectOne(
                new QueryWrapper<KylinOrderTicketRelations>().eq("order_id", orderTicketsId)
        );

        // 更新数据
        // 订单状态表
        KylinOrderTickets orderInfo = kylinOrderTicketsMapper.selectOne(
                new QueryWrapper<KylinOrderTickets>().eq("order_tickets_id", orderTicketsId)
        );
        KylinOrderTicketStatus orderStatusTable = new KylinOrderTicketStatus();
        int newStatus = 0;
        if (refundCallbackParam.getRefund_price() + orderInfo.getPriceRefund().doubleValue() == orderInfo.getPriceActual().doubleValue()) {
            newStatus = KylinTableStatusConst.ORDER_STATUS4;
        } else {
            newStatus = KylinTableStatusConst.ORDER_STATUS6;
        }
        orderStatusTable.setStatus(newStatus);
        orderStatusTable.setUpdatedAt(LocalDateTime.now());
        kylinOrderTicketStatusMapper.update(
                orderStatusTable, new UpdateWrapper<KylinOrderTicketStatus>()
                        .eq("order_id", orderTicketsId)
        );

        // 入场人
        double priceActual = orderInfo.getPriceActual().doubleValue();
        double priceExpress = orderInfo.getPriceExpress().doubleValue();
        int allEntitiesCount = kylinOrderTicketEntitiesMapper.selectCount(// 总入场人数量 排出未付款的 用来计算单入场人的价格
                new QueryWrapper<KylinOrderTicketEntities>()
                        .eq("order_id", orderTicketsId)
                        .ne("is_payment", KylinTableStatusConst.ENTITIES_IS_PAYMENT0)
        );
        double onePrice = (priceActual - priceExpress) / allEntitiesCount;//单价
        int refundNumber = 0;
        for (String entitiesId : orderTicketEntitiesIdsArr) {
            KylinOrderTicketEntities EntitiesInfo = kylinOrderTicketEntitiesMapper.selectOne(//已退完成的
                    new QueryWrapper<KylinOrderTicketEntities>()
                            .eq("order_ticket_entities_id", entitiesId)
            );
            BigDecimal refundedPrice = EntitiesInfo.getRefundPrice();

            KylinOrderRefundEntities refundEntitiesInfo = kylinOrderRefundsEntitiesMapper.selectOne(
                    new QueryWrapper<KylinOrderRefundEntities>()
                            .eq("order_refunds_id", refundInfo.getOrderRefundsId())
                            .eq("order_ticket_entities_id", entitiesId)
            );

            KylinOrderTicketEntities entitiesTable = new KylinOrderTicketEntities();
            double priceNew = refundEntitiesInfo.getRefundPrice().doubleValue() + refundedPrice.doubleValue();
            int isPayment = 0;
            if (priceNew == onePrice) {
                isPayment = KylinTableStatusConst.ENTITIES_IS_PAYMENT3;
                refundNumber++;
            } else {
                isPayment = KylinTableStatusConst.ENTITIES_IS_PAYMENT4;
            }
            entitiesTable.setIsPayment(isPayment);
            entitiesTable.setUpdatedAt(LocalDateTime.now());
            entitiesTable.setRefundPrice(BigDecimal.valueOf(priceNew));
            Integer[] entitiesTableIsPayment = {KylinTableStatusConst.ENTITIES_IS_PAYMENT2, KylinTableStatusConst.ENTITIES_IS_PAYMENT4};
            kylinOrderTicketEntitiesMapper.update(entitiesTable, new UpdateWrapper<KylinOrderTicketEntities>()
                    .eq("order_ticket_entities_id", entitiesId)
                    .in("is_payment", entitiesTableIsPayment)
            );

            HashMap<String, Object> EntitiesVo = new HashMap<>();
            EntitiesVo.put("updatedAt", DateUtil.getNowTime());
            EntitiesVo.put("refundPrice", BigDecimal.valueOf(priceNew));
            EntitiesVo.put("isPayment", isPayment);
            BasicDBObject EntitiesVov = new BasicDBObject("$set", mongoConverter.convertToMongoType(EntitiesVo));
            UpdateResult updateResult = mongoTemplate.getCollection(KylinOrderTicketEntitiesVo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("orderTicketEntitiesId").is(entitiesId)).getQueryObject(),
                    EntitiesVov
            );

            dataUtils.delOrderTicketEntitiesRedis(entitiesId);
        }

        // 订单表
        double price = orderInfo.getPriceRefund().doubleValue() + refundCallbackParam.getRefund_price();
        Integer num = orderInfo.getRefundNumber() + refundNumber;
        KylinOrderTickets update = new KylinOrderTickets();
        update.setRefundNumber(num);
        update.setPriceRefund(BigDecimal.valueOf(price));
        update.setUpdatedAt(LocalDateTime.now());
        kylinOrderTicketsMapper.update(
                update, new UpdateWrapper<KylinOrderTickets>()
                        .eq("order_tickets_id", orderTicketsId)
        );

        HashMap<String, Object> orderVo = new HashMap<>();
        orderVo.put("updatedAt", DateUtil.getNowTime());
        orderVo.put("priceRefund", BigDecimal.valueOf(price));
        orderVo.put("status", newStatus);
        orderVo.put("refundNumber", num);
        BasicDBObject orderVov = new BasicDBObject("$set", mongoConverter.convertToMongoType(orderVo));
        UpdateResult orderUpdateResult = mongoTemplate.getCollection(KylinOrderTicketVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("orderTicketsId").is(orderTicketsId)).getQueryObject(),
                orderVov
        );
        dataUtils.delOrderTicketRedis(orderTicketsId);
        mongoVoUtils.resetOrderListVo(orderInfo.getUserId(), 2, orderTicketsId, null);

        // 退款单完成
        KylinOrderRefunds kylinOrderRefunds = new KylinOrderRefunds();
        kylinOrderRefunds.setStatus(KylinTableStatusConst.ORDER_REFUND_STATUS_REFUNDED);
        kylinOrderRefunds.setRefundCode(refundCallbackParam.getRefund_code());
        kylinOrderRefunds.setRefundType(refundCallbackParam.getRefund_type());
        kylinOrderRefunds.setRefundId(refundCallbackParam.getRefund_id());
        kylinOrderRefunds.setRefundAt(refundCallbackParam.getRefund_at());
        kylinOrderRefunds.setUpdatedAt(LocalDateTime.now());
        kylinOrderRefundsMapper.update(
                kylinOrderRefunds,
                new UpdateWrapper<KylinOrderRefunds>().in("order_refunds_id", refundInfo.getOrderRefundsId())
        );
        // 修改缓存
        KylinOrderRefundsVo kylinOrderRefundsVo = new KylinOrderRefundsVo();
        BeanUtils.copyProperties(kylinOrderRefunds, kylinOrderRefundsVo);
        BasicDBObject object = new BasicDBObject("$set", mongoConverter.convertToMongoType(kylinOrderRefundsVo));
        UpdateResult updateResult = mongoTemplate.getCollection(KylinOrderRefundsVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("orderRefundsId").is(refundInfo.getOrderRefundsId())).getQueryObject(),
                object
        );
        dataUtils.delOrderRefundVo(refundInfo.getOrderRefundsId());
        dataUtils.delOrderRefundVoByOrderId(refundInfo.getOrderTicketsId());

        if (refundInfo.getType() == KylinTableStatusConst.ORDER_REFUND_TYPE_APPLY) {
            // 退还库存
            for (String entitiesId : orderTicketEntitiesIdsArr) {
                KylinOrderTicketEntities entitiesInfo = kylinOrderTicketEntitiesMapper.selectOne(
                        new QueryWrapper<KylinOrderTicketEntities>().eq("order_ticket_entities_id", entitiesId)
                );
                if (entitiesInfo.getIsPayment() == KylinTableStatusConst.ENTITIES_IS_PAYMENT3) {
                    dataUtils.changeSurplusGeneral(entitiesInfo.getTicketId(), 1);
                    log.info(UserPathDto.setData("changeBuyInfo", "UserId=" + orderInfo.getUserId() + "idCard=" + entitiesInfo.getEnterIdCode() + " PerformanceId=" + orderRelations.getPerformanceId() + " TicketId=" + entitiesInfo.getTicketId(), "info"));
                    dataUtils.changeBuyInfo(orderInfo.getUserId(), entitiesInfo.getEnterIdCode(), orderRelations.getPerformanceId(), entitiesInfo.getTicketId(), -1);
                }
            }
        }

        return true;
    }

}
