package com.liquidnet.service.sweet.vo;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class SweetWechatUsersVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -8639044068603169141L;

    /**
     * wechat_id
     */
    private String wechatId;

    /**
     * openId
     */
    private String openId;

    /**
     * unionId
     */
    private String unionId;

    /**
     * 服务类型 1正在 2摩登 21草莓 22五百里 23mdsk 24正在
     */
    private Integer type;

    /**
     * 小程序解密手机号
     */
    private String phoneNumber;

    /**
     * 小程序解密手机号
     */
    private String purePhoneNumber;

    /**
     * 小程序解密地区码
     */
    private String countryCode;

    /**
     * 昵称
     */
    private String nickname;

    /**
     * 性别
     */
    private String sexDesc;

    /**
     * 性别 男1
     */
    private Integer sex;

    /**
     * 头像
     */
    private String headImgUrl;

    /**
     * zh_CN
     */
    private String language;

    /**
     * 国家
     */
    private String country;

    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 关注时间
     */
    private LocalDateTime subscribeTime;

    /**
     * ADD_SCENE_SEARCH 关注方式
     */
    private String subscribeScene;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SweetWechatUsersVo obj = new SweetWechatUsersVo();
    public static SweetWechatUsersVo getNew() {
        try {
            return (SweetWechatUsersVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetWechatUsersVo();
        }
    }

}
