package com.liquidnet.service.goblin.dto.manage;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

@ApiModel(value = "GoblinStoreMgtGoodsSkuSimpleFilterParam", description = "商品管理:SKU列表筛选条件入参")
@Data
public class GoblinStoreMgtGoodsSkuSimpleFilterParam implements Serializable {
    private static final long serialVersionUID = -2875361058424448491L;
    @ApiModelProperty(position = 10, required = true, value = "店铺ID[64]")
    @NotBlank(message = "店铺ID不能为空")
    private String storeId;
    @ApiModelProperty(position = 11, required = true, value = "当前记录起始索引", example = "1")
    @Min(value = 1, message = "起始索引不能小于1")
    @NotNull(message = "起始索引无效")
    private Integer pageNum;
    @ApiModelProperty(position = 13, required = false, value = "搜索关键字[128]")
    @Size(min = 2, max = 100, message = "搜索关键字长度范围2~100")
    private String keyword;
    @ApiModelProperty(position = 14, required = false, value = "商品类型[0-常规｜1-数字藏品｜2-券类商品]，未指定则代表全部")
    private Integer skuType;
//    @ApiModelProperty(position = 15, required = false, value = "商品上架状态[0-待上架|1-下架|2-违规|3-上架]", allowableValues = "0,1,2,3")
//    private String shelvesStatus;
}
