package com.liquidnet.service.candy.dto.admin;

import com.liquidnet.service.candy.entity.CandyCoupon;
import com.liquidnet.service.candy.entity.CandyCouponRule;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class CandyCouponTemplateDto implements Serializable, Cloneable {
    private static final long serialVersionUID = 6278406576442685501L;
    /* com.liquidnet.service.candy.entity.CandyCoupon */
    private String couponId;
    private Integer state;
    private String title;
    private String label;
    private String notice;
    private Integer exclusive;
    private Integer busiType;
    private Integer couType;
    private Integer bindType;
    private BigDecimal discount;
    private BigDecimal valFace;
    private BigDecimal valOver;
    private BigDecimal valMinus;
    private Integer overlay;
    private Integer overlayLevel;
    private Integer validity;
    private Integer redeemValidity;
    private LocalDateTime redeemStart;
    private LocalDateTime redeemStop;
    private LocalDateTime effectAt;
    private LocalDateTime expireAt;
    //private String operator;
    //private LocalDateTime createdAt;
    //private LocalDateTime updatedAt;
    //private String comment;


    /* com.liquidnet.service.candy.entity.CandyCouponRule */
    private List<CandyCouponRule> useRules;


    private static final CandyCouponTemplateDto obj = new CandyCouponTemplateDto();

    public static CandyCouponTemplateDto getNew() {
        try {
            return (CandyCouponTemplateDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new CandyCouponTemplateDto();
        }
    }

    public CandyCouponTemplateDto copy(CandyCoupon source) {
        if (null == source) return this;
        this.setCouponId(source.getCouponId());
        this.setState(source.getState());
        this.setTitle(source.getTitle());
        this.setLabel(source.getLabel());
        this.setNotice(source.getNotice());
        this.setExclusive(source.getExclusive());
        this.setBusiType(source.getBusiType());
        this.setCouType(source.getCouType());
        this.setBindType(source.getBindType());
        this.setDiscount(source.getDiscount());
        this.setValFace(source.getValFace());
        this.setValOver(source.getValOver());
        this.setValMinus(source.getValMinus());
        this.setOverlay(source.getOverlay());
        this.setOverlayLevel(source.getOverlayLevel());
        this.setValidity(source.getValidity());
        this.setRedeemValidity(source.getRedeemValidity());
        this.setRedeemStart(source.getRedeemStart());
        this.setRedeemStop(source.getRedeemStop());
        this.setEffectAt(source.getEffectAt());
        this.setExpireAt(source.getExpireAt());
        return this;
    }
}
