package com.liquidnet.service.sweet.utils;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.sweet.constant.SweetConstant;
import com.liquidnet.service.sweet.dto.*;
import com.liquidnet.service.sweet.entity.*;
import com.liquidnet.service.sweet.mapper.*;
import com.liquidnet.service.sweet.vo.SweetArtistsRelationVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.*;

@Component
public class RedisMDSKDataUtils {

    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private QueueUtils queueUtils;

    @Autowired
    private SweetManualMdskMapper sweetManualMdskMapper;
    @Autowired
    private SweetManualArtistsMdskMapper sweetManualArtistsMdskMapper;
    @Autowired
    private SweetRichtextMdskMapper sweetRichtextMdskMapper;
    @Autowired
    private SweetManualSortMdskMapper sweetManualSortMdskMapper;
    @Autowired
    private SweetManualNotifyMdskMapper sweetManualNotifyMdskMapper;
    @Autowired
    private SweetManualShopMdskMapper sweetManualShopMdskMapper;
    @Autowired
    private SweetArtistsMapper sweetArtistsMapper;


    public List<SweetManualAppletMDSKDto> setPushList() {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MDSK_MANUAL_PUSH_LIST;
        List<SweetManualAppletMDSKDto> data = sweetManualMdskMapper.getManualAppletDto();
        for (SweetManualAppletMDSKDto item : data) {
            if(!item.getIsMember().equals(1)){
                item.setTimeSell(DateUtil.format(DateUtil.addMin(DateUtil.parse(item.getTimeSell(),"yyyy-MM-dd HH:mm:ss"),-item.getPayCountdownMinute()),DateUtil.Formatter.yyyyMMddHHmmss));
            }
            item.setFieldName((String) redisUtil.hget("kylin:fields:id" + ":" + item.getFieldId(), "name"));
            item.setCityName((String) redisUtil.hget("kylin:fields:id" + ":" + item.getFieldId(), "city_name"));
            item.setLatitude((String) redisUtil.hget("kylin:fields:id" + ":" + item.getFieldId(), "latitude"));
            item.setLongitude((String) redisUtil.hget("kylin:fields:id" + ":" + item.getFieldId(), "longitude"));
        }
        redisUtil.set(redisKey, data);
        return data;
    }

    //获取电子手册列表 (城市)
    public List<SweetManualAppletMDSKDto> getPushList() {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MDSK_MANUAL_PUSH_LIST;
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setPushList();
        } else {
            return (List<SweetManualAppletMDSKDto>) obj;
        }
    }

    //获取电子手册演出详情
    public SweetManualAppletMDSKDto getAppletPerformance(String manualId) {
        List<SweetManualAppletMDSKDto> data = getPushList();
        SweetManualAppletMDSKDto returnData = SweetManualAppletMDSKDto.getNew();
        for (SweetManualAppletMDSKDto item : data) {
            if (item.getManualId().equalsIgnoreCase(manualId)) {
                returnData = item;
                break;
            }
        }
        return returnData;
    }

    public SweetManualArtistList2MDSKDto setTimeList(String manualId, String content) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MDSK_MANUAL_TIME_LIST.concat(manualId);
        HashMap<String, Object> map = CollectionUtil.mapStringObject();
        map.put("manualId", manualId);
        List<SweetManualArtistListMDSKDto> data = sweetManualArtistsMdskMapper.getManualList(map);

        //获取时间
        SweetManualAppletMDSKDto sweetManualAppletDto = getAppletPerformance(manualId);
        Date dateEnd = DateUtil.parse(sweetManualAppletDto.getTimeEnd(), DateUtil.DATE_SMALL_STR);
        Date dateStart = DateUtil.parse(sweetManualAppletDto.getTimeStart(), DateUtil.DATE_SMALL_STR);
        int intervalDay = (int) DateUtil.intervalDays(dateStart, dateEnd);
        ArrayList<String> list = new ArrayList<>();
        list.add(DateUtil.format(dateStart, DateUtil.Formatter.yyyy_MM_dd));
        for (int i = 0; i < intervalDay; i++) {
            list.add(DateUtil.format(DateUtil.addDay(dateStart, i + 1), DateUtil.Formatter.yyyy_MM_dd));
        }

        //获取舞台
        List<SweetManualArtistStageListMDSKDto> stageData = sweetManualArtistsMdskMapper.getStageNameList(map);

        SweetManualArtistList2MDSKDto returnData = SweetManualArtistList2MDSKDto.getNew();
        returnData.setDate(list);
        returnData.setData(data);
        returnData.setStage(stageData);
        redisUtil.set(redisKey, returnData);
        return returnData;
    }

    //获取时间表
    public SweetManualArtistList2MDSKDto getTimeList(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MDSK_MANUAL_TIME_LIST.concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setTimeList(manualId, null);
        } else {
            return (SweetManualArtistList2MDSKDto) obj;
        }
    }

    public SweetRichtextMdsk setRichTextRedisData(String manualId, String type, SweetRichtextMdsk content) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MDSK_MANUAL_RICH_TEXT.concat(manualId).concat(":type:" + type);
        SweetRichtextMdsk sweetRichtext;
        if (content != null) {
            sweetRichtext = content;
        } else {
            sweetRichtext = sweetRichtextMdskMapper.selectOne(Wrappers.lambdaQuery(SweetRichtextMdsk.class).eq(SweetRichtextMdsk::getManualId, manualId).eq(SweetRichtextMdsk::getType, type));
        }
        redisUtil.set(redisKey, sweetRichtext);
        return sweetRichtext;
    }

    //获取富文本详情
    public SweetRichtextMdsk getRichTextRedisData(String manualId, String type) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MDSK_MANUAL_RICH_TEXT.concat(manualId).concat(":type:" + type);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setRichTextRedisData(manualId, type, null);
        } else {
            return (SweetRichtextMdsk) obj;
        }
    }

    public List<String> setTagRedisData(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MDSK_MANUAL_SORT.concat(manualId);
        SweetManualSortMdsk data = sweetManualSortMdskMapper.selectOne(Wrappers.lambdaQuery(SweetManualSortMdsk.class).eq(SweetManualSortMdsk::getManualId, manualId));
        String[] arrays = data.getShowPosition().split(",");
        List<String> returnData = new ArrayList<>();
        for (String item : arrays) {
            returnData.add(item);
//            returnData.add(SweetConstant.ManualPosition.getMessage(item));
        }
        redisUtil.set(redisKey, returnData);
        return returnData;
    }

    //获取显示的标签
    public List<String> getTagRedisData(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MDSK_MANUAL_SORT.concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setTagRedisData(manualId);
        } else {
            return (List<String>) obj;
        }
    }

    public List<SweetManualNotifyMdsk> setNotifyRedisData(String manualId, List<SweetManualNotifyMdsk> content) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MDSK_MANUAL_NOTIFY_LIST.concat(manualId);
        List<SweetManualNotifyMdsk> data;
        if (content != null) {
            data = content;
        } else {
            data = sweetManualNotifyMdskMapper.selectList(Wrappers.lambdaQuery(SweetManualNotifyMdsk.class).eq(SweetManualNotifyMdsk::getManualId, manualId).eq(SweetManualNotifyMdsk::getStatus, 1));
        }
        redisUtil.set(redisKey, data);
        return data;
    }

    //获取通知
    public List<SweetManualNotifyMdsk> getNotifyRedisData(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MDSK_MANUAL_NOTIFY_LIST.concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setNotifyRedisData(manualId, null);
        } else {
            return (List<SweetManualNotifyMdsk>) obj;
        }
    }

    public void deletePushListRedisData() {
        redisUtil.del(SweetConstant.REDIS_KEY_SWEET_MDSK_MANUAL_PUSH_LIST);//列表
    }

    public void deleteTimeListRedisData(String manualId) {
        redisUtil.del(SweetConstant.REDIS_KEY_SWEET_MDSK_MANUAL_TIME_LIST.concat(manualId));//列表
    }

    public void deleteSortRedisData(String manualId) {
        redisUtil.del(SweetConstant.REDIS_KEY_SWEET_MDSK_MANUAL_SORT.concat(manualId));//列表
    }

    public void setArtistsRelationRedisVo(String uid, String artistsId, String manualId, String type) {

        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsDataA = CollectionUtil.linkedListObjectArr();
        LocalDateTime now = LocalDateTime.now();

        String redisKey = SweetConstant.REDIS_KEY_SWEET_MDSK_ARTISTS_RELATION.concat(uid).concat(":manualId:").concat(manualId);
        SweetArtistsRelationVo vo = getArtistsRelationRedisVo(uid, manualId);
        vo.setUid(uid);
        if (type.equalsIgnoreCase("sign")) {
            if (vo.getSignList() == null) {
                ArrayList<String> signList = new ArrayList<>();
                signList.add(artistsId);
                vo.setSignList(signList);
                sqls.add(SqlMapping.get("sweet_user_relation_mdsk.insert"));
                sqlsDataA.add(new Object[]{
                        uid, 2, artistsId, manualId, now
                });
            } else {
                if (vo.getSignList().contains(artistsId)) {
                    vo.getSignList().remove(artistsId);
                    sqls.add(SqlMapping.get("sweet_user_relation_mdsk.delete"));
                    sqlsDataA.add(new Object[]{
                            uid, artistsId, manualId,2
                    });
                } else {
                    vo.getSignList().add(artistsId);
                    sqls.add(SqlMapping.get("sweet_user_relation_mdsk.insert"));
                    sqlsDataA.add(new Object[]{
                            uid, 2, artistsId, manualId, now
                    });
                }
            }
        } else if (type.equalsIgnoreCase("watch")) {
            if (vo.getWatchList() == null) {
                ArrayList<String> watchList = new ArrayList<>();
                watchList.add(artistsId);
                vo.setWatchList(watchList);
                sqls.add(SqlMapping.get("sweet_user_relation_mdsk.insert"));
                sqlsDataA.add(new Object[]{
                        uid, 1, artistsId, manualId, now
                });
            } else {
                if (vo.getWatchList().contains(artistsId)) {
                    vo.getWatchList().remove(artistsId);
                    sqls.add(SqlMapping.get("sweet_user_relation_mdsk.delete"));
                    sqlsDataA.add(new Object[]{
                            uid, artistsId, manualId,1
                    });
                } else {
                    vo.getWatchList().add(artistsId);
                    sqls.add(SqlMapping.get("sweet_user_relation_mdsk.insert"));
                    sqlsDataA.add(new Object[]{
                            uid, 1, artistsId, manualId, now
                    });
                }
            }
        }
        redisUtil.set(redisKey, vo);

        queueUtils.sendMsgByRedis(MQConst.SweetQueue.ARTISTS_RELATION_MDSK.getKey(),
                SqlMapping.gets(sqls, sqlsDataA));
    }

    //获取 签售
    //获取 想看
    public SweetArtistsRelationVo getArtistsRelationRedisVo(String uid, String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MDSK_ARTISTS_RELATION.concat(uid).concat(":manualId:").concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return SweetArtistsRelationVo.getNew();
        } else {
            return (SweetArtistsRelationVo) obj;
        }
    }

    //获取 商铺
    public List<SweetManualShopMdsk> setManualShopRedisData(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MDSK_SHOP.concat(manualId);
        List<SweetManualShopMdsk> list = sweetManualShopMdskMapper.selectList(Wrappers.lambdaQuery(SweetManualShopMdsk.class).eq(SweetManualShopMdsk::getManualId, manualId).orderBy(true, false, SweetManualShopMdsk::getSort));
        redisUtil.set(redisKey, list);
        return list;
    }

    public List<SweetManualShopMdsk> getManualShopRedisData(String manualId) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_MDSK_SHOP.concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setManualShopRedisData(manualId);
        } else {
            return (List<SweetManualShopMdsk>) obj;
        }
    }

//    // 艺人详情
//    public SweetArtists setArtistsDetails(String artistsId) {
//        String redisKey = SweetConstant.REDIS_KEY_SWEET_MDSK_ARTISTS_DETAILS.concat(artistsId);
//        SweetArtists sweetArtists = sweetArtistsMapper.selectOne(Wrappers.lambdaQuery(SweetArtists.class).eq(SweetArtists::getArtistsId, artistsId).eq(SweetArtists::getStatus, 1));
//        redisUtil.set(redisKey, sweetArtists);
//        return sweetArtists;
//    }
//
//    public SweetArtists getArtistsDetails(String artistsId) {
//        String redisKey = SweetConstant.REDIS_KEY_SWEET_MDSK_ARTISTS_DETAILS.concat(artistsId);
//        Object obj = redisUtil.get(redisKey);
//        if (obj == null) {
//            return setArtistsDetails(artistsId);
//        } else {
//            return (SweetArtists) obj;
//        }
//    }
}
