package com.liquidnet.commons.lang.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class IdentityUtils {
    private static final Logger log = LoggerFactory.getLogger(IdentityUtils.class);
    private static String aliThirdUrl = "https://1.api.apistore.cn/idcard3";
    private static String aliThirdAppCode = "cc29fa8cb494468289dec09df46922b5";

    public static String aliThird(String realName,String cardNo){
        MultiValueMap<String, String> params = new LinkedMultiValueMap<>();
        params.add("realName",realName);
        params.add("cardNo",cardNo);
        MultiValueMap<String, String> header = new LinkedMultiValueMap<>();
        header.add("Authorization","APPCODE "+aliThirdAppCode);
        try {
            return HttpUtil.post(aliThirdUrl, params, header);
        } catch (Exception e) {
            log.error("###实名认证异常:{}", e.getLocalizedMessage(), e);
            return null;
        }
    }
}
