package com.liquidnet.service.dragon.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.dragon.dto.DragonRefundAppDto;
import com.liquidnet.service.dragon.service.IDragonOrderRefundsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@Api(tags = "退款")
@RestController
@RequestMapping("refund")
public class RefundController {

    @Autowired
    IDragonOrderRefundsService orderRefundsService;

    @PostMapping("refundSingle")
    @ApiOperation("单条退款")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<DragonRefundAppDto> refundSingle(@RequestParam(value = "orderCode") @NotNull(message = "订单号不能为空") String orderCode,
                                                        @RequestParam(value = "code") @NotNull(message = "支付单能为空") String code,
                                                        @RequestParam(value = "orderRefundCode") @NotNull(message = "退款单号不能为空") String orderRefundCode,
                                                        @RequestParam(value = "reason") @NotNull(message = "退款原因不能为空") String reason,
                                                        @RequestParam(value = "notifyUrl") @NotNull(message = "回调地址不能为空") String returnUrl,
                                                        @RequestParam(value = "price") @NotNull(message = "退款价格不能为空") BigDecimal price,
                                                        @RequestParam(value = "priceTotal") @NotNull(message = "订单价格不能为空") BigDecimal priceTotal,
                                                        @RequestParam(value = "paymentType") @NotNull(message = "支付类型不能为空") String paymentType,
                                                        @RequestParam(value = "paymentId") @NotNull(message = "支付订单号不能为空") String paymentId) {
        return orderRefundsService.dragonRefund(orderCode, code, orderRefundCode, reason, returnUrl, price, paymentType, paymentId, priceTotal);
    }

    @PostMapping("callBack/wepay")
    @ApiOperation("微信退款回调")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public String refundSingle(
            HttpServletRequest request,
            HttpServletResponse response) {
        return orderRefundsService.wePayRefundCallBack(request, response);
    }

    @PostMapping("refund/alipay/result")
    @ApiOperation("支付宝查询退款结果")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public String refundSingle(
            @RequestParam(value = "orderCode") String orderCode,
            @RequestParam(value = "paymentId") String paymentId,
            @RequestParam(value = "orderRefundCode") String orderRefundCode,
            @RequestParam(value = "callBackUrl") String callBackUrl) {
        return orderRefundsService.aliPayRefundCodeStatus(orderCode, paymentId, orderRefundCode, callBackUrl);
    }


}
