package com.liquidnet.service.dragon.channel.wepay.resp;

import com.liquidnet.service.dragon.utils.XmlUtil;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import lombok.Data;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: WepayPayRespDto
 * @Package com.liquidnet.service.dragon.channel.wepay.resp
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/7/12 10:40
 */
@Data
@XStreamAlias("xml")
public class WepayPayRespDto {
    @XStreamAlias("return_code")
    private String returnCode; //SUCCESS
    @XStreamAlias("return_msg")
    private String returnMsg; //OK
    @XStreamAlias("result_code")
    private String resultCode; //SUCCESS
    @XStreamAlias("mch_id")
    private String mchId; //1551961491
    @XStreamAlias("appid")
    private String appid; //wx3498304dda39c5a1
    @XStreamAlias("nonce_str")
    private String nonceStr; //Y6Czfx4lhuSv0yUD
    @XStreamAlias("sign")
    private String sign; //97001E77813055D03E3009F67A836D62
    @XStreamAlias("prepay_id")
    private String prepayId; //wx111130490949693ab00f679072ea730000
    @XStreamAlias("trade_type")
    private String tradeType; //MWEB
    @XStreamAlias("mweb_url")
    private String mwebUrl; //https://wx.tenpay.com/cgi-bin/mmpayweb-bin/checkmweb?prepay_id=wx111130490949693ab00f679072ea730000&package=2011082926

    public static void xmlToBean(){
        String xmlStr = "<xml><return_code><![CDATA[SUCCESS]]></return_code>\n" +
                "<return_msg><![CDATA[OK]]></return_msg>\n" +
                "<result_code><![CDATA[SUCCESS]]></result_code>\n" +
                "<mch_id><![CDATA[1551961491]]></mch_id>\n" +
                "<appid><![CDATA[wx3498304dda39c5a1]]></appid>\n" +
                "<nonce_str><![CDATA[Y6Czfx4lhuSv0yUD]]></nonce_str>\n" +
                "<sign><![CDATA[97001E77813055D03E3009F67A836D62]]></sign>\n" +
                "<prepay_id><![CDATA[wx111130490949693ab00f679072ea730000]]></prepay_id>\n" +
                "<trade_type><![CDATA[MWEB]]></trade_type>\n" +
                "<mweb_url><![CDATA[https://wx.tenpay.com/cgi-bin/mmpayweb-bin/checkmweb?prepay_id=wx111130490949693ab00f679072ea730000&package=2011082926]]></mweb_url>\n" +
                "</xml> ";
        WepayPayRespDto respDto= XmlUtil.toBean(xmlStr, WepayPayRespDto.class);
     System.out.println("respDto.getAppid()=="+respDto.getAppid());
     System.out.println("respDto.getMwebUrl()==="+respDto.getMwebUrl());
    }

    public static void main(String[] args) {
        xmlToBean();
    }
}
