package com.liquidnet.service.kylin.dto.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 * 退款回掉参数
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-31 11:19 上午
 */

@Data
public class RefundBatchSearchParam implements Serializable {
    private String refundBatchId;

    private String targetId;

    private Integer status;

    private String createdAt;

    @ApiModelProperty(value = "页数", example = "0")
    @NotNull(message = "页数不能为空")
    private Integer pageSize;

    @ApiModelProperty(value = "数量", example = "20")
    @NotNull(message = "数量不能为空")
    private Integer pageNum;

}
