package com.liquidnet.service.kylin.controller;

import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.express.KylinOrderExpressVo;
import com.liquidnet.service.kylin.service.impl.PerformancesExpressInfoServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 演出快递
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-06-21
 */

@Api(tags = "前端-物流信息")
@RestController
@RequestMapping("performancesExpress")
public class PerformancesExpressInfoController {

    @Autowired
    private PerformancesExpressInfoServiceImpl performancesExpressInfoServiceImpl;

    @GetMapping("orderRoute/{orderTicketsId}")
    @ApiOperation("获取物流信息") // 前端使用
    @ApiImplicitParam(name = "orderTicketsId", value = "订单ID", required = true, dataType = "String", paramType = "path")
    public ResponseDto<KylinOrderExpressVo> orderRouteDetail(@PathVariable() String orderTicketsId) {
        KylinOrderExpressVo routeVoList = performancesExpressInfoServiceImpl.orderRouteDetail(orderTicketsId);
        if (null != routeVoList) {
            return ResponseDto.success(routeVoList);
        } else {
            return ResponseDto.failure(ErrorMapping.get("20800"));
        }
    }

}
