package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.service.goblin.entity.GoblinGoods;
import com.liquidnet.service.goblin.entity.GoblinGoodsSku;
import com.liquidnet.service.goblin.entity.GoblinNftExActivity;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Author: wll
 * @Description:
 * @Date:Create：in 2022/4/24 2:02 下午
 */

@ApiModel(value = "GoblinNftSkuVo", description = "单个活动下的sku]")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinNftSkuVo implements Serializable,Cloneable{

    private String skuId;
    private String spuName;
    private String image;
    /**
     * 总数量
     */
    private Integer countNumber;

    /**
     * 使用数量
     */
    private Integer useNumber;

    /**
     * 未使用数量
     */
    private Integer unUseNumber;

    private GoblinNftExSkuVo goblinNftExSkuVo;


    private final static GoblinNftSkuVo obj = new GoblinNftSkuVo();
    public static GoblinNftSkuVo getNew(){
        try {
            return  (GoblinNftSkuVo) obj.clone();
        }catch (CloneNotSupportedException e){
            return new GoblinNftSkuVo();
        }
    }

    public GoblinNftSkuVo copy(GoblinGoodsSku goblinGoodsSku){
        if (null == goblinGoodsSku){
            return this;
        }
        this.setSkuId(goblinGoodsSku.getSkuId());
        this.setSpuName(goblinGoodsSku.getName());
        this.setImage(goblinGoodsSku.getSkuPic());
        return this;
    }


}
