package com.liquidnet.service.erp.vo;

import lombok.Data;

import java.math.BigDecimal;

@Data
public class StockQueryVo implements Cloneable {

    // 单品主键id
    private int spec_id;
    // 代表SPU所有属性的唯一编号，用于系统货品的区分，SPU概念介绍
    private String goods_no;
    // 品牌编号
    private String brand_no;
    // 品牌名称，ERP版本V2.3.8.4及以上才可返回
    private String brand_name;
    // 货品名称
    private String goods_name;
    // 代表单品（SKU）所有属性的唯一编号，用于系统单品的区分，SKU概念介绍
    private String spec_no;
    // 规格码
    private String spec_code;
    // 条形码
    private String barcode;
    // 仓库主键id
    private int warehouse_id;
    // 代表仓库所有属性的唯一编码，用于仓库区分，ERP内支持自定义（ERP仓库界面设置）
    private String warehouse_no;
    // 仓库名称
    private String warehouse_name;
    // （0不限 1普通仓库 2自动流传外部 3京东仓储 4科捷 5百世物流 6SKU360 7通天晓 8中联网仓 9顺丰仓储 10网仓2号 11奇门仓储 12旺店通仓储 13心怡仓储 14力威仓储 15京东沧海 16云集仓储 17POS 18虎符 20外部链路型 22抖店云仓 126分销委外仓 127其它）
    private int warehouse_type;
    // 库存量
    private BigDecimal stock_num;
    // 锁定量
    private BigDecimal lock_num;
    // 主键
    private long rec_id;
    // 创建时间
    private String created;
    // 单品在仓库中编码,一般为空
    private String spec_wh_no2;
    // 委外出库库存占用量
    private BigDecimal wms_reserve_num;
    // 0 未启用 1 启用 2停用
    private int status;
    // 今日销量
    private BigDecimal stock_today_num;
    // 0 未启用 1 启用 2停用
    private BigDecimal stock_diff;
    // 辅助单位
    private int unit;
    // 依据最大警戒天数计算出的最大警戒库存
    private BigDecimal safe_stock1;
    // 最小警戒库存
    private BigDecimal safe_stock2;
    // 最大警戒库存
    private BigDecimal safe_stock3;
    // 警戒库存类型
    private int alarm_type;
    // 警戒库存计算天数
    private int alarm_days;
    // 最大警戒天数
    private int alarm_days1;
    // 销售增长率类型
    private int sales_rate_type;
    // 销售增长率
    private BigDecimal sales_rate;
    // 销售周期
    private BigDecimal sales_rate_cycle;
    // 固定月销售增长率
    private BigDecimal sales_fixrate;
    // 颜色标记
    private int flag_id;
    // 默认入库货位
    private int default_position_id;
    // 最后一次入库货位
    private int last_position_id;
    // 上次盘点时间
    private String last_pd_time;
    // 上次出入库时间
    private String last_inout_time;
    // 最后销售时间
    private String last_sales_time;
    // 备注
    private String remark;
    // 未付款量
    private BigDecimal unpay_num;
    // 预订单量
    private BigDecimal subscribe_num;
    // 待审核量
    private BigDecimal order_num;
    // 待发货量
    private BigDecimal sending_num;
    // 采在途量
    private BigDecimal purchase_num;
    // 调拨在途量
    private BigDecimal transfer_num;
    // 待调拨量
    private BigDecimal to_transfer_num;
    // 待采购量
    private BigDecimal to_purchase_num;
    // 采购到货量
    private BigDecimal purchase_arrive_num;
    // 采购退货量
    private BigDecimal return_num;
    // 委外出库占用量
    private BigDecimal return_exch_num;
    // 委外在途量
    private BigDecimal return_onway_num;
    // 销售退货量
    private BigDecimal refund_num;
    // 生产在途量
    private BigDecimal process_onway_num;
    // 销售退货在途量
    private BigDecimal refund_onway_num;
    // 部分付款库存
    private BigDecimal part_paid_num;
    // 负库存出库量
    private BigDecimal neg_stockout_num;
    // 今日销量
    private BigDecimal today_num;
    // 警戒库存
    private BigDecimal safe_stock;
    // 单品在外部WMS中的编码，如在物流宝仓库中主键
    private String spec_wh_no;
    // 外部WMS同步时库存
    private BigDecimal wms_sync_stock;
    // 外部WMS同步时占用库存
    private BigDecimal wms_preempty_stock;
    // 外部WMS同步时,与系统库存的差
    private BigDecimal wms_stock_diff;
    // 与外部WMS同步时间wms_sync_stock-stock_num  格式：yyyy-MM-dd HH:mm:ss
    private String wms_sync_time;
    // 成本价
    private BigDecimal cost_price;
    // 重量
    private BigDecimal weight;
    // 商品图片url
    private String img_url;
    // 最后修改时间，格式：yyyy-MM-dd HH:mm:ss
    private String modified;
    // 可发库存
    private BigDecimal avaliable_num;








}
