package com.liquidnet.client.admin.web.controller.zhengzai.goblin;


import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.goblin.service.impl.GoblinFrontCompilationsServiceImpl;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.goblin.entity.GoblinFrontCompilations;
import com.liquidnet.service.goblin.entity.GoblinGoods;
import com.liquidnet.service.goblin.mapper.GoblinGoodsMapper;
import com.liquidnet.service.goblin.param.GoblinFrontCompilationsParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 合集 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2022-01-06
 */
@Api(tags = "合集管理")
@RestController
@RequestMapping("/compilations")
public class GoblinFrontCompilationsController extends BaseController {

    @Autowired
    GoblinFrontCompilationsServiceImpl goblinFrontCompilationsService;
    @Autowired
    GoblinGoodsMapper goblinGoodsMapper;

    /***
     * @author zhangfuxin
     * @Description:商品单品list
     * @date 2022/1/7 下午2:39
     */
    @GetMapping("goodsList")
    @ApiOperation(value = "商品单品list")
    @ResponseBody
    public AjaxResult goodsList(@RequestParam(name = "name", required = false) String name) {
        LambdaQueryWrapper<GoblinGoods> queryWrapper = Wrappers.lambdaQuery(GoblinGoods.class);
        queryWrapper.ne(GoblinGoods::getDelFlg,"1");
        if(StringUtil.isNotBlank(name)){
            queryWrapper.like(GoblinGoods::getName,name);
        }
        List<GoblinGoods> list= goblinGoodsMapper.selectList(queryWrapper);
        return  AjaxResult.success(list);
    }
    /**
     * @author zhangfuxin
     * @Description:添加合集
     * @date 2021/12/27 下午1:22
     */
    @PostMapping("create")
    @ApiOperation(value = "添加合集")
    @ResponseBody
    public AjaxResult create(@RequestBody GoblinFrontCompilationsParam goblinFrontCompilationsParam) {
        GoblinFrontCompilations goblinFrontCompilations=new GoblinFrontCompilations();
        BeanUtils.copyProperties(goblinFrontCompilationsParam,goblinFrontCompilations);
        logger.info("添加合集{}", JSON.toJSONString(goblinFrontCompilationsParam));
        boolean result=goblinFrontCompilationsService.create(goblinFrontCompilations);
        if (result ) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }
    @PostMapping("update")
    @ApiOperation(value = "修改合集")
    @ResponseBody
    public AjaxResult update( @RequestBody GoblinFrontCompilationsParam goblinFrontCompilationsParam) {
        GoblinFrontCompilations goblinFrontCompilations=new GoblinFrontCompilations();
        BeanUtils.copyProperties(goblinFrontCompilationsParam,goblinFrontCompilations);
        logger.info("修改合集{}", JSON.toJSONString(goblinFrontCompilationsParam));
        boolean result=goblinFrontCompilationsService.update(goblinFrontCompilations);
        if (result ) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }
    @PostMapping("delete")
    @ApiOperation(value = "删除合集")
    @ResponseBody
    public AjaxResult delete( @RequestBody GoblinFrontCompilationsParam goblinFrontCompilationsParam) {
        boolean result=goblinFrontCompilationsService.delte(goblinFrontCompilationsParam.getMid());
        if (result ) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }
    @PostMapping("getOne")
    @ApiOperation(value = "查看详情")
    @ResponseBody
    public AjaxResult getOne( @RequestBody GoblinFrontCompilationsParam goblinFrontCompilationsParam) {
        GoblinFrontCompilations goblinFrontCompilations=new GoblinFrontCompilations();
        BeanUtils.copyProperties(goblinFrontCompilationsParam,goblinFrontCompilations);
        logger.info("查看详情{}", JSON.toJSONString(goblinFrontCompilationsParam));
        GoblinFrontCompilations goblinFrontCompilations1=goblinFrontCompilationsService.getOne(goblinFrontCompilationsParam.getMid());
        return AjaxResult.success(goblinFrontCompilations1);
    }

    @PostMapping("page")
    @ApiOperation(value = "分页")
    @ResponseBody
    public AjaxResult page( @RequestParam(name = "pageSize", required = true) int pageSize,@RequestParam(name = "pageNumber", required = true)int pageNumber,@RequestBody GoblinFrontCompilationsParam goblinFrontCompilationsParam) {
        return AjaxResult.success(goblinFrontCompilationsService.page(pageSize,pageNumber));
    }

    @PostMapping("list")
    @ApiOperation(value = "合集模糊查询")
    @ResponseBody
    public AjaxResult list( @RequestParam(name = "name", required = false) String name) {
        return AjaxResult.success(goblinFrontCompilationsService.getListGoblinFrontCompilations(name));
    }
}
