package com.liquidnet.service.galaxy.router.xuper.biz;

import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.third.xuper.constant.XuperEnum;
import com.liquidnet.common.third.xuper.dto.*;
import com.liquidnet.common.third.xuper.exception.XupterException;
import com.liquidnet.common.third.xuper.util.XuperSdkUtil;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.biz.GalaxyBeanTransferBiz;
import com.liquidnet.service.galaxy.biz.GalaxyEnumBiz;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.constant.GalaxyErrorEnum;
import com.liquidnet.service.galaxy.dto.bo.GalaxyNftOrderBindBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxyNftOrderBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxyTransferNftInfoBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxyUserInfoBo;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.utils.GalaxyDataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: XuperTradeBiz
 * @Package com.liquidnet.service.galaxy.router.xuper.biz
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/6/27 11:11
 */
@Slf4j
@Component
public class XuperTradeBiz {
    @Autowired
    private XuperSdkUtil xuperSdkUtil;

    @Autowired
    private GalaxyDataUtils dataUtils;

    @Autowired
    private XuperTradeCommonBiz xuperTradeCommonBiz;

    @Autowired
    private XuperPublishBiz xuperPublishBiz;

    @Autowired
    private GalaxyBeanTransferBiz galaxyBeanTransferBiz;

    /**
     * 发行和购买
     * @param reqDto
     * @return
     */
    public ResponseDto<GalaxyNftPublishAndBuyRespDto> nftPublishAndBuy(GalaxyNftPublishAndBuyReqDto reqDto) {
        return xuperTradeCommonBiz.nftPublishAndBuy(reqDto);
    }
    /**
     * NFT发行和购买
     * @param reqDto
     * @return
     */
    public ResponseDto<GalaxyNftPublishAndBuyResultQueryRespDto> nftPublishAndBuyResultQuery(GalaxyNftPublishAndBuyResultQueryReqDto reqDto) {
        //获取订单信息
        GalaxyNftOrderBo nftOrderBo = dataUtils.getNftOrderBo(reqDto.getRouterType(),reqDto.getNftOrderPayId());
        if(StringUtil.isNull(nftOrderBo)){
            return ResponseDto.failure(GalaxyErrorEnum.PUBLISH_ORDER_NOT_EXIST.getCode(), GalaxyErrorEnum.PUBLISH_ORDER_NOT_EXIST.getMessage());
        }

        /**
         * TODO 如果订单信息是购买失败，则直接调用至信链查询购买结果
         */
        //是否需要发起二次购买
        boolean isNeedSecondBuy = false;
        if(StringUtil.isNotEmpty(nftOrderBo.getNftPublishStatus())
                && (GalaxyEnum.TaskStatusEnum.INIT.getCode().equalsIgnoreCase(nftOrderBo.getNftPublishStatus())
                ||GalaxyEnum.TaskStatusEnum.PROCESSING.getCode().equalsIgnoreCase(nftOrderBo.getNftPublishStatus()))){
            //判断是否需要二次购买
            if(StringUtil.isEmpty(nftOrderBo.getNftPublishTaskId())){
                isNeedSecondBuy = true;
            }
            //执行nft发行结果查询
            GalaxyNftPublishResultQueryReqDto nftPublishResultQueryReqDto = GalaxyNftPublishResultQueryReqDto.getNew();
            nftPublishResultQueryReqDto.setNftOrderPayId(reqDto.getNftOrderPayId());
            nftPublishResultQueryReqDto.setRouterType(reqDto.getRouterType());
            ResponseDto<GalaxyNftPublishResultQueryRespDto> publishResultQueryRespDto = xuperPublishBiz.nftPublishResultQuery(nftPublishResultQueryReqDto);
        }else if(StringUtil.isNotEmpty(nftOrderBo.getNftBuyStatus())
                && (GalaxyEnum.TaskStatusEnum.INIT.getCode().equalsIgnoreCase(nftOrderBo.getNftBuyStatus())
                ||GalaxyEnum.TaskStatusEnum.PROCESSING.getCode().equalsIgnoreCase(nftOrderBo.getNftBuyStatus()))){
            //判断是否需要二次购买
            if(StringUtil.isEmpty(nftOrderBo.getNftBuyTaskId())){
                isNeedSecondBuy = true;
            }
            //执行nft购买结果查询
            GalaxyNftBuyResultQueryReqDto nftBuyResultQueryReqDto = GalaxyNftBuyResultQueryReqDto.getNew();
            nftBuyResultQueryReqDto.setNftOrderPayId(reqDto.getNftOrderPayId());
            nftBuyResultQueryReqDto.setRouterType(reqDto.getRouterType());
            ResponseDto<GalaxyNftBuyResultQueryRespDto> buyResultQueryRespDto= this.nftBuyResultQuery(nftBuyResultQueryReqDto,nftOrderBo);
        }

        GalaxyNftPublishAndBuyResultQueryRespDto resultQueryRespDto = GalaxyNftPublishAndBuyResultQueryRespDto.getNew();
        if(nftOrderBo.getNftPublishStatus().equalsIgnoreCase(GalaxyEnum.TaskStatusEnum.TASK_SUCCESS.getCode())&&
                nftOrderBo.getNftBuyStatus().equalsIgnoreCase(GalaxyEnum.TaskStatusEnum.TASK_SUCCESS.getCode())){
            BeanUtil.copy(nftOrderBo,resultQueryRespDto);
            return ResponseDto.success(resultQueryRespDto);
        }
        return ResponseDto.failure(GalaxyErrorEnum.NFT_PUBLISH_AND_BUY_QUERY_FAIL.getCode(),GalaxyErrorEnum.NFT_PUBLISH_AND_BUY_QUERY_FAIL.getMessage(),resultQueryRespDto);
    }

    private ResponseDto<GalaxyNftBuyResultQueryRespDto> nftBuyResultQuery(GalaxyNftBuyResultQueryReqDto reqDto,GalaxyNftOrderBo nftOrderBo) {
        //获取订单信息
//        GalaxyNftOrderBo nftOrderBo = dataUtils.getNftOrderBo(reqDto.getRouterType(),reqDto.getNftOrderPayId());
//        if(StringUtil.isNull(nftOrderBo)){
//            return ResponseDto.failure(GalaxyErrorEnum.PUBLISH_ORDER_NOT_EXIST.getCode(), GalaxyErrorEnum.PUBLISH_ORDER_NOT_EXIST.getMessage());
//        }

        if(StringUtil.isEmpty(nftOrderBo.getNftBuyTaskId())){
            return ResponseDto.failure(GalaxyErrorEnum.NFT_BUY_TASK_NOT_EXIST.getCode(), GalaxyErrorEnum.NFT_BUY_TASK_NOT_EXIST.getMessage());
        }
        try {
            //执行资产碎片授予查询
            Xuper010QuerySdsReqDto xuper010QuerySdsReqDto = Xuper010QuerySdsReqDto.getNew();
            // 定义返回结果对象
            Xuper010QuerySdsRespDto xuper010QuerySdsRespDto = null;
            long shardId = -1l;
            GalaxyNftOrderBindBo nftOrderBindBo = dataUtils.getGalaxyNftOrderBindBo(reqDto.getRouterType(),nftOrderBo.getNftOrderPayId());
            if(StringUtil.isNotNull(nftOrderBindBo)){
                shardId = nftOrderBindBo.getNftIdIndex().longValue();
            }

            xuper010QuerySdsReqDto.setAssetId(Long.parseLong(nftOrderBo.getSeriesId()));
            xuper010QuerySdsReqDto.setShardId(shardId);
            XuperResponseDto<Xuper010QuerySdsRespDto> xuperResponseDto = xuperSdkUtil.xuper010QuerySds(xuper010QuerySdsReqDto);
            log.info("xuper010QuerySds resp : "+ JsonUtils.toJson(xuperResponseDto));
            if(xuperResponseDto.isSuccess()){
                xuper010QuerySdsRespDto = xuperResponseDto.getParseData(Xuper010QuerySdsRespDto.class);
                if(String.valueOf(xuper010QuerySdsRespDto.getErrNo()).equalsIgnoreCase(ErrorCode.SUCCESS.getCode())){
                    //更新订单缓存数据状态
                    String nowTimeStr = DateUtil.getNowTime();
                    //转换任务状态
                    Integer taskStatus = Integer.valueOf(GalaxyEnumBiz.getGrantStatusEnum(reqDto.getRouterType(),String.valueOf(xuper010QuerySdsRespDto.getMeta().getStatus())).getCode());
                    //设置时间
                    String nftBuyChainTimestampStr = DateUtil.format(new Date(),DateUtil.Formatter.yyyyMMddHHmmss);
                    nftOrderBo.setNftBuyChainTimestamp(nftBuyChainTimestampStr);
                    nftOrderBo.setNftBuyStatus(taskStatus.toString());
                    nftOrderBo.setNftBuyTradeHash(xuper010QuerySdsRespDto.getMeta().getTxId());
                    nftOrderBo.setNftBuyPayTaskId(nftOrderBo.getNftBuyTaskId());
                    nftOrderBo.setUpdatedAt(LocalDateTime.now());
                    //先更新nft购买数据
                    dataUtils.updateNftOrderBuyInfo(nftOrderBo.getRouterType(),nftOrderBo.getNftOrderPayId(),nftOrderBo);


                    GalaxyNftBuyResultQueryRespDto resultQueryRespDto = GalaxyNftBuyResultQueryRespDto.getNew();
                    resultQueryRespDto.setTaskStatus(taskStatus);
                    resultQueryRespDto.setChainTimestamp(nowTimeStr);
                    resultQueryRespDto.setPayTaskId(xuper010QuerySdsRespDto.getMeta().getTxId());
                    resultQueryRespDto.setTxHash(xuper010QuerySdsRespDto.getMeta().getTxId());
                    return ResponseDto.success(resultQueryRespDto);
                }
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        return ResponseDto.failure(GalaxyErrorEnum.NFT_PUBLISH_AND_BUY_QUERY_FAIL.getCode(),GalaxyErrorEnum.NFT_PUBLISH_AND_BUY_QUERY_FAIL.getMessage());
    }

    /**
     * nft转让
     * @param reqDto
     * @return
     */
    public ResponseDto<GalaxyNftTransferRespDto> nftTransfer(GalaxyNftTransferReqDto reqDto) {
        log.info("nftTransfer request param:{}",JsonUtils.toJson(reqDto));

        //获取用户信息
        GalaxyUserInfoBo userInfoBo = dataUtils.getGalaxyUserInfo(reqDto.getRouterType(),reqDto.getUserId());
        if(StringUtil.isNull(userInfoBo)){
            log.error("开始执行 nftTransfer nft owner not exist error msg:{}",GalaxyErrorEnum.NFT_TRANSFER_FAIL_OWNER_NOT_EXIST.getMessage());
            return ResponseDto.failure(GalaxyErrorEnum.NFT_TRANSFER_FAIL_OWNER_NOT_EXIST.getCode(), GalaxyErrorEnum.NFT_TRANSFER_FAIL_OWNER_NOT_EXIST.getMessage());
        }

        //获取用户信息
        GalaxyUserInfoBo receiveUserInfoBo = dataUtils.getGalaxyUserInfo(reqDto.getRouterType(),reqDto.getReceiveUserId());
        if(StringUtil.isNull(userInfoBo)){
            log.error("开始执行 nftTransfer nft receiver not exist error msg:{}",GalaxyErrorEnum.NFT_TRANSFER_FAIL_RECEIVER_NOT_EXIST.getMessage());
            return ResponseDto.failure(GalaxyErrorEnum.NFT_TRANSFER_FAIL_RECEIVER_NOT_EXIST.getCode(), GalaxyErrorEnum.NFT_TRANSFER_FAIL_RECEIVER_NOT_EXIST.getMessage());
        }

        GalaxyTransferNftInfoBo transferNftInfoBo = dataUtils.getGalaxyTransferNftInfoBo(reqDto.getRouterType(),reqDto.getTransOrderId());
        //初始化转让信息
        if(transferNftInfoBo==null){
            transferNftInfoBo = galaxyBeanTransferBiz.buildTransferNftInfoBo(reqDto,userInfoBo,receiveUserInfoBo);
            dataUtils.setGalaxyTransferNftInfoBo(reqDto.getRouterType(),reqDto.getTransOrderId(),transferNftInfoBo);
        }else{
            //判断藏品当前拥有者是否匹配
            if(transferNftInfoBo.getUserId().equalsIgnoreCase(reqDto.getUserId())){
                if(transferNftInfoBo.getTransferStatus().equalsIgnoreCase(GalaxyEnum.NftTransferStatusEnum.PROCESSING.getCode())){
                    transferNftInfoBo.setErrorCode(GalaxyErrorEnum.NFT_TRANSFERING_ERROR.getCode());
                    transferNftInfoBo.setErrorMsg(GalaxyErrorEnum.NFT_TRANSFERING_ERROR.getMessage());
                    transferNftInfoBo.setUpdatedAt(DateUtil.getNowTime());
                    dataUtils.updateTransferNftInfoBo(reqDto.getRouterType(),reqDto.getTransOrderId(),transferNftInfoBo);

                    return ResponseDto.failure(GalaxyErrorEnum.NFT_TRANSFERING_ERROR.getCode(), GalaxyErrorEnum.NFT_TRANSFERING_ERROR.getMessage());
                }else if(transferNftInfoBo.getTransferStatus().equalsIgnoreCase(GalaxyEnum.NftTransferStatusEnum.SUCCESS.getCode())){
                    GalaxyNftTransferRespDto galaxyNftTransferRespDto = galaxyBeanTransferBiz.buildNftTransferRespDto(reqDto,userInfoBo,receiveUserInfoBo,transferNftInfoBo);
                    return ResponseDto.success(galaxyNftTransferRespDto);
                }else if(transferNftInfoBo.getTransferStatus().equalsIgnoreCase(GalaxyEnum.NftTransferStatusEnum.FAIL.getCode())){
                    return ResponseDto.failure(GalaxyErrorEnum.NFT_TRANSFER_FAIL.getCode(), GalaxyErrorEnum.NFT_TRANSFER_FAIL.getMessage());
                }
            }else{
                transferNftInfoBo.setErrorCode(GalaxyErrorEnum.NFT_TRANSFER_OWNER_MATCH_ERROR.getCode());
                transferNftInfoBo.setErrorMsg(GalaxyErrorEnum.NFT_TRANSFER_OWNER_MATCH_ERROR.getMessage());
                transferNftInfoBo.setUpdatedAt(DateUtil.getNowTime());
                dataUtils.updateTransferNftInfoBo(reqDto.getRouterType(),reqDto.getTransOrderId(),transferNftInfoBo);
                return ResponseDto.failure(GalaxyErrorEnum.NFT_TRANSFER_OWNER_MATCH_ERROR.getCode(), GalaxyErrorEnum.NFT_TRANSFER_OWNER_MATCH_ERROR.getMessage());
            }
        }

        //资产id
        Long assetId = null;
        //碎片id
        Long shardId = null;

        //拆分nftId 格式 {assetId_shardId}
        if(StringUtil.isNotEmpty(transferNftInfoBo.getNftId())){
            assetId = Long.parseLong(transferNftInfoBo.getNftId().substring(0,reqDto.getNftId().lastIndexOf("_")));
            shardId = Long.parseLong(transferNftInfoBo.getNftId().substring(reqDto.getNftId().lastIndexOf("_")+1,reqDto.getNftId().length()));
        }else{
            return ResponseDto.failure(GalaxyErrorEnum.NFT_TRANSFER_NFTID_FORMAT_ERROR.getCode(), GalaxyErrorEnum.NFT_TRANSFER_NFTID_FORMAT_ERROR.getMessage());
        }

        //nft信息核对
        if(StringUtil.isNotNull(assetId)&&StringUtil.isNotNull(shardId)){
            boolean checkNftOwnerFlag = this.checkNftOwner(userInfoBo,reqDto.getNftId(),assetId,shardId);
            log.info("nftTransfer checkNftOwnerFlag:{}",checkNftOwnerFlag);
            //拥有者匹配 可以转让
            if(checkNftOwnerFlag){

                Xuper008TransferShardReqDto xuper008TransferShardReqDto = Xuper008TransferShardReqDto.getNew();
                // 定义返回结果对象
                Xuper008TransferShardRespDto xuper008TransferShardRespDto = null;

                try {
                    xuper008TransferShardReqDto.setMnemonic(userInfoBo.getMnemonic());
                    xuper008TransferShardReqDto.setAssetId(assetId);
                    xuper008TransferShardReqDto.setShardId(shardId);
                    xuper008TransferShardReqDto.setToAddr(xuperSdkUtil.getAccount(receiveUserInfoBo.getMnemonic()).getAddress());
                    xuper008TransferShardReqDto.setToUserId(Long.parseLong(String.valueOf(receiveUserInfoBo.getUserId().hashCode())));
                    xuper008TransferShardReqDto.setPrice(0l);

                    XuperResponseDto<Xuper008TransferShardRespDto>  transferResponseDto = xuperSdkUtil.xuper008TransferShard(xuper008TransferShardReqDto);
                    if(transferResponseDto.isSuccess()){
                        xuper008TransferShardRespDto = transferResponseDto.getParseData(Xuper008TransferShardRespDto.class);
                        if(String.valueOf(xuper008TransferShardRespDto.getErrNo()).equalsIgnoreCase(ErrorCode.SUCCESS.getCode())){
                            //更新转让状态和拥有者信息(只有成功才更新拥有者信息)
                            transferNftInfoBo.setTransferStatus(GalaxyEnum.NftTransferStatusEnum.PROCESSING.getCode());
                            transferNftInfoBo.setUpdatedAt(DateUtil.getNowTime());
                            dataUtils.updateTransferNftInfoBo(reqDto.getRouterType(),reqDto.getTransOrderId(),transferNftInfoBo);

                            //构造返回结果
                            GalaxyNftTransferRespDto galaxyNftTransferRespDto = galaxyBeanTransferBiz.buildNftTransferRespDto(reqDto,userInfoBo,receiveUserInfoBo,transferNftInfoBo);
                            return ResponseDto.success(galaxyNftTransferRespDto);
                        }
                    }
                }catch (XupterException e) {
                    log.error("biz error msg "+e.getMessage(),e);
                }catch (Exception e) {
                    log.error("sys error msg "+e.getMessage(),e);
                }
                log.info("testXuper008TransferShard resp : "+ JsonUtils.toJson(xuper008TransferShardRespDto));
            }else{
                //更新转让状态和拥有者信息(只有成功才更新拥有者信息)
                transferNftInfoBo.setTransferStatus(GalaxyEnum.NftTransferStatusEnum.FAIL.getCode());
                transferNftInfoBo.setErrorCode(GalaxyErrorEnum.NFT_TRANSFER_OWNER_MATCH_ERROR.getCode());
                transferNftInfoBo.setErrorMsg(GalaxyErrorEnum.NFT_TRANSFER_OWNER_MATCH_ERROR.getMessage());
                transferNftInfoBo.setUpdatedAt(DateUtil.getNowTime());
                dataUtils.updateTransferNftInfoBo(reqDto.getRouterType(),reqDto.getTransOrderId(),transferNftInfoBo);
                return ResponseDto.failure(GalaxyErrorEnum.NFT_TRANSFER_OWNER_MATCH_ERROR.getCode(), GalaxyErrorEnum.NFT_TRANSFER_OWNER_MATCH_ERROR.getMessage());
            }
        }
        return ResponseDto.failure(GalaxyErrorEnum.NFT_TRANSFER_FAIL.getCode(), GalaxyErrorEnum.NFT_TRANSFER_FAIL.getMessage());
    }

    /**
     * nft转让结果查询
     * @param reqDto
     * @return
     */
    public ResponseDto<GalaxyNftTransferQueryRespDto> nftTransferQuery(GalaxyNftTransferQueryReqDto reqDto) {
        GalaxyTransferNftInfoBo transferNftInfoBo = dataUtils.getGalaxyTransferNftInfoBo(reqDto.getRouterType(),reqDto.getTransOrderId());
        //初始化转让信息
        if(transferNftInfoBo==null){
            return ResponseDto.failure(GalaxyErrorEnum.NFT_TRANSFER_QUERY_ERROR.getCode(),GalaxyErrorEnum.NFT_TRANSFER_QUERY_ERROR.getMessage());
        }
        if(transferNftInfoBo.getTransferStatus().equalsIgnoreCase(GalaxyEnum.NftTransferStatusEnum.SUCCESS.getCode())){
            GalaxyNftTransferQueryRespDto nftTransferQueryRespDto = galaxyBeanTransferBiz.buildNftTransferQueryRespDto(transferNftInfoBo);
            nftTransferQueryRespDto.setTransferStatus(GalaxyEnum.NftTransferStatusEnum.SUCCESS.getCode());
            return ResponseDto.success(nftTransferQueryRespDto);
        }else if(transferNftInfoBo.getTransferStatus().equalsIgnoreCase(GalaxyEnum.NftTransferStatusEnum.PROCESSING.getCode())){
            //获取用户信息
            GalaxyUserInfoBo receiveUserInfoBo = dataUtils.getGalaxyUserInfo(reqDto.getRouterType(),transferNftInfoBo.getReceiveUserId());
            if(StringUtil.isNull(receiveUserInfoBo)){
                log.error("开始执行 nftTransfer nft receiver not exist error msg:{}",GalaxyErrorEnum.NFT_TRANSFER_FAIL_RECEIVER_NOT_EXIST.getMessage());
                return ResponseDto.failure(GalaxyErrorEnum.NFT_TRANSFER_FAIL_RECEIVER_NOT_EXIST.getCode(), GalaxyErrorEnum.NFT_TRANSFER_FAIL_RECEIVER_NOT_EXIST.getMessage());
            }
            //查询获取交易hash
            String transferHash = this.getTransferHash(receiveUserInfoBo,transferNftInfoBo.getNftId());
            GalaxyNftTransferQueryRespDto nftTransferQueryRespDto = galaxyBeanTransferBiz.buildNftTransferQueryRespDto(transferNftInfoBo);
            if(StringUtil.isNotEmpty(transferHash)){
                //更新转让成功信息
                transferNftInfoBo.setOwnerUserId(transferNftInfoBo.getReceiveUserId());
                transferNftInfoBo.setOwnerAddress(transferNftInfoBo.getReceiveAddress());
                transferNftInfoBo.setTransferStatus(GalaxyEnum.NftTransferStatusEnum.SUCCESS.getCode());
                transferNftInfoBo.setTransferHash(transferHash);
                transferNftInfoBo.setUpdatedAt(DateUtil.getNowTime());
                dataUtils.updateTransferNftInfoBo(reqDto.getRouterType(),reqDto.getTransOrderId(),transferNftInfoBo);

                nftTransferQueryRespDto.setTransferStatus(GalaxyEnum.NftTransferStatusEnum.SUCCESS.getCode());
                nftTransferQueryRespDto.setTransferHash(transferHash);
            }else{
                nftTransferQueryRespDto.setTransferStatus(GalaxyEnum.NftTransferStatusEnum.PROCESSING.getCode());
            }
            return ResponseDto.success(nftTransferQueryRespDto);
        }else {
            return ResponseDto.failure(GalaxyErrorEnum.NFT_TRANSFER_QUERY_ERROR.getCode(),GalaxyErrorEnum.NFT_TRANSFER_QUERY_ERROR.getMessage());
        }
    }

    /**
     * 核对nft当前拥有者是否匹配
     * @param userInfoBo
     * @param nftId
     * @param assetId
     * @param shardId
     * @return
     */
    private Boolean checkNftOwner(GalaxyUserInfoBo userInfoBo,String nftId,Long assetId,Long shardId){
        Boolean checkNftOwner = false;
        //判断nftid是否状态正常
        Xuper010QuerySdsReqDto xuper010QuerySdsReqDto = Xuper010QuerySdsReqDto.getNew();
        xuper010QuerySdsReqDto.setAssetId(assetId);
        xuper010QuerySdsReqDto.setShardId(shardId);
        XuperResponseDto<Xuper010QuerySdsRespDto>  xuperResponseDto = xuperSdkUtil.xuper010QuerySds(xuper010QuerySdsReqDto);
        Xuper010QuerySdsRespDto xuper010QuerySdsRespDto = null;
        if(xuperResponseDto.isSuccess()){
            xuper010QuerySdsRespDto = xuperResponseDto.getParseData(Xuper010QuerySdsRespDto.class);

            Xuper010QuerySdsRespDto.ShardMeta shardMeta = xuper010QuerySdsRespDto.getMeta();
            //已上链
            if(shardMeta.getStatus() == Integer.parseInt(XuperEnum.AssetGrantStatusEnum.GRANT_SUCCESS.getCode())){
                if(shardMeta.getOwnerAddr().equalsIgnoreCase(userInfoBo.getBlockChainAddress())){
                    checkNftOwner = true;
                }
            }
        }else{
            log.error("nftTransfer error : nftId:{} not exits on xuper blockchain :{} ",nftId,JsonUtils.toJson(xuperResponseDto));
        }
        return checkNftOwner;
    }

    /**
     * 获取转让成功后的hash值
     * @param receiveUserInfoBo
     * @param nftId
     * @return
     */
    private String getTransferHash(GalaxyUserInfoBo receiveUserInfoBo,String nftId){
        //资产id
        Long assetId = null;
        //碎片id
        Long shardId = null;

        if(StringUtil.isNotEmpty(nftId)){
            assetId = Long.parseLong(nftId.substring(0,nftId.lastIndexOf("_")));
            shardId = Long.parseLong(nftId.substring(nftId.lastIndexOf("_")+1,nftId.length()));
        }

        String transferHash = null;
        //判断nftid是否状态正常
        Xuper010QuerySdsReqDto xuper010QuerySdsReqDto = Xuper010QuerySdsReqDto.getNew();
        xuper010QuerySdsReqDto.setAssetId(assetId);
        xuper010QuerySdsReqDto.setShardId(shardId);
        XuperResponseDto<Xuper010QuerySdsRespDto>  xuperResponseDto = xuperSdkUtil.xuper010QuerySds(xuper010QuerySdsReqDto);
        Xuper010QuerySdsRespDto xuper010QuerySdsRespDto = null;
        if(xuperResponseDto.isSuccess()){
            xuper010QuerySdsRespDto = xuperResponseDto.getParseData(Xuper010QuerySdsRespDto.class);

            Xuper010QuerySdsRespDto.ShardMeta shardMeta = xuper010QuerySdsRespDto.getMeta();
            //已上链
            if(shardMeta.getStatus() == Integer.parseInt(XuperEnum.AssetGrantStatusEnum.GRANT_SUCCESS.getCode())){
                 //转让成功后，拥有者已变更为接收者的地址，但是交易hash未变
                if(shardMeta.getOwnerAddr().equalsIgnoreCase(receiveUserInfoBo.getBlockChainAddress())){
                    transferHash = shardMeta.getTxId();
                }
            }
        }else{
            log.error("getTransferHash error : nftId:{} not exits on xuper blockchain :{} ",nftId,JsonUtils.toJson(xuperResponseDto));
        }
        return transferHash;
    }
}
