package com.liquidnet.client.admin.web.controller.zhengzai.stone;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.stone.service.IItemService;
import com.liquidnet.service.stone.entity.StoneScoreItems;
import com.liquidnet.service.stone.param.StoneItemBuildParam;
import com.liquidnet.service.stone.param.StoneListParam;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

@Api(tags = "积分物品")
@Controller
@RequestMapping("stone/item")
public class StoneItemController extends BaseController {
    private String prefix = "zhengzai/stone/item";

    @Autowired
    private IItemService iItemService;


    @Log(title = "积分商品:列表")
    @GetMapping("list")
    @ResponseBody
    public TableDataInfo list(StoneListParam listParam) {
        PageInfo<StoneScoreItems> result = iItemService.itemList(listParam.getTitle(), listParam.getState(), listParam.getType());
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(0);
        rspData.setRows(result.getList());
        rspData.setTotal(result.getTotal());
        return rspData;
    }

    @Log(title = "积分商品:修改状态")
    @PostMapping("change/status")
    @ResponseBody
    public AjaxResult status(@RequestParam("itemId") String itemId, @RequestParam("status") Integer status) {
        String result = iItemService.changeStatus(itemId, status);
        return AjaxResult.success(result);
    }

    @Log(title = "积分商品:详情")
    @PostMapping("details")
    @ResponseBody
    public AjaxResult details(@RequestParam("itemId") String itemId) {
        StoneScoreItems result = iItemService.itemDetails(itemId);
        return AjaxResult.success(result);
    }

    @Log(title = "积分商品:创建")
    @PostMapping("")
    @ResponseBody
    public AjaxResult createItem(StoneItemBuildParam param) {
        String result = iItemService.createItem(param);
        return AjaxResult.success(result);
    }

    @Log(title = "积分商品:修改")
    @PutMapping("")
    @ResponseBody
    public AjaxResult updateItem(StoneItemBuildParam param) {
        String result = iItemService.updateItem(param);
        return AjaxResult.success(result);
    }
}
