package com.liquidnet.client.admin.zhengzai.stone.service.utils;

import com.liquidnet.client.admin.zhengzai.kylin.utils.MongoVoUtils;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketEntitiesVo;
import com.liquidnet.service.stone.constant.StoneConstant;
import com.liquidnet.service.stone.entity.StoneScoreItems;
import com.mongodb.client.result.UpdateResult;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

@Component
public class StoneMongoUtils {

    @Autowired
    private MongoTemplate mongoTemplate;

    /**
     * 创建 积分物品
     * @param data
     * @return
     */
    public Object itemCreate(StoneScoreItems data) {
        return mongoTemplate.insert(data, StoneScoreItems.class.getSimpleName());
    }

    /**
     * 根据积分物品id修改
     * @param data
     * @return
     */
    public Object itemUpdateById(StoneScoreItems data) {
        Query query = Query.query(Criteria.where("itemId").is(data.getItemId()));
        Update update = Update.fromDocument(Document.parse(JsonUtils.toJson(data)));
        UpdateResult result = mongoTemplate.updateFirst(query, update, StoneScoreItems.class, StoneScoreItems.class.getSimpleName());
        return result;
    }
}
