package com.liquidnet.common.third.zxlnft.service.impl;

import com.liquidnet.common.third.zxlnft.biz.ZxlnftBiz;
import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.common.third.zxlnft.constant.ZxlnftConstant;
import com.liquidnet.common.third.zxlnft.dto.nft.*;
import com.liquidnet.common.third.zxlnft.service.ZxlnftSdkService;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
public class ZxlnftSdkServiceImpl implements ZxlnftSdkService
{
    @Autowired
    private ZxlnftConfig zxlnftConfig;

    @Autowired
    private ZxlnftBiz zxlnftBiz;

    private MultiValueMap<String, String> commonHeader = new LinkedMultiValueMap();

    @Override
    public Nft001RegisterVerifyCodeResp nft001RegisterVerifyCode(Nft001RegisterVerifyCodeReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_001_REGISTER_VERIFY_CODE_URL;
        log.info("nft001RegisterVerifyCode--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft001RegisterVerifyCode error", e);
        }catch (Exception e) {
            log.error("nft001RegisterVerifyCode error",e);
        }
        log.info("nft001RegisterVerifyCode--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft001RegisterVerifyCodeResp resp = zxlnftBiz.buildNftRespObj(response,Nft001RegisterVerifyCodeResp.class);

        log.info("nft001RegisterVerifyCode--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft002RegisterPersonResp nft002RegisterPerson(Nft002RegisterPersonReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_002_REGISTER_PERSON_URL;
        log.info("nft002RegisterPerson--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft002RegisterPerson error", e);
        }catch (Exception e) {
            log.error("nft002RegisterPerson error",e);
        }
        log.info("nft002RegisterPerson--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft002RegisterPersonResp resp = zxlnftBiz.buildNftRespObj(response,Nft002RegisterPersonResp.class);

        log.info("nft002RegisterPerson--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft003RegisterPersonPlatformResp nft003RegisterPersonPlatform(Nft003RegisterPersonPlatformReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_003_REGISTER_PERSON_PLATFORM_URL;
        log.info("nft003RegisterPersonPlatform--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft003RegisterPersonPlatform error:",e);
        }catch (Exception e) {
            log.error("nft003RegisterPersonPlatform error:",e);
        }
        log.info("nft003RegisterPersonPlatform--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft003RegisterPersonPlatformResp resp = zxlnftBiz.buildNftRespObj(response,Nft003RegisterPersonPlatformResp.class);

        log.info("nft003RegisterPersonPlatform--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft004BusinessLicenseUploadResp nft004BusinessLicenseUpload(Nft004BusinessLicenseUploadReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_004_BUSINESS_LICENSE_UPLOAD_URL;
        log.info("nft004BusinessLicenseUpload--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft004BusinessLicenseUpload error", e);
        }catch (Exception e) {
            log.error("nft004BusinessLicenseUpload error",e);
        }
        log.info("nft004BusinessLicenseUpload--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft004BusinessLicenseUploadResp resp = zxlnftBiz.buildNftRespObj(response,Nft004BusinessLicenseUploadResp.class);

        log.info("nft004BusinessLicenseUpload--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft005BusinessLicenseUploadPlatformResp nft005BusinessLicenseUploadPlatform(Nft005BusinessLicenseUploadPlatformReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_005_BUSINESS_LICENSE_UPLOAD_PLATFORM_URL;
        log.info("nft005BusinessLicenseUploadPlatform--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft005BusinessLicenseUploadPlatform error", e);
        }catch (Exception e) {
            log.error("nft005BusinessLicenseUploadPlatform error",e);
        }
        log.info("nft005BusinessLicenseUploadPlatform--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft005BusinessLicenseUploadPlatformResp resp = zxlnftBiz.buildNftRespObj(response,Nft005BusinessLicenseUploadPlatformResp.class);

        log.info("nft005BusinessLicenseUploadPlatform--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft006OfficialLetterUploadResp nft006OfficialLetterUpload(Nft006OfficialLetterUploadReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_006_OFFICIAL_LETTER_UPLOAD_URL;
        log.info("nft006OfficialLetterUpload--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft006OfficialLetterUpload error", e);
        }catch (Exception e) {
            log.error("nft006OfficialLetterUpload error",e);
        }
        log.info("nft006OfficialLetterUpload--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft006OfficialLetterUploadResp resp = zxlnftBiz.buildNftRespObj(response,Nft006OfficialLetterUploadResp.class);

        log.info("nft006OfficialLetterUpload--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft007OfficialLetterUploadPlatformResp nft007OfficialLetterUploadPlatform(Nft007OfficialLetterUploadPlatformReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_007_OFFICIAL_LETTER_UPLOAD_PLATFORM_URL;
        log.info("nft007OfficialLetterUploadPlatform--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft007OfficialLetterUploadPlatform error", e);
        }catch (Exception e) {
            log.error("nft007OfficialLetterUploadPlatform error",e);
        }
        log.info("nft007OfficialLetterUploadPlatform--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft007OfficialLetterUploadPlatformResp resp = zxlnftBiz.buildNftRespObj(response,Nft007OfficialLetterUploadPlatformResp.class);

        log.info("nft007OfficialLetterUploadPlatform--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft008QueryImageModerationResp nft008QueryImageModeration(Nft008QueryImageModerationReq req) {

        zxlnftBiz.buildPlatFormHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_008_QUERY_IMAGE_MODERATION_URL;
        log.info("nft008QueryImageModeration--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft008QueryImageModeration error", e);
        }catch (Exception e) {
            log.error("nft008QueryImageModeration error",e);
        }
        log.info("nft008QueryImageModeration--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft008QueryImageModerationResp resp = zxlnftBiz.buildNftRespObj(response,Nft008QueryImageModerationResp.class);

        log.info("nft008QueryImageModeration--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft009RegisterCompanyResp nft009RegisterCompany(Nft009RegisterCompanyReq req) {

        zxlnftBiz.buildHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_009_REGISTER_COMPANY_URL;
        log.info("nft009RegisterCompany--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft009RegisterCompany error", e);
        }catch (Exception e) {
            log.error("nft009RegisterCompany error",e);
        }
        log.info("nft009RegisterCompany--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft009RegisterCompanyResp resp = zxlnftBiz.buildNftRespObj(response,Nft009RegisterCompanyResp.class);

        log.info("nft009RegisterCompany--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft010RegisterCompanyPlatformResp nft010RegisterCompanyPlatform(Nft010RegisterCompanyPlatformReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_010_REGISTER_COMPANY_PLATFORM_URL;
        log.info("nft010RegisterCompanyPlatform--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft010RegisterCompanyPlatform error", e);
        }catch (Exception e) {
            log.error("nft010RegisterCompanyPlatform error",e);
        }
        log.info("nft010RegisterCompanyPlatform--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft010RegisterCompanyPlatformResp resp = zxlnftBiz.buildNftRespObj(response,Nft010RegisterCompanyPlatformResp.class);

        log.info("nft010RegisterCompanyPlatform--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft011UserQueryVerifyCodeResp nft011UserQueryVerifyCode(Nft011UserQueryVerifyCodeReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_011_USER_QUERY_VERIFY_CODE_URL;
        log.info("nft011UserQueryVerifyCode--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft011UserQueryVerifyCode error", e);
        }catch (Exception e) {
            log.error("nft011UserQueryVerifyCode error",e);
        }
        log.info("nft011UserQueryVerifyCode--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft011UserQueryVerifyCodeResp resp = zxlnftBiz.buildNftRespObj(response,Nft011UserQueryVerifyCodeResp.class);

        log.info("nft011UserQueryVerifyCode--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft012UserQueryResp nft012UserQuery(Nft012UserQueryReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_012_USER_QUERY_URL;
        log.info("nft012UserQuery--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft012UserQueryReq.class,req);
        log.info("nft012UserQuery--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft012UserQuery error", e);
        }catch (Exception e) {
            log.error("nft012UserQuery error",e);
        }
        log.info("nft012UserQuery--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft012UserQueryResp resp = zxlnftBiz.buildNftRespObj(response,Nft012UserQueryResp.class);

        log.info("nft012UserQuery--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft013IdentityBindSubmitResp nft013IdentityBindSubmit(Nft013IdentityBindSubmitReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_013_IDENTITY_BIND_SUBMIT_URL;
        log.info("nft013IdentityBindSubmit--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft013IdentityBindSubmit error", e);
        }catch (Exception e) {
            log.error("nft013IdentityBindSubmit error",e);
        }
        log.info("nft013IdentityBindSubmit--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft013IdentityBindSubmitResp resp = zxlnftBiz.buildNftRespObj(response,Nft013IdentityBindSubmitResp.class);

        log.info("nft013IdentityBindSubmit--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft014IdentityBindSubmitByTrustedResp nft014IdentityBindSubmitByTrusted(Nft014IdentityBindSubmitByTrustedReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_014_IDENTITY_BIND_SUBMIT_BY_TRUSTED_URL;
        log.info("nft014IdentityBindSubmitByTrusted--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft014IdentityBindSubmitByTrusted error", e);
        }catch (Exception e) {
            log.error("nft014IdentityBindSubmitByTrusted error",e);
        }
        log.info("nft014IdentityBindSubmitByTrusted--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        String address = zxlnftBiz.buildNftRespObj(response,String.class,false);
        Nft014IdentityBindSubmitByTrustedResp resp = Nft014IdentityBindSubmitByTrustedResp.getNew();
        resp.setAddress(address);
        log.info("nft014IdentityBindSubmitByTrusted--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft015IdentityBindPlatformSelfResp nft015IdentityBindPlatformSelf(Nft015IdentityBindPlatformSelfReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_015_IDENTITY_BIND_PLATFORM_SELF_URL;
        log.info("nft015IdentityBindPlatformSelf--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft015IdentityBindPlatformSelf error", e);
        }catch (Exception e) {
            log.error("nft015IdentityBindPlatformSelf error",e);
        }
        log.info("nft015IdentityBindPlatformSelf--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft015IdentityBindPlatformSelfResp resp = zxlnftBiz.buildNftRespObj(response,Nft015IdentityBindPlatformSelfResp.class);

        log.info("nft015IdentityBindPlatformSelf--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft016IdentityBindQueryResp nft016IdentityBindQuery(Nft016IdentityBindQueryReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        MultiValueMap<String, Object> params = new LinkedMultiValueMap();
        List<String> addressList = new ArrayList();
        addressList.add(req.getAddressList());
        params.add("addressList", addressList);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_016_IDENTITY_BIND_QUERY_URL;
        log.info("nft016IdentityBindQuery--->>> request url : {}  body : {} ",requestUrl, params.toString());

        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.get(requestUrl+"?addressList="+req.getAddressList(),null,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft016IdentityBindQuery error", e);
        }catch (Exception e) {
            log.error("nft016IdentityBindQuery error",e);
        }
        log.info("nft016IdentityBindQuery--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft016IdentityBindQueryResp resp = zxlnftBiz.buildNftRespObj(response,Nft016IdentityBindQueryResp.class);

        log.info("nft016IdentityBindQuery--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft017IdentityVerifyIdentityResp nft017IdentityVerifyIdentity(Nft017IdentityVerifyIdentityReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_017_IDENTITY_VERIFY_IDENTITY_URL;
        log.info("nft017IdentityVerifyIdentity--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft017IdentityVerifyIdentity error", e);
        }catch (Exception e) {
            log.error("nft017IdentityVerifyIdentity error",e);
        }
        log.info("nft017IdentityVerifyIdentity--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft017IdentityVerifyIdentityResp resp = zxlnftBiz.buildNftRespObj(response,Nft017IdentityVerifyIdentityResp.class);

        log.info("nft017IdentityVerifyIdentity--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft018FaceUrlResp nft018FaceUrl(Nft018FaceUrlReq req){
        zxlnftBiz.buildHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_018_FACE_URL_URL;
        log.info("nft018FaceUrl--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft018FaceUrl error", e);
        }catch (Exception e) {
            log.error("nft018FaceUrl error",e);
        }
        log.info("nft018FaceUrl--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft018FaceUrlResp resp = zxlnftBiz.buildNftRespObj(response,Nft018FaceUrlResp.class);

        log.info("nft018FaceUrl--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft019FaceUrlByAddressResp nft019FaceUrlByAddress(Nft019FaceUrlByAddressReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_019_FACE_URL_BY_ADDRESS_URL;
        log.info("nft019FaceUrlByAddress--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft019FaceUrlByAddress error", e);
        }catch (Exception e) {
            log.error("nft019FaceUrlByAddress error",e);
        }
        log.info("nft019FaceUrlByAddress--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft019FaceUrlByAddressResp resp = zxlnftBiz.buildNftRespObj(response,Nft019FaceUrlByAddressResp.class);

        log.info("nft019FaceUrlByAddress--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft020FaceQueryResp nft020FaceQuery(Nft020FaceQueryReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_020_FACE_QUERY_URL;
        log.info("nft020FaceQuery--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft020FaceQueryReq.class,req);
        log.info("nft020FaceQuery--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft020FaceQuery error", e);
        }catch (Exception e) {
            log.error("nft020FaceQuery error",e);
        }
        log.info("nft020FaceQuery--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft020FaceQueryResp resp = zxlnftBiz.buildNftRespObj(response,Nft020FaceQueryResp.class);

        log.info("nft020FaceQuery--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft021UploadUrlResp nft021UploadUrl(Nft021UploadUrlReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_021_UPLOAD_URL_URL;
        log.info("nft021UploadUrl--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft021UploadUrlReq.class,req);
        log.info("nft021UploadUrl--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft021UploadUrl error", e);
        }catch (Exception e) {
            log.error("nft021UploadUrl error",e);
        }
        log.info("nft021UploadUrl--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft021UploadUrlResp resp = zxlnftBiz.buildNftRespObj(response,Nft021UploadUrlResp.class);

        log.info("nft021UploadUrl--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft022UploadSecretResp nft022UploadSecret(Nft022UploadSecretReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

//        MultiValueMap<String, Object> params = new LinkedMultiValueMap();
//        List<String> addressList = new ArrayList();
//        if(StringUtil.isNotEmpty(req.getSeriesName())){
//            params.add("seriesName", req.getSeriesName());
//        }
//        params.add("tiemstamp", req.getTiemstamp());
//        params.add("pubKey", req.getPubKey());
//        params.add("pubSignedData", req.getPubSignedData());
//        params.add("userPubKey", req.getUserPubKey());
//        params.add("userSignedData", req.getUserSignedData());

//        JSONObject json = new JSONObject();
//        if(StringUtil.isNotEmpty(req.getSeriesName())){
//            json.put("seriesName", req.getSeriesName());
//        }
//        json.put("timestamp", req.getTimestamp());
//        json.put("pubKey", req.getPubKey());
//        json.put("pubSignedData", req.getPubSignedData());
//        json.put("userPubKey", req.getUserPubKey());
//        json.put("userSignedData", req.getUserSignedData());

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_022_UPLOAD_SECRET_URL;
        log.info("nft022UploadSecret--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft022UploadSecret error", e);
        }catch (Exception e) {
            log.error("nft022UploadSecret error",e);
        }
        log.info("nft022UploadSecret--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft022UploadSecretResp resp = zxlnftBiz.buildNftRespObj(response,Nft022UploadSecretResp.class);
        log.info("nft022UploadSecret--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft023PointApplyResp nft023PointApply(Nft023PointApplyReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_023_POINT_APPLY_URL;
        log.info("nft023PointApply--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft023PointApply error", e);
        }catch (Exception e) {
            log.error("nft023PointApply error",e);
        }
        log.info("nft023PointApply--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft023PointApplyResp resp = zxlnftBiz.buildNftRespObj(response,Nft023PointApplyResp.class);

        log.info("nft023PointApply--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft024PointApplyResultResp nft024PointApplyResult(Nft024PointApplyResultReq req) {

        zxlnftBiz.buildPlatFormHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_024_POINT_APPLY_RESULT_URL;
        log.info("nft024PointApplyResult--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft024PointApplyResultReq.class,req);
        log.info("nft024PointApplyResult--->>> new request url : {} ",requestUrl);

        String response = null;
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft024PointApplyResult error", e);
        }catch (Exception e) {
            log.error("nft024PointApplyResult error",e);
        }
        log.info("nft024PointApplyResult--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft024PointApplyResultResp resp = zxlnftBiz.buildNftRespObj(response,Nft024PointApplyResultResp.class);

        log.info("nft024PointApplyResult--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft025PointTransferResp nft025PointTransfer(Nft025PointTransferReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_025_POINT_TRANSFER_URL;
        log.info("nft025PointTransfer--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft025PointTransfer error", e);
        }catch (Exception e) {
            log.error("nft025PointTransfer error",e);
        }
        log.info("nft025PointTransfer--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft025PointTransferResp resp = zxlnftBiz.buildNftRespObj(response,Nft025PointTransferResp.class);

        log.info("nft025PointTransfer--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft026PointTransferResultResp nft026PointTransferResult(Nft026PointTransferResultReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_026_POINT_TRANSFER_RESULT_URL;
        log.info("nft026PointTransferResult--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft026PointTransferResultReq.class,req);
        log.info("nft026PointTransferResult--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft026PointTransferResult error", e);
        }catch (Exception e) {
            log.error("nft026PointTransferResult error",e);
        }
        log.info("nft026PointTransferResult--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft026PointTransferResultResp resp = zxlnftBiz.buildNftRespObj(response,Nft026PointTransferResultResp.class);

        log.info("nft026PointTransferResult--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft027PointDestroyResp nft027PointDestroy(Nft027PointDestroyReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_027_POINT_DESTROY_URL;
        log.info("nft027PointDestroy--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft027PointDestroy error", e);
        }catch (Exception e) {
            log.error("nft027PointDestroy error",e);
        }
        log.info("nft027PointDestroy--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft027PointDestroyResp resp = zxlnftBiz.buildNftRespObj(response,Nft027PointDestroyResp.class);

        log.info("nft027PointDestroy--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft028PointDestoryResultResp nft028PointDestoryResult(Nft028PointDestoryResultReq req) {

        zxlnftBiz.buildPlatFormHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_028_POINT_DESTORY_RESULT_URL;
        log.info("nft028PointDestoryResult--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft028PointDestoryResultReq.class,req);
        log.info("nft028PointDestoryResult--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft028PointDestoryResult error", e);
        }catch (Exception e) {
            log.error("nft028PointDestoryResult error",e);
        }
        log.info("nft028PointDestoryResult--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft028PointDestoryResultResp resp = zxlnftBiz.buildNftRespObj(response,Nft028PointDestoryResultResp.class);

        log.info("nft028PointDestoryResult--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft029PointQueryResp nft029PointQuery(Nft029PointQueryReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_029_POINT_QUERY_URL;
        log.info("nft029PointQuery--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft029PointQueryReq.class,req);
        log.info("nft029PointQuery--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft029PointQuery error", e);
        }catch (Exception e) {
            log.error("nft029PointQuery error",e);
        }
        log.info("nft029PointQuery--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft029PointQueryResp resp = zxlnftBiz.buildNftRespObj(response,Nft029PointQueryResp.class);

        log.info("nft029PointQuery--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft030SeriesClaimResp nft030SeriesClaim(Nft030SeriesClaimReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_030_SERIES_CLAIM_URL;
        log.info("nft030SeriesClaim--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft030SeriesClaim error", e);
        }catch (Exception e) {
            log.error("nft030SeriesClaim error",e);
        }
        log.info("nft030SeriesClaim--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft030SeriesClaimResp resp = zxlnftBiz.buildNftRespObj(response,Nft030SeriesClaimResp.class);

        log.info("nft030SeriesClaim--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft031SeriesClaimResultResp nft031SeriesClaimResult(Nft031SeriesClaimResultReq req) {

        zxlnftBiz.buildPlatFormHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_031_SERIES_CLAIM_RESULT_URL;
        log.info("nft031SeriesClaimResult--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft031SeriesClaimResultReq.class,req);
        log.info("nft031SeriesClaimResult--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft031SeriesClaimResult error", e);
        }catch (Exception e) {
            log.error("nft031SeriesClaimResult error",e);
        }
        log.info("nft031SeriesClaimResult--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft031SeriesClaimResultResp resp = zxlnftBiz.buildNftRespObj(response,Nft031SeriesClaimResultResp.class);

        log.info("nft031SeriesClaimResult--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft032SeriesResp nft032Series(Nft032SeriesReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_032_SERIES_URL;
        log.info("nft032Series--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft032SeriesReq.class,req);
        log.info("nft032Series--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft032Series error", e);
        }catch (Exception e) {
            log.error("nft032Series error",e);
        }
        log.info("nft032Series--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft032SeriesResp resp = zxlnftBiz.buildNftRespObj(response,Nft032SeriesResp.class);

        log.info("nft032Series--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft033SeriesListResp nft033SeriesList(Nft033SeriesListReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_033_SERIES_LIST_URL;
        log.info("nft033SeriesList--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft033SeriesListReq.class,req);
        log.info("nft033SeriesList--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft033SeriesList error", e);
        }catch (Exception e) {
            log.error("nft033SeriesList error",e);
        }
        log.info("nft033SeriesList--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft033SeriesListResp resp = zxlnftBiz.buildNftRespObj(response,Nft033SeriesListResp.class);

        log.info("nft033SeriesList--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft034PublishResp nft034Publish(Nft034PublishReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_034_PUBLISH_URL;
        log.info("nft034Publish--->>> request url : {}  body : {} ",requestUrl,reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft034Publish error", e);
        }catch (Exception e) {
            log.error("nft034Publish error",e);
        }
        log.info("nft034Publish--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft034PublishResp resp = zxlnftBiz.buildNftRespObj(response,Nft034PublishResp.class);
        log.info("nft034Publish--->>> return result : {} ",resp.toString());
        return resp;

//        JSONObject json = new JSONObject();
//        json.put("pubKey", req.getPubKey());
//        json.put("platformPubKey", req.getPlatformPubKey());
//        json.put("author", req.getAuthor());
//        json.put("name", req.getName());
//        json.put("url", req.getUrl());
//        json.put("displayUrl", req.getDisplayUrl());
//        json.put("hash", req.getHash());
//        json.put("desc", req.getDesc());
//        json.put("flag", req.getFlag());
//        json.put("publishCount", req.getPublishCount());
//        json.put("seriesId", req.getSeriesId());
//        json.put("seriesBeginIndex", req.getSeriesBeginIndex());
//        json.put("sellStatus", req.getSellStatus());
//        json.put("sellCount", req.getSellCount());
//        json.put("operateId", req.getOperateId());
//        json.put("metaData", req.getMetaData());
//        json.put("signature", req.getSignature());
//        json.put("platformSignature", req.getPlatformSignature());
    }

    @Override
    public Nft035PublishResultResp nft035PublishResult(Nft035PublishResultReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_035_PUBLISH_RESULT_URL;
        log.info("nft035PublishResult--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft035PublishResultReq.class,req);
        log.info("nft035PublishResult--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft035PublishResult error", e);
        }catch (Exception e) {
            log.error("nft035PublishResult error",e);
        }
        log.info("nft035PublishResult--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft035PublishResultResp resp = zxlnftBiz.buildNftRespObj(response, Nft035PublishResultResp.class);
        log.info("nft035PublishResult--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft036InfoResp nft036Info(Nft036InfoReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_036_INFO_URL;
        log.info("nft036Info--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft036InfoReq.class,req);
        log.info("nft036Info--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft036Info error", e);
        }catch (Exception e) {
            log.error("nft036Info error",e);
        }
        log.info("nft036Info--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft036InfoResp resp = zxlnftBiz.buildNftRespObj(response,Nft036InfoResp.class);

        log.info("nft036Info--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft037AddressListResp nft037AddressList(Nft037AddressListReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_037_ADDRESS_LIST_URL;
        log.info("nft037AddressList--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft037AddressListReq.class,req);
        log.info("nft037AddressList--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft037AddressList error", e);
        }catch (Exception e) {
            log.error("nft037AddressList error",e);
        }
        log.warn("nft037AddressList--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft037AddressListResp resp = zxlnftBiz.buildNftRespObj(response,Nft037AddressListResp.class);

        log.warn("nft037AddressList--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft038AddressWithoutSeriesListResp nft038AddressWithoutSeriesList(Nft038AddressWithoutSeriesListReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_038_ADDRESS_WITHOUT_SERIES_LIST_URL;
        log.info("nft038AddressWithoutSeriesList--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft038AddressWithoutSeriesListReq.class,req);
        log.info("nft038AddressWithoutSeriesList--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft038AddressWithoutSeriesList error", e);
        }catch (Exception e) {
            log.error("nft038AddressWithoutSeriesList error",e);
        }
        log.info("nft038AddressWithoutSeriesList--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft038AddressWithoutSeriesListResp resp = zxlnftBiz.buildNftRespObj(response,Nft038AddressWithoutSeriesListResp.class);

        log.info("nft038AddressWithoutSeriesList--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft039TradeListResp nft039TradeList(Nft039TradeListReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_039_TRADE_LIST_URL;
        log.info("nft039TradeList--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft039TradeListReq.class,req);
        log.info("nft039TradeList--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft039TradeList error", e);
        }catch (Exception e) {
            log.error("nft039TradeList error",e);
        }
        log.info("nft039TradeList--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft039TradeListResp resp = zxlnftBiz.buildNftRespObj(response,Nft039TradeListResp.class);

        log.info("nft039TradeList--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft040TradeInListResp nft040TradeInList(Nft040TradeInListReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_040_TRADE_IN_LIST_URL;
        log.info("nft040TradeInList--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft040TradeInListReq.class,req);
        log.info("nft040TradeInList--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft040TradeInList error", e);
        }catch (Exception e) {
            log.error("nft040TradeInList error",e);
        }
        log.info("nft040TradeInList--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft040TradeInListResp resp = zxlnftBiz.buildNftRespObj(response,Nft040TradeInListResp.class);

        log.info("nft040TradeInList--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft041TradeOutListResp nft041TradeOutList(Nft041TradeOutListReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_041_TRADE_OUT_LIST_URL;
        log.info("nft041TradeOutList--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft041TradeOutListReq.class,req);
        log.info("nft041TradeOutList--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft041TradeOutList error", e);
        }catch (Exception e) {
            log.error("nft041TradeOutList error",e);
        }
        log.info("nft041TradeOutList--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft041TradeOutListResp resp = zxlnftBiz.buildNftRespObj(response,Nft041TradeOutListResp.class);

        log.info("nft041TradeOutList--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft042TradeAllListResp nft042TradeAllList(Nft042TradeAllListReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_042_TRADE_ALL_LIST_URL;
        log.info("nft042TradeAllList--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft042TradeAllListReq.class,req);
        log.info("nft042TradeAllList--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft042TradeAllList error", e);
        }catch (Exception e) {
            log.error("nft042TradeAllList error",e);
        }
        log.info("nft042TradeAllList--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft042TradeAllListResp resp = zxlnftBiz.buildNftRespObj(response,Nft042TradeAllListResp.class);

        log.info("nft042TradeAllList--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft043BuyResp nft043Buy(Nft043BuyReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_043_BUY_URL;
        log.info("nft043Buy--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft043Buy error", e);
        }catch (Exception e) {
            log.error("nft043Buy error",e);
        }
        log.info("nft043Buy--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft043BuyResp resp = zxlnftBiz.buildNftRespObj(response,Nft043BuyResp.class);

        log.info("nft043Buy--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft044BuyResultResp nft044BuyResult(Nft044BuyResultReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_044_BUY_RESULT_URL;
        log.info("nft044BuyResult--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft044BuyResultReq.class,req);
        log.info("nft044BuyResult--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft044BuyResult error", e);
        }catch (Exception e) {
            log.error("nft044BuyResult error",e);
        }
        log.info("nft044BuyResult--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft044BuyResultResp resp = zxlnftBiz.buildNftRespObj(response,Nft044BuyResultResp.class);

        log.info("nft044BuyResult--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft045BuyPayResultResp nft045BuyPayResult(Nft045BuyPayResultReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_045_BUY_PAY_RESULT_URL;
        log.info("nft045BuyPayResult--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft045BuyPayResultReq.class,req);
        log.info("nft045BuyPayResult--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft045BuyPayResult error", e);
        }catch (Exception e) {
            log.error("nft045BuyPayResult error",e);
        }
        log.info("nft045BuyPayResult--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft045BuyPayResultResp resp = zxlnftBiz.buildNftRespObj(response,Nft045BuyPayResultResp.class);

        log.info("nft045BuyPayResult--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft046TransferResp nft046Transfer(Nft046TransferReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_046_TRANSFER_URL;
        log.info("nft046Transfer--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft046Transfer error", e);
        }catch (Exception e) {
            log.error("nft046Transfer error",e);
        }
        log.info("nft046Transfer--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft046TransferResp resp = zxlnftBiz.buildNftRespObj(response,Nft046TransferResp.class);

        log.info("nft046Transfer--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft046TransferResp nft046TransferV2(Nft046TransferReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_046_TRANSFER_URL_V2;
        log.info("nft046TransferV2--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft046TransferV2 error", e);
        }catch (Exception e) {
            log.error("nft046TransferV2 error",e);
        }
        log.info("nft046TransferV2--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft046TransferResp resp = zxlnftBiz.buildNftRespObj(response,Nft046TransferResp.class);

        log.info("nft046TransferV2--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft047SelfTransferResp nft047SelfTransfer(Nft047SelfTransferReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_047_SELF_TRANSFER_URL;
        log.info("nft047SelfTransfer--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft047SelfTransfer error", e);
        }catch (Exception e) {
            log.error("nft047SelfTransfer error",e);
        }
        log.info("nft047SelfTransfer--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft047SelfTransferResp resp = zxlnftBiz.buildNftRespObj(response,Nft047SelfTransferResp.class);

        log.info("nft047SelfTransfer--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft048BatchTransferResp nft048BatchTransfer(Nft048BatchTransferReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_048_BATCH_TRANSFER_URL;
        log.info("nft048BatchTransfer--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft048BatchTransfer error", e);
        }catch (Exception e) {
            log.error("nft048BatchTransfer error",e);
        }
        log.info("nft048BatchTransfer--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft048BatchTransferResp resp = zxlnftBiz.buildNftRespObj(response,Nft048BatchTransferResp.class);

        log.info("nft048BatchTransfer--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft049TransferResultResp nft049TransferResult(Nft049TransferResultReq req) {
        zxlnftBiz.buildHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_049_TRANSFER_RESULT_URL;
        log.info("nft049TransferResult--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft049TransferResultReq.class,req);
        log.info("nft049TransferResult--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft049TransferResult error", e);
        }catch (Exception e) {
            log.error("nft049TransferResult error",e);
        }
        log.info("nft049TransferResult--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft049TransferResultResp resp = zxlnftBiz.buildNftRespObj(response,Nft049TransferResultResp.class);

        log.info("nft049TransferResult--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft050StatusUpdateResp nft050StatusUpdate(Nft050StatusUpdateReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_050_STATUS_UPDATE_URL;
        log.info("nft050StatusUpdate--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft050StatusUpdate error", e);
        }catch (Exception e) {
            log.error("nft050StatusUpdate error",e);
        }
        log.info("nft050StatusUpdate--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft050StatusUpdateResp resp = zxlnftBiz.buildNftRespObj(response,Nft050StatusUpdateResp.class);

        log.info("nft050StatusUpdate--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft051StatusUpdateResultResp nft051StatusUpdateResult(Nft051StatusUpdateResultReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_051_STATUS_UPDATE_RESULT_URL;
        log.info("nft051StatusUpdateResult--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft051StatusUpdateResultReq.class,req);
        log.info("nft051StatusUpdateResult--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft051StatusUpdateResult error", e);
        }catch (Exception e) {
            log.error("nft051StatusUpdateResult error",e);
        }
        log.info("nft051StatusUpdateResult--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft051StatusUpdateResultResp resp = zxlnftBiz.buildNftRespObj(response,Nft051StatusUpdateResultResp.class);

        log.info("nft051StatusUpdateResult--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft052PriceUpdateResp nft052PriceUpdate(Nft052PriceUpdateReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        //构造请求参数
        String reqJsonStr = BeanUtil.convertBeanToJsonString(req);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_052_PRICE_UPDATE_URL;
        log.info("nft052PriceUpdate--->>> request url : {}  body : {} ",requestUrl, reqJsonStr);

        String response = null;
        try {
            response = HttpUtil.postJson(requestUrl,reqJsonStr,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft052PriceUpdate error", e);
        }catch (Exception e) {
            log.error("nft052PriceUpdate error",e);
        }
        log.info("nft052PriceUpdate--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft052PriceUpdateResp resp = zxlnftBiz.buildNftRespObj(response,Nft052PriceUpdateResp.class);

        log.info("nft052PriceUpdate--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft053PriceUpdateResultResp nft053PriceUpdateResult(Nft053PriceUpdateResultReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_053_PRICE_UPDATE_RESULT_URL;
        log.info("nft053PriceUpdateResult--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft053PriceUpdateResultReq.class,req);
        log.info("nft053PriceUpdateResult--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft053PriceUpdateResult error", e);
        }catch (Exception e) {
            log.error("nft053PriceUpdateResult error",e);
        }
        log.info("nft053PriceUpdateResult--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft053PriceUpdateResultResp resp = zxlnftBiz.buildNftRespObj(response,Nft053PriceUpdateResultResp.class);

        log.info("nft053PriceUpdateResult--->>> return result : {} ",resp.toString());
        return resp;
    }

    @Override
    public Nft054QueryUserAddressBelongToUserResp nft054QueryUserAddressBelongToUser(Nft054QueryUserAddressBelongToUserReq req) {
        zxlnftBiz.buildPlatFormHeader(commonHeader);

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_054_PRICE_UPDATE_RESULT_URL;
        log.info("nft054QueryUserAddressBelongToUser--->>> request url : {}  body : {} ",requestUrl, req.toString());

        requestUrl = zxlnftBiz.buildGetRequestUrl(requestUrl,Nft054QueryUserAddressBelongToUserReq.class,req);
        log.info("nft054QueryUserAddressBelongToUser--->>> new request url : {} ",requestUrl);


        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.getByUri(requestUrl,commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft054QueryUserAddressBelongToUser error", e);
        }catch (Exception e) {
            log.error("nft054QueryUserAddressBelongToUser error",e);
        }
        log.info("nft054QueryUserAddressBelongToUser--->>> response : {} ",response);

        /**
         * 构造返回结果
         */
        Nft054QueryUserAddressBelongToUserResp resp = zxlnftBiz.buildNftRespObj(response,Nft054QueryUserAddressBelongToUserResp.class);

        log.info("nft054QueryUserAddressBelongToUser--->>> return result : {} ",resp.toString());
        return resp;
    }
}