package com.liquidnet.service.bank.currencycloud.dto;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiParam;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author LiChen
 * @date 2020/9/17 5:27 下午
 */
@Data
@ApiModel(description = "cc push notify conversion ")
public class BankCcPushNotifyConversion {
    @JsonProperty(value = "id")
    private String id;

    @JsonProperty(value = "account_id")
    private String accountId;

    @JsonProperty(value = "creator_contact_id")
    private String creatorContactId;

    @JsonProperty(value = "short_reference")
    private String shortReference;

    @JsonProperty(value = "created_at")
    private String createdAt;

    @JsonProperty(value = "settlement_date")
    private String settlementDate;

    @JsonProperty(value = "conversion_date")
    private String conversionDate;

    @JsonProperty(value = "status")
    private String status;

    @JsonProperty(value = "partner_status")
    private String partnerStatus;

    @JsonProperty(value = "currency_pair")
    private String currencyPair;

    @JsonProperty(value = "buy_currency")
    private String buyCurrency;

    @JsonProperty(value = "sell_currency")
    private String sellCurrency;

    @JsonProperty(value = "fixed_side")
    private String fixedSide;

    @JsonProperty(value = "partner_buy_amount")
    private String partnerBuyAmount;

    @JsonProperty(value = "partner_sell_amount")
    private String partnerSellAmount;

    @JsonProperty(value = "client_buy_amount")
    private String clientBuyAmount;

    @JsonProperty(value = "client_sell_amount")
    private String clientSellAmount;

    @JsonProperty(value = "mid_market_rate")
    private String midMarketRate;

    @JsonProperty(value = "core_rate")
    private String coreRate;

    @JsonProperty(value = "partner_rate")
    private String partnerRate;

    @JsonProperty(value = "client_rate")
    private String clientRate;

    @JsonProperty(value = "deposit_required")
    private Boolean depositRequired;

    @JsonProperty(value = "deposit_amount")
    private String depositAmount;

    @JsonProperty(value = "deposit_currency")
    private String depositCurrency;

    @JsonProperty(value = "deposit_status")
    private String depositStatus;

    @JsonProperty(value = "deposit_required_at")
    private String depositRequiredAt;

    @JsonProperty(value = "payment_ids")
    private List<String> paymentIds;

}
