package com.liquidnet.client.admin.web.controller.adam.user;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.page.PageDomain;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.core.page.TableSupport;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.dto.query.AdamUserQuery;
import com.liquidnet.service.adam.entity.AdamUser;
import com.liquidnet.service.feign.adam.admin.user.FeignAdminAdamUserInfoClient;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags = "Adam user")
@Controller
@RequestMapping("/adam/user")
public class AdamUserController extends BaseController {

    private String prefix = "adam/user";

    @Autowired
    private FeignAdminAdamUserInfoClient feignAdminAdamUserInfoClient;

    // @RequiresPermissions("system:user:view")
    @GetMapping()
    public String user()
    {
        return prefix + "/adamUser";
    }

    @ApiOperation(value = "获取用户分页列表")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo listUser(AdamUserQuery adamUserQuery)
    {
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        ResponseDto<Page<AdamUser>> pageResponseDto = feignAdminAdamUserInfoClient.listAdamUser(adamUserQuery,
                pageNum, pageSize);
        return buildAdamUserListTableDataInfo(pageResponseDto.getData());
    }

    private TableDataInfo buildAdamUserListTableDataInfo(Page<AdamUser> page) {
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(0);
        rspData.setRows(page.getRecords());
        rspData.setTotal(page.getTotal());
        return rspData;
    }
}
