package com.liquidnet.client.admin.web.service.adam.transaction.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.liquidnet.client.admin.common.utils.bean.BeanUtils;
import com.liquidnet.client.admin.web.service.adam.transaction.IAdamTransactionService;
import com.liquidnet.client.admin.web.vo.adam.transaction.AdamConversionRecordVo;
import com.liquidnet.client.admin.web.vo.adam.transaction.AdamPayoutDetailVo;
import com.liquidnet.client.admin.web.vo.adam.transaction.AdamPayoutRecordVo;
import com.liquidnet.client.admin.web.vo.adam.transaction.AdamRechargeRecordVo;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.dto.AdamTransactionDto;
import com.liquidnet.service.adam.dto.admin.transaction.AdamConversionRecordReq;
import com.liquidnet.service.adam.dto.admin.transaction.AdamPayoutDetailDto;
import com.liquidnet.service.adam.dto.admin.transaction.AdamPayoutRecordReq;
import com.liquidnet.service.adam.dto.admin.transaction.AdamRechargeRecordReq;
import com.liquidnet.service.adam.entity.AdamPayout;
import com.liquidnet.service.adam.entity.AdamPayoutBeneficiary;
import com.liquidnet.service.adam.entity.AdamPayoutPayer;
import com.liquidnet.service.feign.adam.admin.transaction.FeignTransactionQueryClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: TODO
 * @class: AdamTransactionServiceImpl
 * @Package com.liquidnet.client.admin.web.service.adam.transaction.impl
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/11/5 17:09
 */
@Service
public class AdamTransactionServiceImpl implements IAdamTransactionService{
    @Autowired
    private FeignTransactionQueryClient feignTransactionQueryClient;
    
    @Override
    public Page<AdamRechargeRecordVo> rechargeList(AdamRechargeRecordReq adamRechargeRecordReq, int pageNum, int pageSize) {
        ResponseDto<Page<AdamTransactionDto>> pageResponseDto = feignTransactionQueryClient.rechargeList(adamRechargeRecordReq,pageNum, pageSize);
        Page<AdamTransactionDto> dataPage = pageResponseDto.getData();
        List<AdamTransactionDto> records = dataPage.getRecords();
        List<AdamRechargeRecordVo> recordsDisplay = Lists.newArrayList();
        records.forEach(r -> {
            AdamRechargeRecordVo resp = new AdamRechargeRecordVo();
//            BeanUtils.copyProperties(r, resp);
            resp.setId(r.getId());
            resp.setTransactionId(r.getId());
            resp.setWalletNo(r.getFinWalletNo());
            resp.setCurrency(r.getCurrency());
            resp.setTransactionAmount(r.getFundAmount().toString());
            resp.setCreateDate(r.getCreateTime().format(DateTimeFormatter.ofPattern(DateUtil.DATE_FULL_STR)));
            if(r.getCompleteTime() != null){
                resp.setCompletedDate(r.getCompleteTime().format(DateTimeFormatter.ofPattern(DateUtil.DATE_FULL_STR)));
            }
            resp.setTransactionStatus(r.getStatus());
            resp.setReason("");
            resp.setReference("");
            resp.setErrorMessage("");
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss");
//            resp.setCreateDate(df.format(r.getCreateDate()));
//            resp.setCreateDate(r.getCreateDate());
//            if (Optional.ofNullable(r.getCompletedDate()).isPresent()) {
//                resp.setCompletedDate(df.format(LocalDateTime.ofInstant(
//                        Instant.ofEpochMilli(df.parse(r.getCompletedDate()).getLong()), ZoneId.systemDefault())));
//            }
            recordsDisplay.add(resp);
        });

        Page<AdamRechargeRecordVo> page = new Page<>();
        BeanUtils.copyProperties(dataPage, page);
        page.setRecords(recordsDisplay);
        return page;
    }

    @Override
    public Page<AdamPayoutRecordVo> payoutList(AdamPayoutRecordReq adamPayoutRecordReq, int pageNum, int pageSize) {
        ResponseDto<Page<AdamTransactionDto>> pageResponseDto = feignTransactionQueryClient.payoutList(adamPayoutRecordReq,pageNum, pageSize);
        Page<AdamTransactionDto> dataPage = pageResponseDto.getData();
        List<AdamTransactionDto> records = dataPage.getRecords();
        List<AdamPayoutRecordVo> recordsDisplay = Lists.newArrayList();
        records.forEach(r -> {
            AdamPayoutRecordVo resp = new AdamPayoutRecordVo();
//            BeanUtils.copyProperties(r, resp);
            resp.setId(r.getId());
            resp.setTransactionId(r.getId());
            resp.setOrderId(r.getNumber());
            resp.setWalletNo(r.getFinWalletNo());
            resp.setCurrency(r.getCurrency());
            resp.setTransactionAmount(r.getFundAmount().toString());
            resp.setTransactionDate(r.getCreateTime().format(DateTimeFormatter.ofPattern(DateUtil.DATE_FULL_STR)));
            if(r.getCompleteTime() != null){
                resp.setExecutionDate(r.getCompleteTime().format(DateTimeFormatter.ofPattern(DateUtil.DATE_FULL_STR)));
            }
            resp.setTransactionStatus(r.getStatus());
            resp.setPayoutWithFx("");
            resp.setFxContractNo("");
            resp.setFxQuote("");
            resp.setPaymentPurpose("");
            resp.setPaymentReference("");
            resp.setErrorMessage("");
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss");
//            resp.setCreateDate(df.format(r.getCreateDate()));
//            resp.setCreateDate(r.getCreateDate());
//            if (Optional.ofNullable(r.getCompletedDate()).isPresent()) {
//                resp.setCompletedDate(df.format(LocalDateTime.ofInstant(
//                        Instant.ofEpochMilli(df.parse(r.getCompletedDate()).getLong()), ZoneId.systemDefault())));
//            }
            recordsDisplay.add(resp);
        });

        Page<AdamPayoutRecordVo> page = new Page<>();
        BeanUtils.copyProperties(dataPage, page);
        page.setRecords(recordsDisplay);
        return page;
    }

    @Override
    public Page<AdamConversionRecordVo> conversionList(AdamConversionRecordReq adamConversionRecordReq, int pageNum, int pageSize) {
        ResponseDto<Page<AdamTransactionDto>> pageResponseDto = feignTransactionQueryClient.conversionList(adamConversionRecordReq,pageNum, pageSize);
        Page<AdamTransactionDto> dataPage = pageResponseDto.getData();
        List<AdamTransactionDto> records = dataPage.getRecords();
        List<AdamConversionRecordVo> recordsDisplay = Lists.newArrayList();
        records.forEach(r -> {
            AdamConversionRecordVo resp = new AdamConversionRecordVo();
//            BeanUtils.copyProperties(r, resp);
            resp.setId(r.getId());
            resp.setTransactionId(r.getId());
            resp.setFromWallet(r.getFinWalletNo());
            resp.setToWallet(r.getFinWalletNo());
            resp.setSoldCurrency(r.getCurrency());
            resp.setSoldAmount(r.getCurrency());
            resp.setBoughtCurrency(r.getFundAmount().toString());
            resp.setBoughtAmount(r.getFundAmount().toString());
            resp.setExchangeRate("");
            resp.setCreateDate(r.getCreateTime().format(DateTimeFormatter.ofPattern(DateUtil.DATE_FULL_STR)));
            if(r.getCompleteTime() != null){
                resp.setCompletedDate(r.getCompleteTime().format(DateTimeFormatter.ofPattern(DateUtil.DATE_FULL_STR)));
            }
            if(r.getCompleteTime() != null){
                resp.setConversionDate(r.getCompleteTime().format(DateTimeFormatter.ofPattern(DateUtil.DATE_FULL_STR)));
            }
            if(r.getCompleteTime() != null){
                resp.setSettlementDate(r.getCompleteTime().format(DateTimeFormatter.ofPattern(DateUtil.DATE_FULL_STR)));
            }
            resp.setTransactionStatus(r.getStatus());
            resp.setErrorMessage("");
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss");
//            resp.setCreateDate(df.format(r.getCreateDate()));
//            resp.setCreateDate(r.getCreateDate());
//            if (Optional.ofNullable(r.getCompletedDate()).isPresent()) {
//                resp.setCompletedDate(df.format(LocalDateTime.ofInstant(
//                        Instant.ofEpochMilli(df.parse(r.getCompletedDate()).getLong()), ZoneId.systemDefault())));
//            }
            recordsDisplay.add(resp);
        });

        Page<AdamConversionRecordVo> page = new Page<>();
        BeanUtils.copyProperties(dataPage, page);
        page.setRecords(recordsDisplay);
        return page;
    }

    @Override
    public AdamPayoutDetailVo getPayoutDetailByOrderId(String orderId) {
        AdamPayoutDetailVo vo = new AdamPayoutDetailVo();
        ResponseDto<AdamPayoutDetailDto> responseDto = feignTransactionQueryClient.getPayoutDetailByOrderId(orderId);
        if(!responseDto.isSuccess()){
            return null;
        }
        AdamPayout adamPayout = responseDto.getData().getAdamPayout();
        vo.setAccountNo(adamPayout.getFinWalletNo());
        vo.setSourceCurrency(adamPayout.getCurrency());
        vo.setAmount(adamPayout.getAmount().toString());
        if (adamPayout.getExecutionDate() != null) {
            vo.setExecutionDate(adamPayout.getExecutionDate().format(DateTimeFormatter.ofPattern(DateUtil.DATE_SMALL_STR)));
        }
        vo.setPayoutWithFx(adamPayout.getFxWith());
        vo.setFxContractNo(adamPayout.getFxContractNo());
        vo.setFxQuote(adamPayout.getFxQuote());
        vo.setPaymentPurpose(adamPayout.getReason());
        vo.setPaymentReference(adamPayout.getReference());

        AdamPayoutPayer adamPayoutPayer = responseDto.getData().getAdamPayoutPayer();
        vo.setSenderName(adamPayoutPayer.getFullName());
        vo.setSenderIdNumber(adamPayoutPayer.getIdNumber());
        vo.setSenderAddress(adamPayoutPayer.getAddress());
        vo.setSenderCity(adamPayoutPayer.getCity());
        vo.setSenderCountry(adamPayoutPayer.getCountry());

        AdamPayoutBeneficiary adamPayoutBeneficiary = responseDto.getData().getAdamPayoutBeneficiary();
        vo.setBeneficiaryName(adamPayoutBeneficiary.getFullName());
        vo.setBeneficiaryCountry(adamPayoutBeneficiary.getCountry());
        vo.setBeneficiaryAddress(adamPayoutBeneficiary.getAddress());
        vo.setBeneficiaryCity(adamPayoutBeneficiary.getCity());
        vo.setBeneficiaryPostCode(adamPayoutBeneficiary.getPostCode());
        vo.setBeneficiaryStateOrProvince(adamPayoutBeneficiary.getProvince());
        vo.setBeneficiaryBankCountry(adamPayoutBeneficiary.getBankCountry());
        vo.setBeneficiaryCurrency(adamPayoutBeneficiary.getCurrency());
        vo.setBeneficiaryAccountNo(adamPayoutBeneficiary.getBankAccountNo());
        vo.setPaymentMethod(adamPayoutBeneficiary.getPaymentMethod());
        vo.setBeneficiaryBankCode("");
        vo.setBeneficiaryBankName("");
        return vo;
    }

}
