package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 验票用户表
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinCheckUser implements Serializable ,Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * check_user_id
     */
    private String checkUserId;

    /**
     * 姓名
     */
    private String name;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 密码
     */
    private String pwd;

    /**
     * 状态0可用 1不可
     */
    private Integer status;

    /**
     * merchantId 第三方id
     */
    private String merchantId;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;

    private static final KylinCheckUser obj = new KylinCheckUser();
    public static KylinCheckUser getNew() {
        try {
            return (KylinCheckUser) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinCheckUser();
        }
    }
}
