package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.galaxy.dto.TradeInfoDto;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyQueryUserTradeOutListRespDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/8 16:27
 */
@ApiModel(value = "GalaxyQueryUserTradeOutListRespDto", description = "用户所有出NFT信息查询")
@Data
public class GalaxyQueryUserTradeOutListRespDto implements Serializable,Cloneable {
    /**
     * 交易信息总数
     */
    private Long total;
    /**
     * 交易信息列表
     */
    private List<TradeInfoDto> tradeList;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyQueryUserTradeOutListRespDto obj = new GalaxyQueryUserTradeOutListRespDto();

    public static GalaxyQueryUserTradeOutListRespDto getNew() {
        try {
            return (GalaxyQueryUserTradeOutListRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyQueryUserTradeOutListRespDto();
        }
    }
}