package com.liquidnet.client.admin.zhengzai.kylin.dto;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.service.kylin.dao.OrderExportDao;
import lombok.Data;

import java.io.Serializable;

@Data
public class OrderDetailedByShowIdExportVo implements Serializable, Cloneable {
    @Excel(name = "订单号", cellType = Excel.ColumnType.STRING)
    private String orderCode;
    @Excel(name = "商户订单号", cellType = Excel.ColumnType.STRING)
    private String payCode;
    @Excel(name = "微信/支付宝订单号", cellType = Excel.ColumnType.STRING)
    private String paymentId;
    @Excel(name = "购买名称", cellType = Excel.ColumnType.STRING)
    private String performanceTitle;
    @Excel(name = "支付平台", cellType = Excel.ColumnType.STRING)
    private String paymentType;
    @Excel(name = "数量", cellType = Excel.ColumnType.STRING)
    private String number;
    @Excel(name = "单价", cellType = Excel.ColumnType.STRING)
    private String price;
    @Excel(name = "支付金额", cellType = Excel.ColumnType.STRING)
    private String priceActual;
    @Excel(name = "快递费", cellType = Excel.ColumnType.STRING)
    private String priceExpress;
    @Excel(name = "退票数量", cellType = Excel.ColumnType.STRING)
    private String refundNumber;
    @Excel(name = "演出类型", cellType = Excel.ColumnType.STRING)
    private String type;
    @Excel(name = "票种名称", cellType = Excel.ColumnType.STRING)
    private String title1;
    @Excel(name = "场次", cellType = Excel.ColumnType.STRING)
    private String title2;
    @Excel(name = "退款时间", cellType = Excel.ColumnType.STRING)
    private String updateAt;
    @Excel(name = "退款原因", cellType = Excel.ColumnType.STRING)
    private String reject;
    @Excel(name = "退款金额", cellType = Excel.ColumnType.STRING)
    private String priceRefund;
    @Excel(name = "支付时间", cellType = Excel.ColumnType.STRING)
    private String timePay;

    private static final OrderDetailedByShowIdExportVo obj = new OrderDetailedByShowIdExportVo();

    public static OrderDetailedByShowIdExportVo getNew() {
        try {
            return (OrderDetailedByShowIdExportVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new OrderDetailedByShowIdExportVo();
    }

    public OrderDetailedByShowIdExportVo copyOrderExportVo(OrderExportDao source) {
        this.setPerformanceTitle(source.getPerformanceTitle());
        this.setOrderCode(source.getOrderCode());
        this.setPayCode(source.getPayCode());
        this.setPaymentId(source.getPaymentId());
        this.setPaymentType(source.getPaymentType());
        this.setType(source.getType());
        this.setTitle1(source.getTitle1());
        this.setTitle2(source.getTitle2());
        this.setPrice(source.getPrice());
        this.setPriceExpress(source.getPriceExpress());
        this.setNumber(source.getNumber());
        this.setRefundNumber(source.getRefundNumber());
        this.setPriceActual(source.getPriceActual());
        this.setPriceRefund(source.getPriceRefund());
        this.setUpdateAt(source.getRefundAt());
        this.setReject(source.getReject());
        this.setTimePay(source.getTimePay());
        return this;
    }



}
