package com.liquidnet.common.third.zxlnft.dto;

import com.liquidnet.commons.lang.util.JsonUtils;

import java.io.Serializable;

/**
 * REDIRECT(-1),
 * SUCCESS(0),
 * FAIL(1),
 * UNAUTH(2),
 */
public class ZxlnftResponseDto<T> implements Serializable, Cloneable {
    private static final long serialVersionUID = 8377276776600901982L;
    private String code;
    private String message;
    private T data;

    public boolean isSuccess() {
        return this.code.equals("0");
    }


    private ZxlnftResponseDto() {
    }

    private ZxlnftResponseDto(String code) {
        this.code = code;
    }

    private ZxlnftResponseDto(String code, T data) {
        this.code = code;
        this.data = data;
    }

    private ZxlnftResponseDto(String code, String message) {
        this.code = code;
        this.message = message;
    }

    private ZxlnftResponseDto(String code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }
    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    /**
     * <p>Getter for the field <code>data</code>.</p>
     *
     * @return a T object.
     */
    public T getData() {
        return data;
    }

    public static <Object> ZxlnftResponseDto<Object> success() {
        return new ZxlnftResponseDto<>("0");
    }

    public static <Object> ZxlnftResponseDto<Object> success(Object data) {
        return new ZxlnftResponseDto<>("0", data);
    }

    public static <Object> ZxlnftResponseDto<Object> failure() {
        return new ZxlnftResponseDto<>("1", "系统繁忙，请稍后再试");
    }

    public static <Object> ZxlnftResponseDto<Object> failure(String message) {
        return new ZxlnftResponseDto<>("1", message);
    }

    public static <Object> ZxlnftResponseDto<Object> failure(String code, String message) {
        return new ZxlnftResponseDto<>(code, message);
    }

    public static <Object> ZxlnftResponseDto<Object> failure(String code, String message, Object data) {
        return new ZxlnftResponseDto<>(code, message, data);
    }

    public <T> T getParseData(Class<T> clazz) {
        try {
            if (getData() != null) {
                return JsonUtils.fromJson(JsonUtils.toJson(getData()), clazz);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String toJson() {
        return JsonUtils.toJson(this);
    }
}
