package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 电子宣传手册富文本表
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetRichtext implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * order_refund_id
     */
    private String richtextId;

    /**
     * manual_id
     */
    private String manualId;

    /**
     * 富文本详情
     */
    private String details;

    /**
     * 经纬度 5需要
     */
    private String local;

    /**
     * 地图图片地址 2需要
     */
    private String picUrl;

    /**
     * 类型 1签售时间 2现场地图 3官方大巴 4公共交通 5自驾导航坐标 6官方支持 7观众须知 8防疫指南 9观演攻略
     */
    private Integer type;

    /**
     * 0关闭 1开启
     */
    private Integer status;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SweetRichtext obj = new SweetRichtext();
    public static SweetRichtext getNew() {
        try {
            return (SweetRichtext) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetRichtext();
        }
    }
}
