package com.liquidnet.service.consumer.kylin.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.kylin.receiver.ConsumerGoblinOrderCloseRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

@Configuration
public class ConsumerGoblinOrderCRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerGoblinOrderCloseRdsReceiver consumerGoblinOrderCloseRdsReceiver;

    /**
     * 缺票登记
     *
     * @param listenerContainer
     * @param t
     * @return
     */
    private Subscription receiveGoblinOrderCOrder(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(Consumer.from(MQConst.GoblinQueue.GOBLIN_ORDER_CLOSE.getGroup(), getConsumerName(MQConst.GoblinQueue.GOBLIN_ORDER_CLOSE.name() + t)),
                StreamOffset.create(MQConst.GoblinQueue.GOBLIN_ORDER_CLOSE.getKey(), ReadOffset.lastConsumed()), consumerGoblinOrderCloseRdsReceiver);
    }

    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */

    /* -------------------------------------------------------- ｜ 缺票登记 */

    @Bean
    public Subscription subscriptionGoblinOrderC0(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveGoblinOrderCOrder(listenerContainer, 0);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionGoblinOrderC1(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveGoblinOrderCOrder(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionGoblinOrderC2(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveGoblinOrderCOrder(listenerContainer, 2);
        listenerContainer.start();
        return subscription;
    }



    /* -------------------------------------------------------- ｜  */
}
