package com.liquidnet.client.admin.web.controller.zhengzai.kylin;


import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.utils.poi.ExcelUtil;
import com.liquidnet.client.admin.zhengzai.kylin.dto.ActiveTicketExportVo;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinAcitveServiceImpl;
import com.liquidnet.client.admin.zhengzai.kylin.service.impl.KylinTicketActiveServiceImpl;
import com.liquidnet.service.kylin.dao.KylinAcitve;
import com.liquidnet.service.kylin.dto.param.KylinAcitveParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 *  前端控制器 活动有关的
 * </p>
 * @author zhangfuxin
 * @since 2022-07-12
 */
@Api(tags = "活动和券的接口")
@RestController
@RequestMapping("/kylin-acitve")
public class KylinAcitveController extends BaseController {
    @Autowired
    private KylinAcitveServiceImpl kylinAcitveService;
    @Autowired
    private KylinTicketActiveServiceImpl kylinTicketActiveService;

    @PostMapping("add")
    @ApiOperation(value = "增加活动")
    @ResponseBody
    public AjaxResult add(@RequestBody KylinAcitveParam kylinAcitveParam) {
        KylinAcitve kylinAcitve=new KylinAcitve();
        BeanUtils.copyProperties(kylinAcitveParam,kylinAcitve);
        kylinAcitveService.addKylinAcitve(kylinAcitve);
        return AjaxResult.success("操作成功", "");
    }
    @PostMapping("pageActive")
    @ApiOperation(value = "分页活动")
    @ResponseBody
    public TableDataInfo pageActive( @RequestParam(name = "pageSize", required = true) int pageSize,@RequestParam(name = "pageNum", required = true)int pageNum) {
        //return AjaxResult.success(kylinAcitveService.pageKylinAcitve(pageSize,pageNum));
        return getDataTable( kylinAcitveService.pageKylinAcitve(pageSize,pageNum));
    }
    @PostMapping("pageActiveTicket")
    @ApiOperation(value = "分页券")
    @ResponseBody
    public TableDataInfo pageActiveTicket(@RequestParam(name = "pageSize", required = true) int pageSize, @RequestParam(name = "pageNum", required = true)int pageNum, @RequestParam(name = "activeId", required = true)String activeId) {
        //return AjaxResult.success(kylinTicketActiveService.pageKylinAcitve(pageSize,pageNum,activeId));
        return getDataTable( kylinTicketActiveService.pageKylinAcitve(pageSize,pageNum,activeId));
    }
    @PostMapping("exportTicket")
    @ApiOperation(value = "导出券")
    @ResponseBody
    public AjaxResult exportTicket( @RequestParam(name = "activeId", required = true)String activeId,@RequestParam(name = "activeName", required = true)String activeName) {
        List<ActiveTicketExportVo> list= kylinTicketActiveService.exportTicket(activeId);
        if(list.size()>0){
            ExcelUtil<ActiveTicketExportVo> util = new ExcelUtil(ActiveTicketExportVo.class);
            return util.exportExcel(list, activeName + "");
        }
        return error("查无信息！");
    }




}
