package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 
 * </p>
 *
 * @author jobob
 * @since 2022-03-11
 */
@ApiModel(value = "SellDataOneVO", description = "销量数据")
@Data
public class SellDataOneVO implements Serializable {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "票名")
    private String ticketName;
    @ApiModelProperty(value = "数量")
    private int ticketNumber;
    @ApiModelProperty(value = "总金额")
    private BigDecimal sellPrice;
    @ApiModelProperty(value = "票提")
    private BigDecimal piaoTi;
    @ApiModelProperty(value = "佣金")
    private BigDecimal commission;
    @ApiModelProperty(value = "票id")
    private String ticketId;
    @ApiModelProperty(value = "抽成总佣金")
    private BigDecimal chouChengCommission;


    private static final SellDataOneVO obj = new SellDataOneVO();

    public static SellDataOneVO getNew() {
        try {
            return (SellDataOneVO) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SellDataOneVO();
        }
    }




}
