package com.liquidnet.service.goblin.service.impl.inner;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.service.GoblinCouponService;
import com.liquidnet.service.goblin.service.manage.IGoblinGoodsAnticipateMgService;
import com.liquidnet.service.goblin.util.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static com.liquidnet.commons.lang.util.DateUtil.DTF_YMD_HMS;

@Service
@Slf4j
public class GoblinJobServiceImpl {

    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    GoblinMongoUtils mongoUtils;

    /**
     * 在售的 已开售时间倒序
     * 预约的 正序
     * 售罄的 正序
     *
     * @return
     */
    public ResponseDto<Boolean> mixList() {
        List<String> ntfList = goblinRedisUtils.getGoblinMixNftList();
        List<String> skuList = goblinRedisUtils.getGoblinMixSkuList();
        List<GoblinMixDetailsVo> nftDetailsList = ObjectUtil.goblinMixDetailsVo();
        List<GoblinMixDetailsVo> skuDetailsList = ObjectUtil.goblinMixDetailsVo();

        List<String> mixNftStockList = CollectionUtil.linkedListString();
        List<String> mixNftStartList = CollectionUtil.linkedListString();
        List<String> mixSkuStockList = CollectionUtil.linkedListString();
        List<String> mixSkuStartList = CollectionUtil.linkedListString();


        for (String mixId : ntfList) {
            GoblinMixDetailsVo vo = goblinRedisUtils.getMixDetails(mixId);
            nftDetailsList.add(vo);
        }

        for (String mixId : skuList) {
            GoblinMixDetailsVo vo = goblinRedisUtils.getMixDetails(mixId);
            skuDetailsList.add(vo);
        }

        //排序
        nftDetailsList = nftDetailsList.stream().filter(vo -> {
            String ts = vo.getTimeStart();
            return ts != null && !ts.trim().isEmpty();
        }).sorted(Comparator.comparing(GoblinMixDetailsVo::getTimeStart)).collect(Collectors.toList());

        skuDetailsList = skuDetailsList.stream().filter(vo -> {
            String ts = vo.getTimeStart();
            return ts != null && !ts.trim().isEmpty();
        }).sorted(Comparator.comparing(GoblinMixDetailsVo::getTimeStart)).collect(Collectors.toList());

        LocalDateTime nt = LocalDateTime.now();
        //筛选 活动中 和 活动中且售罄的
        for (GoblinMixDetailsVo item : nftDetailsList) {
            LocalDateTime st = LocalDateTime.parse(item.getTimeStartOrShelvesTime(item), DTF_YMD_HMS);
            LocalDateTime et = LocalDateTime.parse(item.getTimeEnd(), DTF_YMD_HMS);
            if (nt.isAfter(st) && nt.isBefore(et)) {//活动中
                int stock = 0;
                for (GoblinMixDetailsItemVo itemVo : item.getItem()) {
                    GoblinGoodsSkuInfoVo skuInfoVo = goblinRedisUtils.getGoodsSkuInfoVo(itemVo.getSkuId());
                    if (skuInfoVo.getUnbox().equals("1")) {
                        List<String> relationIds = goblinRedisUtils.getGoblinMixRelationBox(itemVo.getSkuId(), item.getMixId());
                        for (String skuId : relationIds) {
                            stock += goblinRedisUtils.getSkuStock(item.getMixId(), skuId);
                        }
                    } else {
                        stock += goblinRedisUtils.getSkuStock(item.getMixId(), itemVo.getSkuId());
                    }
                }
                if (stock == 0) {//活动中 且 售罄
                    mixNftStockList.add(item.getMixId());
//                    goblinRedisUtils.addGoblinMixNftStockList(item.getMixId());
                } else {//活动中 未售罄
                    mixNftStartList.add(item.getMixId());
//                    goblinRedisUtils.addGoblinMixNftStartList(item.getMixId());
                }
            }
        }

        for (GoblinMixDetailsVo item : skuDetailsList) {
            //修改开始时间获取  开始时间/上架时间
            LocalDateTime st = LocalDateTime.parse(item.getTimeStartOrShelvesTime(item), DTF_YMD_HMS);
            LocalDateTime et = LocalDateTime.parse(item.getTimeEnd(), DTF_YMD_HMS);
            if (nt.isAfter(st) && nt.isBefore(et)) {//活动中
                int stock = 0;
                for (GoblinMixDetailsItemVo itemVo : item.getItem()) {
                    GoblinGoodsSkuInfoVo skuInfoVo = goblinRedisUtils.getGoodsSkuInfoVo(itemVo.getSkuId());
                    if (skuInfoVo.getUnbox().equals("1")) {
                        List<String> relationIds = goblinRedisUtils.getGoblinMixRelationBox(itemVo.getSkuId(), item.getMixId());
                        for (String skuId : relationIds) {
                            stock += goblinRedisUtils.getSkuStock(item.getMixId(), skuId);
                        }
                    } else {
                        stock += goblinRedisUtils.getSkuStock(item.getMixId(), itemVo.getSkuId());
                    }
                }
                if (stock == 0) {//活动中 且 售罄
                    mixSkuStockList.add(item.getMixId());
//                    goblinRedisUtils.addGoblinMixSkuStockList(item.getMixId());
                } else {//活动中 未售罄
                    mixSkuStartList.add(item.getMixId());
//                    goblinRedisUtils.addGoblinMixSkuStartList(item.getMixId());
                }
            }
        }


        goblinRedisUtils.setGoblinMixNftStartList(mixNftStartList);
        goblinRedisUtils.setGoblinMixNftStockList(mixNftStockList);
        goblinRedisUtils.setGoblinMixSkuStartList(mixSkuStartList);
        goblinRedisUtils.setGoblinMixSkuStockList(mixSkuStockList);

        return ResponseDto.success();
    }
}
