package com.liquidnet.service.account.funding.service.impl;

import com.liquidnet.service.account.funding.entity.FinAccount;
import com.liquidnet.service.account.funding.mapper.FinAccountMapper;
import com.liquidnet.service.account.funding.service.FinAccountService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FinAccountServiceImpl implements FinAccountService {
    private static final Logger log = LoggerFactory.getLogger(FinAccountServiceImpl.class);
    @Autowired
    private FinAccountMapper accountMapper;

    @Override
    public Long generateSeqForFundingAccNo(String currencyCode) {
        return accountMapper.generateSeqNo("SEQ_AC_N01_".concat(currencyCode));
    }

    @Override
    public int addAccount(FinAccount account) {
        return accountMapper.insertSelective(account);
    }

    @Override
    public int updateAccount(FinAccount account) {
        return accountMapper.updateByPrimaryKeySelective(account);
    }

    @Override
    public FinAccount queryByAccNo(String accNo) {
        return accountMapper.selectByPrimaryKey(accNo);
    }
}
