package com.liquidnet.service.stone.vo;

import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.stone.entity.StoneScoreItems;
import com.liquidnet.service.stone.entity.StoneScoreLogs;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel
public class StoneLogsListVo implements Serializable, Cloneable {
    /**
     * id
     */
    @ApiModelProperty(value = "id", example = "1")
    private String logsId;

    /**
     * 积分物品封面图
     */
    @ApiModelProperty(value = "积分", example = "10")
    private Integer score;

    /**
     * 积分物品名称
     */
    @ApiModelProperty(value = "内容", example = "购买商品")
    private String content;

    /**
     * 目标类型[1-券|1x-商品维度|2x-演出维度]
     */
    @ApiModelProperty(value = "创建时间", example = "2021-12-12 12:00:01")
    private String createdAt;

    private static final StoneLogsListVo obj = new StoneLogsListVo();

    public static StoneLogsListVo getNew() {
        try {
            return (StoneLogsListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new StoneLogsListVo();
        }
    }

    public StoneLogsListVo copy(StoneScoreLogs source) {
        if (null == source) return this;
        this.setLogsId(source.getLogsId());
        this.setScore(source.getScore().intValue());
        this.setContent(source.getContent());
        this.setCreatedAt(DateUtil.Formatter.yyyyMMddHHmmss.format(source.getCreatedAt()));
        return this;
    }
}
