package com.liquidnet.service.sweet.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetArtists;
import com.liquidnet.service.sweet.entity.SweetArtistsList;
import com.liquidnet.service.sweet.entity.SweetArtistsUrl;
import com.liquidnet.service.sweet.param.SweetArtistsListParam;
import com.liquidnet.service.sweet.vo.SweetArtistsVo;

import java.util.List;

/**
 * <p>
 * 艺人表 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-23
 */
public interface ISweetArtistsService extends IService<SweetArtists> {

    ResponseDto<PageInfo<SweetArtists>> getList(int page, int size, String name);

    ResponseDto<Boolean> add(SweetArtistsListParam sweetArtistsList);

    ResponseDto<SweetArtistsVo> detail(String artistsId);

    ResponseDto<Boolean> change(String artistsId, SweetArtistsListParam sweetArtistsList);

    ResponseDto<SweetArtists> del(String artistsId);

}
