package com.liquidnet.service.galaxy.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.aop.annotation.ControllerLog;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishRespDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishResultQueryReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyNftPublishResultQueryRespDto;
import com.liquidnet.service.galaxy.service.IGalaxyPublishService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyPublishController
 * @Package com.liquidnet.service.galaxy.controller
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/15 12:11
 */
@Api(tags = "NFT发行相关")
@RestController
@RequestMapping("nftPublish")
@Validated
@Slf4j
public class GalaxyPublishController {
    @Resource(name = "galaxyPublishServiceImpl")
    private IGalaxyPublishService galaxyPublishService;

    @ControllerLog(description = "NFT发行")
    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "NFT发行")
    @PostMapping(value = {"nftPublish"})
    public ResponseDto<GalaxyNftPublishRespDto> nftPublish(@Valid @RequestBody GalaxyNftPublishReqDto reqDto){
        return galaxyPublishService.nftPublish(reqDto);
    }

    @ControllerLog(description = "NFT发行结果查询")
    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "NFT发行结果查询")
    @PostMapping(value = {"nftPublishResultQuery"})
    public ResponseDto<GalaxyNftPublishResultQueryRespDto> nftPublishResultQuery(@Valid @RequestBody GalaxyNftPublishResultQueryReqDto reqDto) {
        return galaxyPublishService.nftPublishResultQuery(reqDto);
    }
}
