package com.liquidnet.service.goblin.service.impl;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.service.IGoblinNftOrderAppService;
import com.liquidnet.service.goblin.util.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@Slf4j
public class GoblinNftOrderAppServiceImpl implements IGoblinNftOrderAppService {

    @Autowired
    GoblinRedisUtils redisUtils;
    @Autowired
    GoblinMongoUtils mongoUtils;
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    GoblinOrderUtils orderUtils;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;

    @Override
    public ResponseDto<PagedResult<GoblinNftOrderDetailsVo>> orderList(int page) {
        String uid = CurrentUtil.getCurrentUid();
        List<GoblinNftOrderDetailsVo> orderVoList = ObjectUtil.goblinNftOrderDetailsVoArrayList();
        List<String> orderIds;
        orderIds = redisUtils.getNftOrderList(uid);

        int size = 10;
        int finalCount = orderIds.size() - page * size;
        int initCount = orderIds.size() - (page - 1) * size - 1;
        if (finalCount <= 0) {
            finalCount = 0;
        }
        for (int i = initCount; i >= finalCount; i--) {
            String orderId = orderIds.get(i);
            // 订单信息
            GoblinNftOrderVo orderVo = redisUtils.getGoblinNftOrder(orderId);
            GoblinNftOrderDetailsVo orderDetails = GoblinNftOrderDetailsVo.getNew().copy(orderVo);
            // 商品信息
            GoblinGoodsSkuInfoVo goodsSkuInfoVo = goblinRedisUtils.getGoodsSkuInfoVo(orderVo.getSkuId());
            GoblinNftOrderGoodsSkuInfoVo nftGoodsSkuInfoVo = GoblinNftOrderGoodsSkuInfoVo.getNew().copy(goodsSkuInfoVo);
            orderDetails.setGoodsSkuInfoVo(nftGoodsSkuInfoVo);
            // 加入列表
            orderVoList.add(orderDetails);
        }

        PagedResult<GoblinNftOrderDetailsVo> listVoPagedResult = ObjectUtil.getGoblinNftOrderDetailsVoPagedResult();
        listVoPagedResult.setList(orderVoList).setTotal(orderIds.size(), size).setPageSize(size).setCurrentPage(page);
        return ResponseDto.success(listVoPagedResult);
    }

    @Override
    public ResponseDto<GoblinNftOrderDetailsVo> orderDetails(String orderId) {
        GoblinNftOrderVo orderVo = redisUtils.getGoblinNftOrder(orderId);
        if (null == orderVo) {
            return ResponseDto.failure("订单不存在");
        }

        String uid = CurrentUtil.getCurrentUid();
        if (!orderVo.getUserId().equals(uid)) {
            return ResponseDto.failure(ErrorMapping.get("20003"));
        }
        // 订单信息
        GoblinNftOrderDetailsVo orderDetails = GoblinNftOrderDetailsVo.getNew().copy(orderVo);
        orderDetails.setOrderCode(orderDetails.getOrderCode().substring(orderDetails.getOrderCode().length() - 10));
        // 商品信息
        GoblinGoodsSkuInfoVo goodsSkuInfoVo = goblinRedisUtils.getGoodsSkuInfoVo(orderVo.getSkuId());
        GoblinNftOrderGoodsSkuInfoVo nftGoodsSkuInfoVo = GoblinNftOrderGoodsSkuInfoVo.getNew().copy(goodsSkuInfoVo);
        orderDetails.setGoodsSkuInfoVo(nftGoodsSkuInfoVo);

        return ResponseDto.success(orderDetails);
    }

    @Override
    public GoblinPayOrderDetailsVo payOrderDetails(String skuId) {
        GoblinGoodsSkuInfoVo goodsSkuInfoVo = goblinRedisUtils.getGoodsSkuInfoVo(skuId);
        if (goblinRedisUtils.getSkuAllStatusShow(goodsSkuInfoVo)) {
            GoblinPayOrderDetailsVo payOrderDetailsVo = GoblinPayOrderDetailsVo.getNew().copy(goodsSkuInfoVo);
            payOrderDetailsVo.setNum(1);

            GoblinStoreInfoVo storeInfoVo = goblinRedisUtils.getStoreInfoVo(goodsSkuInfoVo.getStoreId());
            payOrderDetailsVo.setStoreName(storeInfoVo.getStoreName());
            return payOrderDetailsVo;
        } else {
            return null;
        }
    }

}
