package com.liquidnet.service.candy.dto;

import com.liquidnet.service.candy.entity.CandyCoupon;
import com.liquidnet.service.candy.entity.CandyUserCoupon;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class CandyUserCouponBasicDto implements Serializable, Cloneable {
    private static final long serialVersionUID = 4073256621782131605L;

    /* com.liquidnet.service.candy.entity.CandyCoupon */
    private String couponId;
    //private Integer state;
    private String title;
    private String label;
    private String notice;
    //private Integer exclusive;
    private Integer busiType;
    private Integer couType;
    private Integer bindType;
    private BigDecimal discount;
    private BigDecimal valFace;
    private BigDecimal valOver;
    private BigDecimal valMinus;
    private Integer overlay;
    private Integer overlayLevel;
    private Integer validity;
    private Integer isTrueName;
    private Integer redeemValidity;
    private LocalDateTime redeemStart;
    private LocalDateTime redeemStop;
    //private LocalDateTime effectAt;
    //private LocalDateTime expireAt;
    //private String operator;
    //private Date createdAt;
    //private Date updatedAt;
    //private String comment;

    /* com.liquidnet.service.candy.entity.CandyUserCoupon */
    private String ucouponId;
    private String mcouponId;
    private String uid;
    //private String couponId;
    private Integer exclusive;
    private Integer state;
    private String ccode;
    private LocalDateTime bindAt;
    private LocalDateTime duedAt;
    private LocalDateTime usedAt;
    private String usedFor;
    //private String comment;

    /* com.liquidnet.service.candy.entity.CandyCouponRule */
    private List<CandyCouponRuleDto> useRules;

    /* com.liquidnet.service.candy.entity.CandyCommonCoupon */
    private String ccouponId;

    private Integer idType;
    private String idName;
    private String idNo;

    private static final CandyUserCouponBasicDto obj = new CandyUserCouponBasicDto();

    public static CandyUserCouponBasicDto getNew() {
        try {
            return (CandyUserCouponBasicDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new CandyUserCouponBasicDto();
        }
    }

    // 柄神的代码。有点逼数别乱动
    public CandyUserCouponBasicDto copy(CandyUserCoupon userCoupon, CandyCoupon coupon, List<CandyCouponRuleDto> couponRuleDtoList) {
        if (null == userCoupon) return this;
        this.setCouponId(coupon.getCouponId());
        this.setTitle(coupon.getTitle());
        this.setLabel(coupon.getLabel());
        this.setNotice(coupon.getNotice());
        //this.setExclusive(coupon.getExclusive());
        this.setBusiType(coupon.getBusiType());
        this.setCouType(coupon.getCouType());
        this.setBindType(coupon.getBindType());
        this.setDiscount(coupon.getDiscount());
        this.setValFace(coupon.getValFace());
        this.setValOver(coupon.getValOver());
        this.setValMinus(coupon.getValMinus());
        this.setOverlay(coupon.getOverlay());
        this.setOverlayLevel(coupon.getOverlayLevel());
        this.setValidity(coupon.getValidity());
        this.setIsTrueName(coupon.getIsTrueName());
        this.setRedeemValidity(coupon.getRedeemValidity());
        this.setRedeemStart(coupon.getRedeemStart());
        this.setRedeemStop(coupon.getRedeemStop());

        this.setUcouponId(userCoupon.getUcouponId());
        this.setMcouponId(userCoupon.getMcouponId());
        this.setUid(userCoupon.getUid());
        this.setExclusive(userCoupon.getExclusive());
        this.setState(userCoupon.getState());
        this.setCcode(userCoupon.getCcode());
        this.setBindAt(userCoupon.getBindAt());
        this.setDuedAt(userCoupon.getDuedAt());
        this.setUsedAt(userCoupon.getUsedAt());
        this.setUsedFor(userCoupon.getUsedFor());

        this.setUseRules(couponRuleDtoList);
        return this;
    }

    public CandyUserCouponBasicDto copyToRedisBaseCoupon(String uCouponId, String uid, String cCode, CandyCouponInfoDto couponInfoDto, LocalDateTime duedAt) {
        this.setCouponId(couponInfoDto.getCouponId());
        this.setTitle(couponInfoDto.getTitle());
        this.setLabel(couponInfoDto.getLabel());
        this.setNotice(couponInfoDto.getNotice());
        this.setExclusive(couponInfoDto.getExclusive());
        this.setBusiType(couponInfoDto.getBusiType());
        this.setCouType(couponInfoDto.getCouType());
        this.setBindType(couponInfoDto.getBindType());
        this.setDiscount(couponInfoDto.getDiscount());
        this.setValFace(couponInfoDto.getValFace());
        this.setValOver(couponInfoDto.getValOver());
        this.setValMinus(couponInfoDto.getValMinus());
        this.setOverlay(couponInfoDto.getOverlay());
        this.setOverlayLevel(couponInfoDto.getOverlayLevel());
        this.setValidity(couponInfoDto.getValidity());
        this.setRedeemValidity(couponInfoDto.getRedeemValidity());
        this.setRedeemStart(couponInfoDto.getRedeemStart());
        this.setRedeemStop(couponInfoDto.getRedeemStop());

        this.setUcouponId(uCouponId);
        this.setUid(uid);
        this.setCcode(cCode);

        this.setState(1);
        this.setBindAt(couponInfoDto.getEffectAt());
        this.setDuedAt(duedAt);

        this.setUseRules(couponInfoDto.getUseRules());
        return this;
    }

    public CandyUserCouponBasicDto copyToRedisCommonBaseCoupon(String uCouponId, String uid, CandyCommonCouponBasicDto commonCouponBasicDto) {
        this.setCouponId(commonCouponBasicDto.getCouponId());
        this.setTitle(commonCouponBasicDto.getTitle());
        this.setCcouponId(commonCouponBasicDto.getCcouponId());
        this.setLabel(commonCouponBasicDto.getLabel());
        this.setNotice(commonCouponBasicDto.getNotice());
        this.setExclusive(commonCouponBasicDto.getExclusive());
        this.setBusiType(commonCouponBasicDto.getBusiType());
        this.setCouType(commonCouponBasicDto.getCouType());
        this.setBindType(commonCouponBasicDto.getBindType());
        this.setDiscount(commonCouponBasicDto.getDiscount());
        this.setValFace(commonCouponBasicDto.getValFace());
        this.setValOver(commonCouponBasicDto.getValOver());
        this.setValMinus(commonCouponBasicDto.getValMinus());
        this.setOverlay(commonCouponBasicDto.getOverlay());
        this.setOverlayLevel(commonCouponBasicDto.getOverlayLevel());
        this.setValidity(commonCouponBasicDto.getValidity());
        this.setRedeemValidity(commonCouponBasicDto.getRedeemValidity());
        this.setRedeemStart(commonCouponBasicDto.getRedeemStart());
        this.setRedeemStop(commonCouponBasicDto.getRedeemStop());

        this.setUcouponId(uCouponId);
        this.setUid(uid);

        this.setState(1);
        this.setBindAt(commonCouponBasicDto.getEffectAt());
        this.setDuedAt(commonCouponBasicDto.getExpireAt());

        this.setUseRules(commonCouponBasicDto.getUseRules());
        return this;
    }
}
