package com.liquidnet.service.kylin.dto;


import java.io.Serializable;
import java.time.LocalDateTime;

import lombok.Data;

@Data
public class PerformancePartnerDto implements Serializable {

    /**
     * performances_id
     */
    private String performancesId;

    /**
     * 演出名称
     */
    private String title;

    /**
     * 1音乐节 2演唱会 3小型演出 4展览 6舞台剧
     */
    private Integer type;

    /**
     * 演出海报
     */
    private String imgPoster;

    /**
     * 省id
     */
    private String provinceId;

    /**
     * 省名称
     */
    private String provinceName;

    /**
     * 城市id
     */
    private Integer cityId;

    /**
     * 城市名称
     */
    private String cityName;

    /**
     * 县id
     */
    private Integer districtId;

    /**
     * 县名称
     */
    private String districtName;

    /**
     * 批文地址
     */
    private String approvalUrl;

    /**
     * 演出公告
     */
    private String notice;

    /**
     * 主办方id
     */
    private String sponsorId;

    /**
     * 主办方类型
     */
    private String sponsorType;

    /**
     * 主办方
     */
    private String sponsor;

    /**
     * 联系人
     */
    private String contacts;

    /**
     * 联系电话
     */
    private String mobile;

    /**
     * 演出简介
     */
    private String describes;

    /**
     * 演出详情
     */
    private String details;

    /**
     * 购票须知
     */
    private String noticeImage;

    /**
     * 演出开始时间
     */
    private LocalDateTime timeStart;

    /**
     * 演出结束时间
     */
    private LocalDateTime timeEnd;

    /**
     * 拒绝理由
     */
    private String rejectTxt;

    /**
     * 权重 高则在上
     */
    private Integer sort;

    /**
     * comment
     */
    private String comment;


    /**
     * 复制来源演出id
     */
    private String copyId;

    /**
     * 商户id
     */
    private String merchantId;

    /**
     * 场地id
     */
    private String fieldId;

    /**
     * 巡演id
     */
    private String roadShowId;

    /**
     * 专题id
     */
    private String projectId;

    /**
     * 视频id
     */
    private String videoId;

    /**
     * 是否显示 0全部用户可见 1白名单可见 2任何不显示
     */
    private Integer isShow;

    /**
     * 状态:-1删除;0未提交;1审核中;2审核中（自动上线）;3审核通过;4审核未通过;6上线;7下架;8活动结束;9活动取消退款中;10活动取消退
     */
    private String status;

    /**
     * 是否售卖 0停止 1正常
     */
    private Integer statusSell;

    /**
     * 是否开启分销 0关闭 1开启
     */
    private Integer isDistribution;

    /**
     * 是否关联小程序 0不关联 1关联
     */
    private Integer syncAgent;

    /**
     * -1未提交审核，0提交审核，1审核通过，2审核拒绝
     */
    private Integer auditStatus;

    /**
     * 创建时间
     */
    private String createdAt;

    /**
     * 修改时间
     */
    private String updatedAt;


}
