drop schema if exists mdsky_admin;
create database mdsky_admin character set utf8mb4 collate utf8mb4_unicode_ci;
-- ------------------------------------------------------
use `mdsky_admin`;
-- MySQL dump 10.13  Distrib 5.7.32, for Linux (x86_64)
--
-- Host: localhost    Database: mdsky_admin
-- ------------------------------------------------------
-- Server version	5.7.32

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `gen_table`
--

DROP TABLE IF EXISTS `gen_table`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gen_table` (
  `table_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '表名称',
  `table_comment` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '表描述',
  `sub_table_name` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '关联子表的表名',
  `sub_table_fk_name` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '子表关联的外键名',
  `class_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '实体类名称',
  `tpl_category` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT 'crud' COMMENT '使用的模板（crud单表操作 tree树表操作 sub主子表操作）',
  `package_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '生成包路径',
  `module_name` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '生成模块名',
  `business_name` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '生成业务名',
  `function_name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '生成功能名',
  `function_author` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '生成功能作者',
  `gen_type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '0' COMMENT '生成代码方式（0zip压缩包 1自定义路径）',
  `gen_path` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '/' COMMENT '生成路径（不填默认项目路径）',
  `options` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '其它生成选项',
  `create_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`table_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='代码生成业务表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gen_table`
--

LOCK TABLES `gen_table` WRITE;
/*!40000 ALTER TABLE `gen_table` DISABLE KEYS */;
/*!40000 ALTER TABLE `gen_table` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gen_table_column`
--

DROP TABLE IF EXISTS `gen_table_column`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gen_table_column` (
  `column_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '归属表编号',
  `column_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '列名称',
  `column_comment` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '列描述',
  `column_type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '列类型',
  `java_type` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JAVA类型',
  `java_field` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JAVA字段名',
  `is_pk` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '是否主键（1是）',
  `is_increment` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '是否自增（1是）',
  `is_required` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '是否必填（1是）',
  `is_insert` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '是否为插入字段（1是）',
  `is_edit` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '是否编辑字段（1是）',
  `is_list` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '是否列表字段（1是）',
  `is_query` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '是否查询字段（1是）',
  `query_type` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT 'EQ' COMMENT '查询方式（等于、不等于、大于、小于、范围）',
  `html_type` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '显示类型（文本框、文本域、下拉框、复选框、单选框、日期控件）',
  `dict_type` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '字典类型',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `create_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`column_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='代码生成业务表字段';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gen_table_column`
--

LOCK TABLES `gen_table_column` WRITE;
/*!40000 ALTER TABLE `gen_table_column` DISABLE KEYS */;
/*!40000 ALTER TABLE `gen_table_column` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_blob_triggers`
--

DROP TABLE IF EXISTS `qrtz_blob_triggers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `qrtz_blob_triggers` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `blob_data` blob,
  PRIMARY KEY (`sched_name`,`trigger_name`,`trigger_group`),
  CONSTRAINT `qrtz_blob_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_blob_triggers`
--

LOCK TABLES `qrtz_blob_triggers` WRITE;
/*!40000 ALTER TABLE `qrtz_blob_triggers` DISABLE KEYS */;
/*!40000 ALTER TABLE `qrtz_blob_triggers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_calendars`
--

DROP TABLE IF EXISTS `qrtz_calendars`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `qrtz_calendars` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `calendar_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `calendar` blob NOT NULL,
  PRIMARY KEY (`sched_name`,`calendar_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_calendars`
--

LOCK TABLES `qrtz_calendars` WRITE;
/*!40000 ALTER TABLE `qrtz_calendars` DISABLE KEYS */;
/*!40000 ALTER TABLE `qrtz_calendars` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_cron_triggers`
--

DROP TABLE IF EXISTS `qrtz_cron_triggers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `qrtz_cron_triggers` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cron_expression` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time_zone_id` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`sched_name`,`trigger_name`,`trigger_group`),
  CONSTRAINT `qrtz_cron_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_cron_triggers`
--

LOCK TABLES `qrtz_cron_triggers` WRITE;
/*!40000 ALTER TABLE `qrtz_cron_triggers` DISABLE KEYS */;
INSERT INTO `qrtz_cron_triggers` VALUES ('LiquidNetScheduler','TASK_CLASS_NAME1','DEFAULT','0/10 * * * * ?','UTC'),('LiquidNetScheduler','TASK_CLASS_NAME2','DEFAULT','0/15 * * * * ?','UTC'),('LiquidNetScheduler','TASK_CLASS_NAME3','DEFAULT','0/20 * * * * ?','UTC'),('RuoyiScheduler','TASK_CLASS_NAME1','DEFAULT','0/10 * * * * ?','Asia/Shanghai'),('RuoyiScheduler','TASK_CLASS_NAME2','DEFAULT','0/15 * * * * ?','Asia/Shanghai'),('RuoyiScheduler','TASK_CLASS_NAME3','DEFAULT','0/20 * * * * ?','Asia/Shanghai');
/*!40000 ALTER TABLE `qrtz_cron_triggers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_fired_triggers`
--

DROP TABLE IF EXISTS `qrtz_fired_triggers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `qrtz_fired_triggers` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `entry_id` varchar(95) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `instance_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fired_time` bigint(13) NOT NULL,
  `sched_time` bigint(13) NOT NULL,
  `priority` int(11) NOT NULL,
  `state` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `job_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `job_group` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_nonconcurrent` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `requests_recovery` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`sched_name`,`entry_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_fired_triggers`
--

LOCK TABLES `qrtz_fired_triggers` WRITE;
/*!40000 ALTER TABLE `qrtz_fired_triggers` DISABLE KEYS */;
/*!40000 ALTER TABLE `qrtz_fired_triggers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_job_details`
--

DROP TABLE IF EXISTS `qrtz_job_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `qrtz_job_details` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `job_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `job_group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `job_class_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_durable` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_nonconcurrent` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_update_data` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `requests_recovery` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `job_data` blob,
  PRIMARY KEY (`sched_name`,`job_name`,`job_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_job_details`
--

LOCK TABLES `qrtz_job_details` WRITE;
/*!40000 ALTER TABLE `qrtz_job_details` DISABLE KEYS */;
INSERT INTO `qrtz_job_details` VALUES ('LiquidNetScheduler','TASK_CLASS_NAME1','DEFAULT',NULL,'QuartzDisallowConcurrentExecution','0','1','0','0',_binary '�\�\0sr\0org.quartz.JobDataMap���迩�\�\0\0xr\0&org.quartz.utils.StringKeyDirtyFlagMap�\�\��\�](\0Z\0allowsTransientDataxr\0org.quartz.utils.DirtyFlagMap\�.�(v\n\�\0Z\0dirtyL\0mapt\0Ljava/util/Map;xpsr\0java.util.HashMap\��\�`\�\0F\0\nloadFactorI\0	thresholdxp?@\0\0\0\0\0w\0\0\0\0\0\0t\0TASK_PROPERTIESsr\0/SysJob\0\0\0\0\0\0\0\0L\0\nconcurrentt\0Ljava/lang/String;L\0cronExpressionq\0~\0	L\0invokeTargetq\0~\0	L\0jobGroupq\0~\0	L\0jobIdt\0Ljava/lang/Long;L\0jobNameq\0~\0	L\0\rmisfirePolicyq\0~\0	L\0statusq\0~\0	xr\08com.liquidnet.client.admin.common.core.domain.BaseEntity\0\0\0\0\0\0\0\0L\0createByq\0~\0	L\0\ncreateTimet\0Ljava/util/Date;L\0paramsq\0~\0L\0remarkq\0~\0	L\0searchValueq\0~\0	L\0updateByq\0~\0	L\0\nupdateTimeq\0~\0xpt\0adminsr\0java.util.Datehj�KYt\0\0xpw\0\0b,\�)\�xpt\0\0pppt\01t\00/10 * * * * ?t\0ryTask.ryNoParamst\0DEFAULTsr\0java.lang.Long;�\�̏#\�\0J\0valuexr\0java.lang.Number����\��\0\0xp\0\0\0\0\0\0\0t\0系统默认（无参）t\03t\01x\0'),('LiquidNetScheduler','TASK_CLASS_NAME2','DEFAULT',NULL,'QuartzDisallowConcurrentExecution','0','1','0','0',_binary '�\�\0sr\0org.quartz.JobDataMap���迩�\�\0\0xr\0&org.quartz.utils.StringKeyDirtyFlagMap�\�\��\�](\0Z\0allowsTransientDataxr\0org.quartz.utils.DirtyFlagMap\�.�(v\n\�\0Z\0dirtyL\0mapt\0Ljava/util/Map;xpsr\0java.util.HashMap\��\�`\�\0F\0\nloadFactorI\0	thresholdxp?@\0\0\0\0\0w\0\0\0\0\0\0t\0TASK_PROPERTIESsr\0/SysJob\0\0\0\0\0\0\0\0L\0\nconcurrentt\0Ljava/lang/String;L\0cronExpressionq\0~\0	L\0invokeTargetq\0~\0	L\0jobGroupq\0~\0	L\0jobIdt\0Ljava/lang/Long;L\0jobNameq\0~\0	L\0\rmisfirePolicyq\0~\0	L\0statusq\0~\0	xr\08com.liquidnet.client.admin.common.core.domain.BaseEntity\0\0\0\0\0\0\0\0L\0createByq\0~\0	L\0\ncreateTimet\0Ljava/util/Date;L\0paramsq\0~\0L\0remarkq\0~\0	L\0searchValueq\0~\0	L\0updateByq\0~\0	L\0\nupdateTimeq\0~\0xpt\0adminsr\0java.util.Datehj�KYt\0\0xpw\0\0b,\�)\�xpt\0\0pppt\01t\00/15 * * * * ?t\0ryTask.ryParams(\'ry\')t\0DEFAULTsr\0java.lang.Long;�\�̏#\�\0J\0valuexr\0java.lang.Number����\��\0\0xp\0\0\0\0\0\0\0t\0系统默认（有参）t\03t\01x\0'),('LiquidNetScheduler','TASK_CLASS_NAME3','DEFAULT',NULL,'QuartzDisallowConcurrentExecution','0','1','0','0',_binary '�\�\0sr\0org.quartz.JobDataMap���迩�\�\0\0xr\0&org.quartz.utils.StringKeyDirtyFlagMap�\�\��\�](\0Z\0allowsTransientDataxr\0org.quartz.utils.DirtyFlagMap\�.�(v\n\�\0Z\0dirtyL\0mapt\0Ljava/util/Map;xpsr\0java.util.HashMap\��\�`\�\0F\0\nloadFactorI\0	thresholdxp?@\0\0\0\0\0w\0\0\0\0\0\0t\0TASK_PROPERTIESsr\0/SysJob\0\0\0\0\0\0\0\0L\0\nconcurrentt\0Ljava/lang/String;L\0cronExpressionq\0~\0	L\0invokeTargetq\0~\0	L\0jobGroupq\0~\0	L\0jobIdt\0Ljava/lang/Long;L\0jobNameq\0~\0	L\0\rmisfirePolicyq\0~\0	L\0statusq\0~\0	xr\08com.liquidnet.client.admin.common.core.domain.BaseEntity\0\0\0\0\0\0\0\0L\0createByq\0~\0	L\0\ncreateTimet\0Ljava/util/Date;L\0paramsq\0~\0L\0remarkq\0~\0	L\0searchValueq\0~\0	L\0updateByq\0~\0	L\0\nupdateTimeq\0~\0xpt\0adminsr\0java.util.Datehj�KYt\0\0xpw\0\0b,\�)\�xpt\0\0pppt\01t\00/20 * * * * ?t\08ryTask.ryMultipleParams(\'ry\', true, 2000L, 316.50D, 100)t\0DEFAULTsr\0java.lang.Long;�\�̏#\�\0J\0valuexr\0java.lang.Number����\��\0\0xp\0\0\0\0\0\0\0t\0系统默认（多参）t\03t\01x\0'),('RuoyiScheduler','TASK_CLASS_NAME1','DEFAULT',NULL,'QuartzDisallowConcurrentExecution','0','1','0','0',_binary '�\�\0sr\0org.quartz.JobDataMap���迩�\�\0\0xr\0&org.quartz.utils.StringKeyDirtyFlagMap�\�\��\�](\0Z\0allowsTransientDataxr\0org.quartz.utils.DirtyFlagMap\�.�(v\n\�\0Z\0dirtyL\0mapt\0Ljava/util/Map;xpsr\0java.util.HashMap\��\�`\�\0F\0\nloadFactorI\0	thresholdxp?@\0\0\0\0\0w\0\0\0\0\0\0t\0TASK_PROPERTIESsr\0/SysJob\0\0\0\0\0\0\0\0L\0\nconcurrentt\0Ljava/lang/String;L\0cronExpressionq\0~\0	L\0invokeTargetq\0~\0	L\0jobGroupq\0~\0	L\0jobIdt\0Ljava/lang/Long;L\0jobNameq\0~\0	L\0\rmisfirePolicyq\0~\0	L\0statusq\0~\0	xr\08com.liquidnet.client.admin.common.core.domain.BaseEntity\0\0\0\0\0\0\0\0L\0createByq\0~\0	L\0\ncreateTimet\0Ljava/util/Date;L\0paramsq\0~\0L\0remarkq\0~\0	L\0searchValueq\0~\0	L\0updateByq\0~\0	L\0\nupdateTimeq\0~\0xpt\0adminsr\0java.util.Datehj�KYt\0\0xpw\0\0b,\�)\�xpt\0\0pppt\01t\00/10 * * * * ?t\0ryTask.ryNoParamst\0DEFAULTsr\0java.lang.Long;�\�̏#\�\0J\0valuexr\0java.lang.Number����\��\0\0xp\0\0\0\0\0\0\0t\0系统默认（无参）t\03t\01x\0'),('RuoyiScheduler','TASK_CLASS_NAME2','DEFAULT',NULL,'QuartzDisallowConcurrentExecution','0','1','0','0',_binary '�\�\0sr\0org.quartz.JobDataMap���迩�\�\0\0xr\0&org.quartz.utils.StringKeyDirtyFlagMap�\�\��\�](\0Z\0allowsTransientDataxr\0org.quartz.utils.DirtyFlagMap\�.�(v\n\�\0Z\0dirtyL\0mapt\0Ljava/util/Map;xpsr\0java.util.HashMap\��\�`\�\0F\0\nloadFactorI\0	thresholdxp?@\0\0\0\0\0w\0\0\0\0\0\0t\0TASK_PROPERTIESsr\0/SysJob\0\0\0\0\0\0\0\0L\0\nconcurrentt\0Ljava/lang/String;L\0cronExpressionq\0~\0	L\0invokeTargetq\0~\0	L\0jobGroupq\0~\0	L\0jobIdt\0Ljava/lang/Long;L\0jobNameq\0~\0	L\0\rmisfirePolicyq\0~\0	L\0statusq\0~\0	xr\08com.liquidnet.client.admin.common.core.domain.BaseEntity\0\0\0\0\0\0\0\0L\0createByq\0~\0	L\0\ncreateTimet\0Ljava/util/Date;L\0paramsq\0~\0L\0remarkq\0~\0	L\0searchValueq\0~\0	L\0updateByq\0~\0	L\0\nupdateTimeq\0~\0xpt\0adminsr\0java.util.Datehj�KYt\0\0xpw\0\0b,\�)\�xpt\0\0pppt\01t\00/15 * * * * ?t\0ryTask.ryParams(\'ry\')t\0DEFAULTsr\0java.lang.Long;�\�̏#\�\0J\0valuexr\0java.lang.Number����\��\0\0xp\0\0\0\0\0\0\0t\0系统默认（有参）t\03t\01x\0'),('RuoyiScheduler','TASK_CLASS_NAME3','DEFAULT',NULL,'QuartzDisallowConcurrentExecution','0','1','0','0',_binary '�\�\0sr\0org.quartz.JobDataMap���迩�\�\0\0xr\0&org.quartz.utils.StringKeyDirtyFlagMap�\�\��\�](\0Z\0allowsTransientDataxr\0org.quartz.utils.DirtyFlagMap\�.�(v\n\�\0Z\0dirtyL\0mapt\0Ljava/util/Map;xpsr\0java.util.HashMap\��\�`\�\0F\0\nloadFactorI\0	thresholdxp?@\0\0\0\0\0w\0\0\0\0\0\0t\0TASK_PROPERTIESsr\0/SysJob\0\0\0\0\0\0\0\0L\0\nconcurrentt\0Ljava/lang/String;L\0cronExpressionq\0~\0	L\0invokeTargetq\0~\0	L\0jobGroupq\0~\0	L\0jobIdt\0Ljava/lang/Long;L\0jobNameq\0~\0	L\0\rmisfirePolicyq\0~\0	L\0statusq\0~\0	xr\08com.liquidnet.client.admin.common.core.domain.BaseEntity\0\0\0\0\0\0\0\0L\0createByq\0~\0	L\0\ncreateTimet\0Ljava/util/Date;L\0paramsq\0~\0L\0remarkq\0~\0	L\0searchValueq\0~\0	L\0updateByq\0~\0	L\0\nupdateTimeq\0~\0xpt\0adminsr\0java.util.Datehj�KYt\0\0xpw\0\0b,\�)\�xpt\0\0pppt\01t\00/20 * * * * ?t\08ryTask.ryMultipleParams(\'ry\', true, 2000L, 316.50D, 100)t\0DEFAULTsr\0java.lang.Long;�\�̏#\�\0J\0valuexr\0java.lang.Number����\��\0\0xp\0\0\0\0\0\0\0t\0系统默认（多参）t\03t\01x\0');
/*!40000 ALTER TABLE `qrtz_job_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_locks`
--

DROP TABLE IF EXISTS `qrtz_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `qrtz_locks` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lock_name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`sched_name`,`lock_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_locks`
--

LOCK TABLES `qrtz_locks` WRITE;
/*!40000 ALTER TABLE `qrtz_locks` DISABLE KEYS */;
INSERT INTO `qrtz_locks` VALUES ('LiquidNetScheduler','STATE_ACCESS'),('LiquidNetScheduler','TRIGGER_ACCESS'),('RuoyiScheduler','STATE_ACCESS'),('RuoyiScheduler','TRIGGER_ACCESS');
/*!40000 ALTER TABLE `qrtz_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_paused_trigger_grps`
--

DROP TABLE IF EXISTS `qrtz_paused_trigger_grps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `qrtz_paused_trigger_grps` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`sched_name`,`trigger_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_paused_trigger_grps`
--

LOCK TABLES `qrtz_paused_trigger_grps` WRITE;
/*!40000 ALTER TABLE `qrtz_paused_trigger_grps` DISABLE KEYS */;
/*!40000 ALTER TABLE `qrtz_paused_trigger_grps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_scheduler_state`
--

DROP TABLE IF EXISTS `qrtz_scheduler_state`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `qrtz_scheduler_state` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `instance_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_checkin_time` bigint(13) NOT NULL,
  `checkin_interval` bigint(13) NOT NULL,
  PRIMARY KEY (`sched_name`,`instance_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_scheduler_state`
--

LOCK TABLES `qrtz_scheduler_state` WRITE;
/*!40000 ALTER TABLE `qrtz_scheduler_state` DISABLE KEYS */;
INSERT INTO `qrtz_scheduler_state` VALUES ('LiquidNetScheduler','dev1608176299787',1608194292056,15000),('RuoyiScheduler','kowlone1601007847848',1601012037180,15000);
/*!40000 ALTER TABLE `qrtz_scheduler_state` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_simple_triggers`
--

DROP TABLE IF EXISTS `qrtz_simple_triggers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `qrtz_simple_triggers` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `repeat_count` bigint(7) NOT NULL,
  `repeat_interval` bigint(12) NOT NULL,
  `times_triggered` bigint(10) NOT NULL,
  PRIMARY KEY (`sched_name`,`trigger_name`,`trigger_group`),
  CONSTRAINT `qrtz_simple_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_simple_triggers`
--

LOCK TABLES `qrtz_simple_triggers` WRITE;
/*!40000 ALTER TABLE `qrtz_simple_triggers` DISABLE KEYS */;
/*!40000 ALTER TABLE `qrtz_simple_triggers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_simprop_triggers`
--

DROP TABLE IF EXISTS `qrtz_simprop_triggers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `qrtz_simprop_triggers` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `str_prop_1` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `str_prop_2` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `str_prop_3` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `int_prop_1` int(11) DEFAULT NULL,
  `int_prop_2` int(11) DEFAULT NULL,
  `long_prop_1` bigint(20) DEFAULT NULL,
  `long_prop_2` bigint(20) DEFAULT NULL,
  `dec_prop_1` decimal(13,4) DEFAULT NULL,
  `dec_prop_2` decimal(13,4) DEFAULT NULL,
  `bool_prop_1` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bool_prop_2` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`sched_name`,`trigger_name`,`trigger_group`),
  CONSTRAINT `qrtz_simprop_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_simprop_triggers`
--

LOCK TABLES `qrtz_simprop_triggers` WRITE;
/*!40000 ALTER TABLE `qrtz_simprop_triggers` DISABLE KEYS */;
/*!40000 ALTER TABLE `qrtz_simprop_triggers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_triggers`
--

DROP TABLE IF EXISTS `qrtz_triggers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `qrtz_triggers` (
  `sched_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `job_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `job_group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `next_fire_time` bigint(13) DEFAULT NULL,
  `prev_fire_time` bigint(13) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `trigger_state` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trigger_type` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_time` bigint(13) NOT NULL,
  `end_time` bigint(13) DEFAULT NULL,
  `calendar_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misfire_instr` smallint(2) DEFAULT NULL,
  `job_data` blob,
  PRIMARY KEY (`sched_name`,`trigger_name`,`trigger_group`),
  KEY `sched_name` (`sched_name`,`job_name`,`job_group`),
  CONSTRAINT `qrtz_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `job_name`, `job_group`) REFERENCES `qrtz_job_details` (`sched_name`, `job_name`, `job_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_triggers`
--

LOCK TABLES `qrtz_triggers` WRITE;
/*!40000 ALTER TABLE `qrtz_triggers` DISABLE KEYS */;
INSERT INTO `qrtz_triggers` VALUES ('LiquidNetScheduler','TASK_CLASS_NAME1','DEFAULT','TASK_CLASS_NAME1','DEFAULT',NULL,1608176300000,-1,5,'PAUSED','CRON',1608176299000,0,NULL,2,''),('LiquidNetScheduler','TASK_CLASS_NAME2','DEFAULT','TASK_CLASS_NAME2','DEFAULT',NULL,1608176310000,-1,5,'PAUSED','CRON',1608176299000,0,NULL,2,''),('LiquidNetScheduler','TASK_CLASS_NAME3','DEFAULT','TASK_CLASS_NAME3','DEFAULT',NULL,1608176300000,-1,5,'PAUSED','CRON',1608176299000,0,NULL,2,''),('RuoyiScheduler','TASK_CLASS_NAME1','DEFAULT','TASK_CLASS_NAME1','DEFAULT',NULL,1601007850000,-1,5,'PAUSED','CRON',1601007847000,0,NULL,2,''),('RuoyiScheduler','TASK_CLASS_NAME2','DEFAULT','TASK_CLASS_NAME2','DEFAULT',NULL,1601007855000,-1,5,'PAUSED','CRON',1601007848000,0,NULL,2,''),('RuoyiScheduler','TASK_CLASS_NAME3','DEFAULT','TASK_CLASS_NAME3','DEFAULT',NULL,1601007860000,-1,5,'PAUSED','CRON',1601007848000,0,NULL,2,'');
/*!40000 ALTER TABLE `qrtz_triggers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_config`
--

DROP TABLE IF EXISTS `sys_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_config` (
  `config_id` int(5) NOT NULL AUTO_INCREMENT COMMENT '参数主键',
  `config_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '参数名称',
  `config_key` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '参数键名',
  `config_value` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '参数键值',
  `config_type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'N' COMMENT '系统内置（Y是 N否）',
  `create_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`config_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='参数配置表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_config`
--

LOCK TABLES `sys_config` WRITE;
/*!40000 ALTER TABLE `sys_config` DISABLE KEYS */;
INSERT INTO `sys_config` VALUES (1,'主框架页-默认皮肤样式名称','sys.index.skinName','skin-blue','Y','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','蓝色 skin-blue、绿色 skin-green、紫色 skin-purple、红色 skin-red、黄色 skin-yellow'),(2,'用户管理-账号初始密码','sys.user.initPassword','123456','Y','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','初始化密码 123456'),(3,'主框架页-侧边栏主题','sys.index.sideTheme','theme-dark','Y','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','深黑主题theme-dark，浅色主题theme-light，深蓝主题theme-blue'),(4,'账号自助-是否开启用户注册功能','sys.account.registerUser','false','Y','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','是否开启注册用户功能（true开启，false关闭）'),(5,'用户管理-密码字符范围','sys.account.chrtype','0','Y','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','默认任意字符范围，0任意（密码可以输入任意字符），1数字（密码只能为0-9数字），2英文字母（密码只能为a-z和A-Z字母），3字母和数字（密码必须包含字母，数字）,4字母数组和特殊字符（密码必须包含字母，数字，特殊字符-_）'),(6,'主框架页-菜单导航显示风格','sys.index.menuStyle','default','Y','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','菜单导航显示风格（default为左侧导航菜单，topnav为顶部导航菜单）'),(7,'主框架页-是否开启页脚','sys.index.ignoreFooter','true','Y','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','是否开启底部页脚显示（true显示，false隐藏）'),(8,'sss','sss','ssss','Y','admin','2020-11-09 08:32:28','',NULL,NULL);
/*!40000 ALTER TABLE `sys_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_dept`
--

DROP TABLE IF EXISTS `sys_dept`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_dept` (
  `dept_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '部门id',
  `parent_id` bigint(20) DEFAULT '0' COMMENT '父部门id',
  `ancestors` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '祖级列表',
  `dept_name` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '部门名称',
  `order_num` int(4) DEFAULT '0' COMMENT '显示顺序',
  `leader` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '负责人',
  `phone` varchar(11) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '联系电话',
  `email` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '邮箱',
  `status` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '0' COMMENT '部门状态（0正常 1停用）',
  `del_flag` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `create_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`dept_id`)
) ENGINE=InnoDB AUTO_INCREMENT=201 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='部门表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_dept`
--

LOCK TABLES `sys_dept` WRITE;
/*!40000 ALTER TABLE `sys_dept` DISABLE KEYS */;
INSERT INTO `sys_dept` VALUES (100,0,'0','LiquidNet科技',0,'正在映画','15888888888','ry@qq.com','0','0','admin','2018-03-16 11:33:00','admin','2020-09-25 18:45:56'),(101,100,'0,100','创新业务部',1,'董敬伟','15888888888','ry@qq.com','0','0','admin','2018-03-16 11:33:00','admin','2020-09-25 18:45:56'),(102,100,'0,100','长沙分公司',2,'正在映画','15888888888','ry@qq.com','0','2','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00'),(103,101,'0,100,101','研发组',1,'正在映画','15888888888','ry@qq.com','0','0','admin','2018-03-16 11:33:00','admin','2020-09-25 18:45:21'),(104,101,'0,100,101','市场组',2,'正在映画','15888888888','ry@qq.com','0','0','admin','2018-03-16 11:33:00','admin','2020-09-25 18:45:29'),(105,101,'0,100,101','测试组',3,'正在映画','15888888888','ry@qq.com','0','0','admin','2018-03-16 11:33:00','admin','2020-09-25 18:45:37'),(106,101,'0,100,101','产品组',4,'正在映画','15888888888','ry@qq.com','0','0','admin','2018-03-16 11:33:00','admin','2020-09-25 18:45:44'),(107,101,'0,100,101','运维组',5,'正在映画','15888888888','ry@qq.com','0','0','admin','2018-03-16 11:33:00','admin','2020-09-25 18:45:56'),(108,102,'0,100,102','市场部门',1,'正在映画','15888888888','ry@qq.com','0','2','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00'),(109,102,'0,100,102','财务部门',2,'正在映画','15888888888','ry@qq.com','0','2','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00');
/*!40000 ALTER TABLE `sys_dept` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_dict_data`
--

DROP TABLE IF EXISTS `sys_dict_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_dict_data` (
  `dict_code` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '字典编码',
  `dict_sort` int(4) DEFAULT '0' COMMENT '字典排序',
  `dict_label` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '字典标签',
  `dict_value` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '字典键值',
  `dict_type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '字典类型',
  `css_class` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '样式属性（其他样式扩展）',
  `list_class` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '表格回显样式',
  `is_default` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'N' COMMENT '是否默认（Y是 N否）',
  `status` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '0' COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`dict_code`)
) ENGINE=InnoDB AUTO_INCREMENT=1119 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='字典数据表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_dict_data`
--

LOCK TABLES `sys_dict_data` WRITE;
/*!40000 ALTER TABLE `sys_dict_data` DISABLE KEYS */;
INSERT INTO `sys_dict_data` VALUES (1,1,'男','0','sys_user_sex','','','Y','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','性别男'),(2,2,'女','1','sys_user_sex','','','N','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','性别女'),(3,3,'未知','2','sys_user_sex','','','N','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','性别未知'),(4,1,'显示','0','sys_show_hide','','primary','Y','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','显示菜单'),(5,2,'隐藏','1','sys_show_hide','','danger','N','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','隐藏菜单'),(6,1,'正常','0','sys_normal_disable','','primary','Y','0','admin','2018-03-16 11:33:00','admin','2020-12-11 18:49:18','正常状态'),(7,2,'停用','1','sys_normal_disable','','danger','N','0','admin','2018-03-16 11:33:00','admin','2020-12-11 18:49:10','停用状态'),(8,1,'正常','0','sys_job_status','','primary','Y','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','正常状态'),(9,2,'暂停','1','sys_job_status','','danger','N','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','停用状态'),(10,1,'默认','DEFAULT','sys_job_group','','','Y','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','默认分组'),(11,2,'系统','SYSTEM','sys_job_group','','','N','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','系统分组'),(12,1,'是','Y','sys_yes_no','','primary','Y','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','系统默认是'),(13,2,'否','N','sys_yes_no','','danger','N','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','系统默认否'),(14,1,'通知','1','sys_notice_type','','warning','Y','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','通知'),(15,2,'公告','2','sys_notice_type','','success','N','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','公告'),(16,1,'正常','0','sys_notice_status','','primary','Y','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','正常状态'),(17,2,'关闭','1','sys_notice_status','','danger','N','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','关闭状态'),(18,99,'其他','0','sys_oper_type','','info','N','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','其他操作'),(19,1,'新增','1','sys_oper_type','','info','N','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','新增操作'),(20,2,'修改','2','sys_oper_type','','info','N','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','修改操作'),(21,3,'删除','3','sys_oper_type','','danger','N','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','删除操作'),(22,4,'授权','4','sys_oper_type','','primary','N','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','授权操作'),(23,5,'导出','5','sys_oper_type','','warning','N','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','导出操作'),(24,6,'导入','6','sys_oper_type','','warning','N','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','导入操作'),(25,7,'强退','7','sys_oper_type','','danger','N','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','强退操作'),(26,8,'生成代码','8','sys_oper_type','','warning','N','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','生成操作'),(27,9,'清空数据','9','sys_oper_type','','danger','N','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','清空操作'),(28,1,'成功','0','sys_common_status','','primary','N','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','正常状态'),(29,2,'失败','1','sys_common_status','','danger','N','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','停用状态'),(30,1,'Completed','success','adam_recharge_status','','default','Y','0','admin','2020-11-02 08:58:15','admin','2020-11-09 08:41:57',''),(31,2,'Failed','fail','adam_recharge_status','','','Y','0','admin','2020-11-02 08:59:05','admin','2020-11-09 08:41:49',''),(32,3,'Processing','processing','adam_recharge_status','','default','Y','0','admin','2020-11-02 08:59:36','admin','2020-11-09 08:41:37',''),(33,1,'USD','USD','adam_trans_currency',' ',' ','Y','0','admin','2020-11-02 09:01:39','','2020-11-09 08:41:37','正常状态'),(34,2,'GBP','GBP','adam_trans_currency',' ','default','Y','0','admin','2020-11-02 09:01:52','','2020-11-09 08:41:37','正常状态'),(35,3,'EUR','EUR','adam_trans_currency',' ','default','Y','0','admin','2020-11-02 09:02:09','','2020-11-09 08:41:37','正常状态'),(36,3,'CNY','CNY','adam_trans_currency',' ','default','Y','0','admin','2020-11-02 09:02:28','','2020-11-09 08:41:37','正常状态'),(37,1,'Ready to Process','ready_to_process','adam_payout_status','','default','Y','0','admin','2020-11-09 07:51:11','admin','2020-11-09 07:57:07',''),(38,2,'Awaiting Funds','awaiting_funds','adam_payout_status','','default','Y','0','admin','2020-11-09 07:51:28','admin','2020-11-09 07:57:14',''),(39,3,'Failed','failed','adam_payout_status','','default','Y','0','admin','2020-11-09 07:53:32','admin','2020-11-09 07:57:37',''),(40,4,'Cancelled','cancelled','adam_payout_status','','default','Y','0','admin','2020-11-09 07:53:46','admin','2020-11-09 07:57:30',''),(41,5,'Processing','processing','adam_payout_status','','default','Y','0','admin','2020-11-09 07:53:59','admin','2020-11-09 07:57:22',''),(42,6,'Completed','completed','adam_payout_status','','default','Y','0','admin','2020-11-09 07:54:14','admin','2020-11-09 07:57:55',''),(43,1,'Ready to Settle','ready_to_settle','adam_conversion_status',' ','default','Y','0','admin','2020-11-09 08:01:42','','2020-11-09 08:41:37','正常状态'),(44,2,'Failed','failed','adam_conversion_status',' ','default','Y','0','admin','2020-11-09 08:02:02','','2020-11-09 08:41:37','正常状态'),(45,3,'Completed','completed','adam_conversion_status',' ','default','Y','0','admin','2020-11-09 08:02:21','','2020-11-09 08:41:37','正常状态'),(1113,2,'Normal','1','fin_wallet_status','','primary','Y','0','admin','2020-12-14 14:18:15','admin','2020-12-14 16:07:26',''),(1114,3,'Disable','2','fin_wallet_status','','danger','Y','0','admin','2020-12-14 14:19:36','admin','2020-12-14 16:07:38',''),(1115,1,'Normal','1','fin_wallet_pay_status','','primary','Y','0','admin','2020-12-14 14:35:04','admin','2020-12-14 16:08:25',''),(1116,2,'No_In','2','fin_wallet_pay_status','','primary','Y','0','admin','2020-12-14 14:35:23','admin','2020-12-14 16:08:39',''),(1117,3,'No_Out','3','fin_wallet_pay_status','','primary','Y','0','admin','2020-12-14 14:35:38','admin','2020-12-14 16:08:48',''),(1118,4,'Archive','4','fin_wallet_pay_status','','danger','Y','0','admin','2020-12-14 14:35:55','admin','2020-12-14 16:08:55','');
/*!40000 ALTER TABLE `sys_dict_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_dict_type`
--

DROP TABLE IF EXISTS `sys_dict_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_dict_type` (
  `dict_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '字典主键',
  `dict_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '字典名称',
  `dict_type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '字典类型',
  `status` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '0' COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`dict_id`),
  UNIQUE KEY `dict_type` (`dict_type`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='字典类型表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_dict_type`
--

LOCK TABLES `sys_dict_type` WRITE;
/*!40000 ALTER TABLE `sys_dict_type` DISABLE KEYS */;
INSERT INTO `sys_dict_type` VALUES (1,'用户性别','sys_user_sex','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','用户性别列表'),(2,'菜单状态','sys_show_hide','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','菜单状态列表'),(3,'系统开关','sys_normal_disable','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','系统开关列表'),(4,'任务状态','sys_job_status','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','任务状态列表'),(5,'任务分组','sys_job_group','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','任务分组列表'),(6,'系统是否','sys_yes_no','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','系统是否列表'),(7,'通知类型','sys_notice_type','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','通知类型列表'),(8,'通知状态','sys_notice_status','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','通知状态列表'),(9,'操作类型','sys_oper_type','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','操作类型列表'),(10,'系统状态','sys_common_status','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','登录状态列表'),(11,'充值交易状态','adam_recharge_status','0','admin','2020-11-02 08:51:02','admin','2020-11-02 09:03:09','adam_trans_currency'),(12,'交易币种','adam_trans_currency','0','admin','2020-11-02 09:01:04','admin','2020-11-02 09:03:09','adam_trans_currency'),(13,'下发交易状态','adam_payout_status','0','admin','2020-11-09 07:49:31','admin','2020-11-02 09:03:09','下发交易状态'),(14,'换汇交易状态','adam_conversion_status','0','admin','2020-11-09 07:50:19','admin','2020-11-02 09:03:09','换汇交易状态'),(16,'Wallet Status','fin_wallet_status','0','admin','2020-12-14 14:15:50','',NULL,NULL),(17,'Wallet Pay Status','fin_wallet_pay_status','0','admin','2020-12-14 14:21:54','',NULL,NULL);
/*!40000 ALTER TABLE `sys_dict_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_job`
--

DROP TABLE IF EXISTS `sys_job`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_job` (
  `job_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '任务ID',
  `job_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '任务名称',
  `job_group` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'DEFAULT' COMMENT '任务组名',
  `invoke_target` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '调用目标字符串',
  `cron_expression` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT 'cron执行表达式',
  `misfire_policy` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '3' COMMENT '计划执行错误策略（1立即执行 2执行一次 3放弃执行）',
  `concurrent` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '1' COMMENT '是否并发执行（0允许 1禁止）',
  `status` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '0' COMMENT '状态（0正常 1暂停）',
  `create_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '备注信息',
  PRIMARY KEY (`job_id`,`job_name`,`job_group`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='定时任务调度表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_job`
--

LOCK TABLES `sys_job` WRITE;
/*!40000 ALTER TABLE `sys_job` DISABLE KEYS */;
INSERT INTO `sys_job` VALUES (1,'系统默认（无参）','DEFAULT','ryTask.ryNoParams','0/10 * * * * ?','3','1','1','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(2,'系统默认（有参）','DEFAULT','ryTask.ryParams(\'ry\')','0/15 * * * * ?','3','1','1','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(3,'系统默认（多参）','DEFAULT','ryTask.ryMultipleParams(\'ry\', true, 2000L, 316.50D, 100)','0/20 * * * * ?','3','1','1','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','');
/*!40000 ALTER TABLE `sys_job` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_job_log`
--

DROP TABLE IF EXISTS `sys_job_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_job_log` (
  `job_log_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '任务日志ID',
  `job_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '任务名称',
  `job_group` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '任务组名',
  `invoke_target` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '调用目标字符串',
  `job_message` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '日志信息',
  `status` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '0' COMMENT '执行状态（0正常 1失败）',
  `exception_info` varchar(2000) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '异常信息',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`job_log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='定时任务调度日志表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_job_log`
--

LOCK TABLES `sys_job_log` WRITE;
/*!40000 ALTER TABLE `sys_job_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_job_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_logininfor`
--

DROP TABLE IF EXISTS `sys_logininfor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_logininfor` (
  `info_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '访问ID',
  `login_name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '登录账号',
  `ipaddr` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '登录IP地址',
  `login_location` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '登录地点',
  `browser` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '浏览器类型',
  `os` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '操作系统',
  `status` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '0' COMMENT '登录状态（0成功 1失败）',
  `msg` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '提示消息',
  `login_time` datetime DEFAULT NULL COMMENT '访问时间',
  PRIMARY KEY (`info_id`)
) ENGINE=InnoDB AUTO_INCREMENT=287 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='系统访问记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_logininfor`
--

LOCK TABLES `sys_logininfor` WRITE;
/*!40000 ALTER TABLE `sys_logininfor` DISABLE KEYS */;
INSERT INTO `sys_logininfor` VALUES (100,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','1','验证码错误','2020-09-25 12:17:53'),(101,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','1','密码输入错误1次','2020-09-25 12:18:49'),(102,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','登录成功','2020-09-25 12:19:00'),(103,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','退出成功','2020-09-25 12:24:48'),(104,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','1','密码输入错误1次','2020-09-25 12:24:53'),(105,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','登录成功','2020-09-25 12:25:08'),(106,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','登录成功','2020-09-25 13:35:48'),(107,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','退出成功','2020-09-25 15:19:26'),(108,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','1','密码输入错误1次','2020-09-25 15:19:33'),(109,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','登录成功','2020-09-25 15:19:42'),(110,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','退出成功','2020-09-25 15:33:11'),(111,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','登录成功','2020-09-25 15:33:23'),(112,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','退出成功','2020-09-25 16:17:52'),(113,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','登录成功','2020-09-25 16:18:00'),(114,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-09-25 16:38:37'),(115,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Exit succeeded','2020-09-25 17:10:15'),(116,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-09-25 17:10:21'),(117,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Exit succeeded','2020-09-25 18:34:23'),(118,'anjiabin','127.0.0.1','内网IP','Chrome 8','Windows 10','1','Password input error 1 times','2020-09-25 18:34:34'),(119,'anjiabin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-09-25 18:34:43'),(120,'anjiabin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Exit succeeded','2020-09-25 18:35:04'),(121,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-09-25 18:35:11'),(122,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-09-25 18:49:47'),(123,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-09-27 02:37:41'),(124,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-09-27 02:53:10'),(125,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Exit succeeded','2020-09-27 02:56:59'),(126,'zhangguobing','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-09-27 02:57:13'),(127,'admin','192.168.31.30','内网IP','Chrome 8','Windows 10','0','Login successful','2020-09-27 03:02:53'),(128,'admin','192.168.31.30','内网IP','Chrome 8','Windows 10','0','Exit succeeded','2020-09-27 03:03:18'),(129,'admin','192.168.31.235','内网IP','Firefox 8','Windows 10','0','Login successful','2020-09-27 03:12:07'),(130,'admin','127.0.0.1','内网IP','Chrome 8','Mac OS X','0','Login successful','2020-09-28 12:01:16'),(131,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-09-28 14:03:22'),(132,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-09-30 10:24:42'),(133,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-10-09 13:11:50'),(134,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-10-09 13:47:50'),(135,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','1','Password input error 1 times','2020-10-30 03:58:36'),(136,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-10-30 03:58:43'),(137,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-10-30 04:15:19'),(138,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-10-30 06:11:04'),(139,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-10-30 07:50:42'),(140,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-10-30 07:52:13'),(141,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-10-30 07:55:25'),(142,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-10-30 07:57:40'),(143,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','1','Verification code error','2020-10-30 08:04:17'),(144,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-10-30 08:04:21'),(145,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-10-30 08:37:33'),(146,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-02 02:29:13'),(147,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-02 02:48:52'),(148,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-02 02:56:09'),(149,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-02 02:57:00'),(150,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-02 03:09:36'),(151,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','1','Verification code error','2020-11-02 03:42:08'),(152,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-02 03:42:12'),(153,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-02 03:49:42'),(154,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-02 03:58:06'),(155,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-02 04:08:37'),(156,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-02 06:05:30'),(157,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-02 08:23:27'),(158,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-02 08:34:03'),(159,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-02 08:41:27'),(160,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-02 08:42:52'),(161,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','1','Verification code error','2020-11-02 09:06:34'),(162,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-02 09:06:54'),(163,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-02 09:43:19'),(164,'admin','127.0.0.1','内网IP','Internet Explorer 11','Windows 10','0','Login successful','2020-11-02 10:42:45'),(165,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-03 02:57:42'),(166,'admin','192.168.31.161','内网IP','Chrome 8','Windows 10','1','Verification code error','2020-11-03 03:44:20'),(167,'admin','192.168.31.161','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-03 03:44:25'),(168,'admin','192.168.31.185','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-03 03:45:51'),(169,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-03 05:26:37'),(170,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-03 09:22:38'),(171,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-04 03:34:14'),(172,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-04 03:41:54'),(173,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-04 04:29:11'),(174,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-04 05:39:09'),(175,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','1','Verification code error','2020-11-04 06:27:20'),(176,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-04 06:27:24'),(177,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-04 08:03:22'),(178,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-04 08:26:30'),(179,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-04 08:33:07'),(180,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-04 08:36:30'),(181,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-04 10:22:21'),(182,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-04 10:32:38'),(183,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-04 10:59:11'),(184,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','1','Verification code error','2020-11-04 11:13:13'),(185,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-04 11:13:18'),(186,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-04 11:17:43'),(187,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 02:03:46'),(188,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 02:16:36'),(189,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 02:52:31'),(190,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','1','Verification code error','2020-11-06 03:03:16'),(191,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 03:03:21'),(192,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','1','Verification code error','2020-11-06 03:15:24'),(193,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 03:15:30'),(194,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 03:34:01'),(195,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 03:42:52'),(196,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 03:50:08'),(197,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 03:58:36'),(198,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 04:03:21'),(199,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 05:44:57'),(200,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 06:36:36'),(201,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 07:02:46'),(202,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','1','Verification code error','2020-11-06 07:09:57'),(203,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 07:10:02'),(204,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 07:20:53'),(205,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','1','Verification code error','2020-11-06 07:27:24'),(206,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 07:27:29'),(207,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','1','Verification code error','2020-11-06 07:50:08'),(208,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','1','Verification code error','2020-11-06 07:50:14'),(209,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 07:50:18'),(210,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','1','Verification code error','2020-11-06 07:59:02'),(211,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 07:59:07'),(212,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 08:49:52'),(213,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 09:04:34'),(214,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','1','Verification code error','2020-11-06 09:14:25'),(215,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 09:14:29'),(216,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 09:27:51'),(217,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','1','Verification code error','2020-11-06 09:43:54'),(218,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 09:43:58'),(219,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 09:48:13'),(220,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','1','Verification code error','2020-11-06 09:52:06'),(221,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 09:52:09'),(222,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 09:59:04'),(223,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 10:25:39'),(224,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-06 10:38:11'),(225,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-09 03:03:49'),(226,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-09 03:04:25'),(227,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','1','Verification code error','2020-11-09 03:04:43'),(228,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-09 03:04:46'),(229,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-09 03:09:36'),(230,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-09 03:28:29'),(231,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-09 03:44:34'),(232,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-09 03:50:24'),(233,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-09 04:02:01'),(234,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-09 04:27:54'),(235,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-09 05:43:40'),(236,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-09 05:51:14'),(237,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-09 05:59:33'),(238,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','1','user does not exist / password error','2020-11-09 06:17:56'),(239,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-09 06:18:05'),(240,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-09 07:34:25'),(241,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-09 07:34:32'),(242,'admin','192.168.31.161','内网IP','Chrome 8','Windows 10','1','Verification code error','2020-11-09 07:35:20'),(243,'admin','192.168.31.161','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-09 07:35:24'),(244,'admin','192.168.31.31','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-09 07:37:30'),(245,'admin','127.0.0.1','内网IP','Chrome 8','Windows 10','0','Login successful','2020-11-09 08:44:38'),(246,'admin','127.0.0.1','内网IP','Safari','Mac OS X','0','Login successful','2020-11-17 03:36:41'),(247,'admin','127.0.0.1','内网IP','Chrome 8','Mac OS X','0','Login successful','2020-11-17 03:37:16'),(248,'admin','127.0.0.1','内网IP','Chrome 8','Mac OS X','1','Verification code error','2020-11-20 03:34:25'),(249,'admin','127.0.0.1','内网IP','Chrome 8','Mac OS X','0','Login successful','2020-11-20 03:34:30'),(250,'admin','192.168.31.123','内网IP','Chrome 8','Mac OS X','0','Login successful','2020-11-26 13:58:16'),(251,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-02 18:35:20'),(252,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-09 14:31:42'),(253,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-09 15:54:10'),(254,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-09 15:56:55'),(255,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-11 14:25:27'),(256,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-11 16:23:36'),(257,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-11 17:14:13'),(258,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-11 17:14:59'),(259,'admin','192.168.31.123','内网IP','Safari','Mac OS X','1','Verification code error','2020-12-11 17:15:47'),(260,'admin','192.168.31.123','内网IP','Safari','Mac OS X','0','Login successful','2020-12-11 17:15:50'),(261,'admin','127.0.0.1','内网IP','Safari','Mac OS X','0','Login successful','2020-12-11 17:20:20'),(262,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-11 17:27:14'),(263,'admin','127.0.0.1','内网IP','Chrome 8','Mac OS X','0','Login successful','2020-12-11 17:30:19'),(264,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-11 17:31:29'),(265,'admin','127.0.0.1','内网IP','Safari','Mac OS X','0','Login successful','2020-12-11 17:41:18'),(266,'admin','127.0.0.1','内网IP','Chrome 8','Mac OS X','0','Login successful','2020-12-11 17:53:02'),(267,'admin','127.0.0.1','内网IP','Safari','Mac OS X','0','Login successful','2020-12-11 17:54:25'),(268,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-11 18:07:30'),(269,'admin','127.0.0.1','内网IP','Firefox 8','Mac OS X','0','Login successful','2020-12-11 18:08:12'),(270,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-11 18:08:39'),(271,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-11 18:09:59'),(272,'admin','127.0.0.1','内网IP','Chrome 8','Mac OS X','0','Login successful','2020-12-11 18:39:19'),(273,'admin','127.0.0.1','内网IP','Chrome 8','Mac OS X','0','Login successful','2020-12-11 18:40:56'),(274,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','1','Verification code error','2020-12-11 18:45:15'),(275,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-11 18:45:18'),(276,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-14 10:40:34'),(277,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-14 11:24:27'),(278,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-14 12:46:12'),(279,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-14 13:34:49'),(280,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-14 13:38:47'),(281,'admin','127.0.0.1','内网IP','Chrome 8','Mac OS X','0','Login successful','2020-12-14 13:40:06'),(282,'admin','127.0.0.1','内网IP','Chrome 8','Mac OS X','0','Login successful','2020-12-14 13:41:43'),(283,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-14 14:14:43'),(284,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-14 14:17:21'),(285,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-14 15:49:58'),(286,'admin','192.168.31.229','内网IP','Chrome 8','Windows 10','0','Login successful','2020-12-14 16:28:44');
/*!40000 ALTER TABLE `sys_logininfor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_menu`
--

DROP TABLE IF EXISTS `sys_menu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_menu` (
  `menu_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '菜单ID',
  `menu_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '菜单名称',
  `parent_id` bigint(20) DEFAULT '0' COMMENT '父菜单ID',
  `order_num` int(4) DEFAULT '0' COMMENT '显示顺序',
  `url` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '#' COMMENT '请求地址',
  `target` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '打开方式（menuItem页签 menuBlank新窗口）',
  `menu_type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '菜单类型（M目录 C菜单 F按钮）',
  `visible` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '0' COMMENT '菜单状态（0显示 1隐藏）',
  `perms` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '权限标识',
  `icon` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '#' COMMENT '菜单图标',
  `create_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '备注',
  PRIMARY KEY (`menu_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1072 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='菜单权限表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_menu`
--

LOCK TABLES `sys_menu` WRITE;
/*!40000 ALTER TABLE `sys_menu` DISABLE KEYS */;
INSERT INTO `sys_menu` VALUES (1,'系统管理',0,1,'#','','M','0','','fa fa-gear','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','系统管理目录'),(2,'系统监控',0,2,'#','','M','0','','fa fa-video-camera','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','系统监控目录'),(3,'系统工具',0,3,'#','','M','0','','fa fa-bars','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','系统工具目录'),(4,'LiquidNet官网',0,4,'https://lightnet.io/','menuBlank','C','0','','fa fa-location-arrow','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','正在映画官网地址'),(100,'用户管理',1,1,'/system/user','','C','0','system:user:view','fa fa-user-o','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','用户管理菜单'),(101,'角色管理',1,2,'/system/role','','C','0','system:role:view','fa fa-user-secret','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','角色管理菜单'),(102,'菜单管理',1,3,'/system/menu','','C','0','system:menu:view','fa fa-th-list','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','菜单管理菜单'),(103,'部门管理',1,4,'/system/dept','','C','0','system:dept:view','fa fa-outdent','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','部门管理菜单'),(104,'岗位管理',1,5,'/system/post','','C','0','system:post:view','fa fa-address-card-o','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','岗位管理菜单'),(105,'字典管理',1,6,'/system/dict','','C','0','system:dict:view','fa fa-bookmark-o','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','字典管理菜单'),(106,'参数设置',1,7,'/system/config','','C','0','system:config:view','fa fa-sun-o','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','参数设置菜单'),(107,'通知公告',1,8,'/system/notice','','C','0','system:notice:view','fa fa-bullhorn','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','通知公告菜单'),(108,'日志管理',1,9,'#','','M','0','','fa fa-pencil-square-o','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','日志管理菜单'),(109,'在线用户',2,1,'/monitor/online','','C','0','monitor:online:view','fa fa-user-circle','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','在线用户菜单'),(110,'定时任务',2,2,'/monitor/job','','C','0','monitor:job:view','fa fa-tasks','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','定时任务菜单'),(111,'数据监控',2,3,'/monitor/data','','C','0','monitor:data:view','fa fa-bug','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','数据监控菜单'),(112,'服务监控',2,3,'/monitor/server','','C','0','monitor:server:view','fa fa-server','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','服务监控菜单'),(113,'表单构建',3,1,'/tool/build','','C','0','tool:build:view','fa fa-wpforms','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','表单构建菜单'),(114,'代码生成',3,2,'/tool/gen','','C','0','tool:gen:view','fa fa-code','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','代码生成菜单'),(115,'系统接口',3,3,'/tool/swagger','','C','0','tool:swagger:view','fa fa-gg','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','系统接口菜单'),(500,'操作日志',108,1,'/monitor/operlog','','C','0','monitor:operlog:view','fa fa-address-book','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','操作日志菜单'),(501,'登录日志',108,2,'/monitor/logininfor','','C','0','monitor:logininfor:view','fa fa-file-image-o','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','登录日志菜单'),(1000,'用户查询',100,1,'#','','F','0','system:user:list','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1001,'用户新增',100,2,'#','','F','0','system:user:add','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1002,'用户修改',100,3,'#','','F','0','system:user:edit','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1003,'用户删除',100,4,'#','','F','0','system:user:remove','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1004,'用户导出',100,5,'#','','F','0','system:user:export','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1005,'用户导入',100,6,'#','','F','0','system:user:import','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1006,'重置密码',100,7,'#','','F','0','system:user:resetPwd','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1007,'角色查询',101,1,'#','','F','0','system:role:list','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1008,'角色新增',101,2,'#','','F','0','system:role:add','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1009,'角色修改',101,3,'#','','F','0','system:role:edit','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1010,'角色删除',101,4,'#','','F','0','system:role:remove','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1011,'角色导出',101,5,'#','','F','0','system:role:export','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1012,'菜单查询',102,1,'#','','F','0','system:menu:list','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1013,'菜单新增',102,2,'#','','F','0','system:menu:add','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1014,'菜单修改',102,3,'#','','F','0','system:menu:edit','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1015,'菜单删除',102,4,'#','','F','0','system:menu:remove','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1016,'部门查询',103,1,'#','','F','0','system:dept:list','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1017,'部门新增',103,2,'#','','F','0','system:dept:add','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1018,'部门修改',103,3,'#','','F','0','system:dept:edit','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1019,'部门删除',103,4,'#','','F','0','system:dept:remove','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1020,'岗位查询',104,1,'#','','F','0','system:post:list','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1021,'岗位新增',104,2,'#','','F','0','system:post:add','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1022,'岗位修改',104,3,'#','','F','0','system:post:edit','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1023,'岗位删除',104,4,'#','','F','0','system:post:remove','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1024,'岗位导出',104,5,'#','','F','0','system:post:export','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1025,'字典查询',105,1,'#','','F','0','system:dict:list','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1026,'字典新增',105,2,'#','','F','0','system:dict:add','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1027,'字典修改',105,3,'#','','F','0','system:dict:edit','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1028,'字典删除',105,4,'#','','F','0','system:dict:remove','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1029,'字典导出',105,5,'#','','F','0','system:dict:export','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1030,'参数查询',106,1,'#','','F','0','system:config:list','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1031,'参数新增',106,2,'#','','F','0','system:config:add','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1032,'参数修改',106,3,'#','','F','0','system:config:edit','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1033,'参数删除',106,4,'#','','F','0','system:config:remove','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1034,'参数导出',106,5,'#','','F','0','system:config:export','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1035,'公告查询',107,1,'#','','F','0','system:notice:list','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1036,'公告新增',107,2,'#','','F','0','system:notice:add','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1037,'公告修改',107,3,'#','','F','0','system:notice:edit','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1038,'公告删除',107,4,'#','','F','0','system:notice:remove','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1039,'操作查询',500,1,'#','','F','0','monitor:operlog:list','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1040,'操作删除',500,2,'#','','F','0','monitor:operlog:remove','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1041,'详细信息',500,3,'#','','F','0','monitor:operlog:detail','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1042,'日志导出',500,4,'#','','F','0','monitor:operlog:export','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1043,'登录查询',501,1,'#','','F','0','monitor:logininfor:list','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1044,'登录删除',501,2,'#','','F','0','monitor:logininfor:remove','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1045,'日志导出',501,3,'#','','F','0','monitor:logininfor:export','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1046,'账户解锁',501,4,'#','','F','0','monitor:logininfor:unlock','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1047,'在线查询',109,1,'#','','F','0','monitor:online:list','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1048,'批量强退',109,2,'#','','F','0','monitor:online:batchForceLogout','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1049,'单条强退',109,3,'#','','F','0','monitor:online:forceLogout','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1050,'任务查询',110,1,'#','','F','0','monitor:job:list','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1051,'任务新增',110,2,'#','','F','0','monitor:job:add','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1052,'任务修改',110,3,'#','','F','0','monitor:job:edit','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1053,'任务删除',110,4,'#','','F','0','monitor:job:remove','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1054,'状态修改',110,5,'#','','F','0','monitor:job:changeStatus','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1055,'任务详细',110,6,'#','','F','0','monitor:job:detail','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1056,'任务导出',110,7,'#','','F','0','monitor:job:export','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1057,'生成查询',114,1,'#','','F','0','tool:gen:list','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1058,'生成修改',114,2,'#','','F','0','tool:gen:edit','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1059,'生成删除',114,3,'#','','F','0','tool:gen:remove','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1060,'预览代码',114,4,'#','','F','0','tool:gen:preview','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1061,'生成代码',114,5,'#','','F','0','tool:gen:code','#','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00',''),(1062,'Adam',0,4,'#','menuItem','M','0',NULL,'fa fa-archive','admin','2020-09-28 12:04:25','',NULL,''),(1063,'客户管理',1062,1,'/adam/user','menuItem','C','0','','fa fa-address-book','admin','2020-09-29 13:39:01','admin','2020-10-09 10:03:47',''),(1064,'公司管理',1062,2,'#','menuItem','M','0',NULL,'fa fa-address-book','admin','2020-09-30 17:32:21','',NULL,''),(1065,'公司信息',1064,1,'/adam/com-info/queryList','menuItem','C','0',NULL,'#','admin','2020-09-30 17:34:02','',NULL,''),(1066,'Transaction Details',1062,3,'#','menuItem','M','0','','fa fa-bars','admin','2020-10-30 06:13:39','admin','2020-11-09 06:47:58',''),(1067,'Funding details',1066,1,'/adam/trans-query/rechargeListPage','menuItem','C','0','adam:trans-query:rechargeList','#','admin','2020-10-30 06:14:40','admin','2020-11-09 06:48:33',''),(1068,'Payout details',1066,2,'/adam/trans-query/payoutListPage','menuItem','C','0','adam:trans-query:payoutList','#','admin','2020-10-30 06:15:17','admin','2020-11-09 06:48:16',''),(1069,'Conversion details',1066,3,'/adam/trans-query/conversionListPage','menuItem','C','0','adam:trans-query:conversionList','#','admin','2020-10-30 06:16:23','admin','2020-11-09 06:48:52',''),(1070,'Wallet Management',0,5,'#','menuItem','M','0',NULL,'fa fa-globe','admin','2020-11-06 08:55:12','',NULL,''),(1071,'Wallet Information',1070,1,'/wallet/information','menuItem','C','0','','#','admin','2020-11-06 08:56:49','admin','2020-11-09 03:10:32','');
/*!40000 ALTER TABLE `sys_menu` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_notice`
--

DROP TABLE IF EXISTS `sys_notice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_notice` (
  `notice_id` int(4) NOT NULL AUTO_INCREMENT COMMENT '公告ID',
  `notice_title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '公告标题',
  `notice_type` char(1) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '公告类型（1通知 2公告）',
  `notice_content` varchar(2000) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '公告内容',
  `status` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '0' COMMENT '公告状态（0正常 1关闭）',
  `create_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`notice_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='通知公告表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_notice`
--

LOCK TABLES `sys_notice` WRITE;
/*!40000 ALTER TABLE `sys_notice` DISABLE KEYS */;
INSERT INTO `sys_notice` VALUES (1,'温馨提醒：2018-07-01 正在映画新版本发布啦','2','新版本内容','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','管理员'),(2,'维护通知：2018-07-01 正在映画系统凌晨维护','1','维护内容','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','管理员');
/*!40000 ALTER TABLE `sys_notice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_oper_log`
--

DROP TABLE IF EXISTS `sys_oper_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_oper_log` (
  `oper_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '日志主键',
  `title` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '模块标题',
  `business_type` int(2) DEFAULT '0' COMMENT '业务类型（0其它 1新增 2修改 3删除）',
  `method` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '方法名称',
  `request_method` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '请求方式',
  `operator_type` int(1) DEFAULT '0' COMMENT '操作类别（0其它 1后台用户 2手机端用户）',
  `oper_name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '操作人员',
  `dept_name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '部门名称',
  `oper_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '请求URL',
  `oper_ip` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '主机地址',
  `oper_location` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '操作地点',
  `oper_param` varchar(2000) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '请求参数',
  `json_result` varchar(2000) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '返回参数',
  `status` int(1) DEFAULT '0' COMMENT '操作状态（0正常 1异常）',
  `error_msg` varchar(2000) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '错误消息',
  `oper_time` datetime DEFAULT NULL COMMENT '操作时间',
  PRIMARY KEY (`oper_id`)
) ENGINE=InnoDB AUTO_INCREMENT=263 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='操作日志记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_oper_log`
--

LOCK TABLES `sys_oper_log` WRITE;
/*!40000 ALTER TABLE `sys_oper_log` DISABLE KEYS */;
INSERT INTO `sys_oper_log` VALUES (100,'角色管理',5,'SysRoleController.export()','POST',1,'admin','研发部门','/system/role/export','127.0.0.1','内网IP','{\"roleName\":[\"\"],\"roleKey\":[\"\"],\"status\":[\"\"],\"params[beginTime]\":[\"\"],\"params[endTime]\":[\"\"],\"orderByColumn\":[\"roleSort\"],\"isAsc\":[\"asc\"]}','{\r\n  \"msg\" : \"89fa4be0-4425-4968-b14a-06069ff0d8a1_角色数据.xlsx\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 13:43:32'),(101,'部门管理',2,'SysDeptController.editSave()','POST',1,'admin','研发部门','/system/dept/edit','127.0.0.1','内网IP','{\"deptId\":[\"100\"],\"parentId\":[\"0\"],\"parentName\":[\"无\"],\"deptName\":[\"LiquidNet科技\"],\"orderNum\":[\"0\"],\"leader\":[\"正在映画\"],\"phone\":[\"15888888888\"],\"email\":[\"ry@qq.com\"],\"status\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 16:40:26'),(102,'个人信息',2,'SysProfileController.update()','POST',1,'admin','研发部门','/system/user/profile/update','127.0.0.1','内网IP','{\"id\":[\"\"],\"userName\":[\"admin\"],\"phonenumber\":[\"15888888888\"],\"email\":[\"ry@163.com\"],\"sex\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:23:36'),(103,'用户管理',1,'SysUserController.addSave()','POST',1,'admin','研发部门','/system/user/add','127.0.0.1','内网IP','{\"deptId\":[\"103\"],\"userName\":[\"AnJiabin\"],\"deptName\":[\"研发部门\"],\"phonenumber\":[\"13811114082\"],\"email\":[\"jiabin.an@lightnet.io\"],\"loginName\":[\"anjiabin\"],\"sex\":[\"0\"],\"role\":[\"2\"],\"remark\":[\"\"],\"status\":[\"0\"],\"roleIds\":[\"2\"],\"postIds\":[\"4\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:28:31'),(104,'角色管理',2,'SysRoleController.editSave()','POST',1,'admin','研发部门','/system/role/edit','127.0.0.1','内网IP','{\"roleId\":[\"2\"],\"roleName\":[\"普通角色\"],\"roleKey\":[\"common\"],\"roleSort\":[\"2\"],\"status\":[\"0\"],\"remark\":[\"普通角色\"],\"menuIds\":[\"1,107,1035,1036,1037,1038,108,500,1039,1040,1041,1042,501,1043,1044,1045,1046\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:31:32'),(105,'用户管理',2,'SysUserController.editSave()','POST',1,'admin','研发部门','/system/user/edit','127.0.0.1','内网IP','{\"userId\":[\"100\"],\"deptId\":[\"103\"],\"userName\":[\"AnJiabin\"],\"dept.deptName\":[\"研发部门\"],\"phonenumber\":[\"13811114082\"],\"email\":[\"jiabin.an@lightnet.io\"],\"loginName\":[\"anjiabin\"],\"sex\":[\"0\"],\"role\":[\"2\"],\"remark\":[\"\"],\"status\":[\"0\"],\"roleIds\":[\"2\"],\"postIds\":[\"4\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:33:44'),(106,'部门管理',3,'SysDeptController.remove()','GET',1,'admin','研发部门','/system/dept/remove/102','127.0.0.1','内网IP',NULL,'{\r\n  \"msg\" : \"存在下级部门,不允许删除\",\r\n  \"code\" : 301\r\n}',0,NULL,'2020-09-25 18:40:02'),(107,'部门管理',3,'SysDeptController.remove()','GET',1,'admin','研发部门','/system/dept/remove/102','127.0.0.1','内网IP',NULL,'{\r\n  \"msg\" : \"存在下级部门,不允许删除\",\r\n  \"code\" : 301\r\n}',0,NULL,'2020-09-25 18:40:06'),(108,'部门管理',3,'SysDeptController.remove()','GET',1,'admin','研发部门','/system/dept/remove/109','127.0.0.1','内网IP',NULL,'{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:40:11'),(109,'部门管理',3,'SysDeptController.remove()','GET',1,'admin','研发部门','/system/dept/remove/108','127.0.0.1','内网IP',NULL,'{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:40:13'),(110,'部门管理',2,'SysDeptController.editSave()','POST',1,'admin','研发部门','/system/dept/edit','127.0.0.1','内网IP','{\"deptId\":[\"101\"],\"parentId\":[\"100\"],\"parentName\":[\"LiquidNet科技\"],\"deptName\":[\"创新业务部\"],\"orderNum\":[\"1\"],\"leader\":[\"董敬伟\"],\"phone\":[\"15888888888\"],\"email\":[\"ry@qq.com\"],\"status\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:42:51'),(111,'部门管理',3,'SysDeptController.remove()','GET',1,'admin','研发部门','/system/dept/remove/102','127.0.0.1','内网IP',NULL,'{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:43:17'),(112,'部门管理',1,'SysDeptController.addSave()','POST',1,'admin','研发部门','/system/dept/add','127.0.0.1','内网IP','{\"parentId\":[\"100\"],\"deptName\":[\"区块链\"],\"orderNum\":[\"1\"],\"leader\":[\"\"],\"phone\":[\"\"],\"email\":[\"\"],\"status\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:44:27'),(113,'部门管理',2,'SysDeptController.editSave()','POST',1,'admin','研发部门','/system/dept/edit','127.0.0.1','内网IP','{\"deptId\":[\"106\"],\"parentId\":[\"101\"],\"parentName\":[\"创新业务部\"],\"deptName\":[\"产品部门\"],\"orderNum\":[\"4\"],\"leader\":[\"正在映画\"],\"phone\":[\"15888888888\"],\"email\":[\"ry@qq.com\"],\"status\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:44:57'),(114,'部门管理',2,'SysDeptController.editSave()','POST',1,'admin','研发部门','/system/dept/edit','127.0.0.1','内网IP','{\"deptId\":[\"103\"],\"parentId\":[\"101\"],\"parentName\":[\"创新业务部\"],\"deptName\":[\"研发组\"],\"orderNum\":[\"1\"],\"leader\":[\"正在映画\"],\"phone\":[\"15888888888\"],\"email\":[\"ry@qq.com\"],\"status\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:45:21'),(115,'部门管理',2,'SysDeptController.editSave()','POST',1,'admin','研发部门','/system/dept/edit','127.0.0.1','内网IP','{\"deptId\":[\"104\"],\"parentId\":[\"101\"],\"parentName\":[\"创新业务部\"],\"deptName\":[\"市场组\"],\"orderNum\":[\"2\"],\"leader\":[\"正在映画\"],\"phone\":[\"15888888888\"],\"email\":[\"ry@qq.com\"],\"status\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:45:29'),(116,'部门管理',2,'SysDeptController.editSave()','POST',1,'admin','研发部门','/system/dept/edit','127.0.0.1','内网IP','{\"deptId\":[\"105\"],\"parentId\":[\"101\"],\"parentName\":[\"创新业务部\"],\"deptName\":[\"测试组\"],\"orderNum\":[\"3\"],\"leader\":[\"正在映画\"],\"phone\":[\"15888888888\"],\"email\":[\"ry@qq.com\"],\"status\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:45:37'),(117,'部门管理',2,'SysDeptController.editSave()','POST',1,'admin','研发部门','/system/dept/edit','127.0.0.1','内网IP','{\"deptId\":[\"106\"],\"parentId\":[\"101\"],\"parentName\":[\"创新业务部\"],\"deptName\":[\"产品组\"],\"orderNum\":[\"4\"],\"leader\":[\"正在映画\"],\"phone\":[\"15888888888\"],\"email\":[\"ry@qq.com\"],\"status\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:45:44'),(118,'部门管理',2,'SysDeptController.editSave()','POST',1,'admin','研发部门','/system/dept/edit','127.0.0.1','内网IP','{\"deptId\":[\"107\"],\"parentId\":[\"101\"],\"parentName\":[\"创新业务部\"],\"deptName\":[\"运维\"],\"orderNum\":[\"5\"],\"leader\":[\"正在映画\"],\"phone\":[\"15888888888\"],\"email\":[\"ry@qq.com\"],\"status\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:45:49'),(119,'部门管理',2,'SysDeptController.editSave()','POST',1,'admin','研发部门','/system/dept/edit','127.0.0.1','内网IP','{\"deptId\":[\"107\"],\"parentId\":[\"101\"],\"parentName\":[\"创新业务部\"],\"deptName\":[\"运维组\"],\"orderNum\":[\"5\"],\"leader\":[\"正在映画\"],\"phone\":[\"15888888888\"],\"email\":[\"ry@qq.com\"],\"status\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:45:56'),(120,'角色管理',2,'SysRoleController.editSave()','POST',1,'admin','研发部门','/system/role/edit','127.0.0.1','内网IP','{\"roleId\":[\"1\"],\"roleName\":[\"超级管理员\"],\"roleKey\":[\"super-admin\"],\"roleSort\":[\"1\"],\"status\":[\"0\"],\"remark\":[\"超级管理员\"],\"menuIds\":[\"\"]}','null',1,'不允许操作超级管理员角色','2020-09-25 18:48:10'),(121,'角色管理',1,'SysRoleController.addSave()','POST',1,'admin','研发部门','/system/role/add','127.0.0.1','内网IP','{\"roleName\":[\"管理员\"],\"roleKey\":[\"sub_admin\"],\"roleSort\":[\"1\"],\"status\":[\"0\"],\"remark\":[\"\"],\"menuIds\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:48:41'),(122,'角色管理',4,'SysRoleController.cancelAuthUser()','POST',1,'admin','研发组','/system/role/authUser/cancel','127.0.0.1','内网IP','{\"roleId\":[\"2\"],\"userId\":[\"2\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:50:37'),(123,'用户管理',3,'SysUserController.remove()','POST',1,'admin','研发组','/system/user/remove','127.0.0.1','内网IP','{\"ids\":[\"2\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:50:46'),(124,'岗位管理',3,'SysPostController.remove()','POST',1,'admin','研发组','/system/post/remove','127.0.0.1','内网IP','{\"ids\":[\"3\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:51:59'),(125,'岗位管理',3,'SysPostController.remove()','POST',1,'admin','研发组','/system/post/remove','127.0.0.1','内网IP','{\"ids\":[\"2\"]}','{\r\n  \"msg\" : \"项目经理已分配,不能删除\",\r\n  \"code\" : 500\r\n}',0,NULL,'2020-09-25 18:52:01'),(126,'岗位管理',3,'SysPostController.remove()','POST',1,'admin','研发组','/system/post/remove','127.0.0.1','内网IP','{\"ids\":[\"1\"]}','{\r\n  \"msg\" : \"董事长已分配,不能删除\",\r\n  \"code\" : 500\r\n}',0,NULL,'2020-09-25 18:52:13'),(127,'岗位管理',2,'SysPostController.editSave()','POST',1,'admin','研发组','/system/post/edit','127.0.0.1','内网IP','{\"postId\":[\"1\"],\"postName\":[\"董事长\"],\"postCode\":[\"ceo\"],\"postSort\":[\"1\"],\"status\":[\"1\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:53:00'),(128,'岗位管理',2,'SysPostController.editSave()','POST',1,'admin','研发组','/system/post/edit','127.0.0.1','内网IP','{\"postId\":[\"2\"],\"postName\":[\"项目经理\"],\"postCode\":[\"se\"],\"postSort\":[\"2\"],\"status\":[\"1\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-25 18:53:04'),(129,'岗位管理',3,'SysPostController.remove()','POST',1,'admin','研发组','/system/post/remove','127.0.0.1','内网IP','{\"ids\":[\"1\"]}','{\r\n  \"msg\" : \"董事长已分配,不能删除\",\r\n  \"code\" : 500\r\n}',0,NULL,'2020-09-25 18:53:07'),(130,'岗位管理',3,'SysPostController.remove()','POST',1,'admin','研发组','/system/post/remove','127.0.0.1','内网IP','{\"ids\":[\"1,2\"]}','{\r\n  \"msg\" : \"董事长已分配,不能删除\",\r\n  \"code\" : 500\r\n}',0,NULL,'2020-09-25 18:54:47'),(131,'用户管理',2,'SysUserController.editSave()','POST',1,'admin','研发组','/system/user/edit','127.0.0.1','内网IP','{\"userId\":[\"1\"],\"deptId\":[\"103\"],\"userName\":[\"超级管理员\"],\"dept.deptName\":[\"研发组\"],\"phonenumber\":[\"15888888888\"],\"email\":[\"ry@163.com\"],\"loginName\":[\"admin\"],\"sex\":[\"0\"],\"role\":[\"1\"],\"remark\":[\"管理员\"],\"status\":[\"0\"],\"roleIds\":[\"1\"],\"postIds\":[\"1\"]}','null',1,'不允许操作超级管理员用户','2020-09-25 18:56:34'),(132,'用户管理',2,'SysUserController.editSave()','POST',1,'admin','研发组','/system/user/edit','127.0.0.1','内网IP','{\"userId\":[\"1\"],\"deptId\":[\"103\"],\"userName\":[\"admin\"],\"dept.deptName\":[\"研发组\"],\"phonenumber\":[\"15888888888\"],\"email\":[\"ry@163.com\"],\"loginName\":[\"admin\"],\"sex\":[\"0\"],\"role\":[\"1\"],\"remark\":[\"管理员\"],\"status\":[\"0\"],\"roleIds\":[\"1\"],\"postIds\":[\"4\"]}','null',1,'不允许操作超级管理员用户','2020-09-25 18:56:54'),(133,'用户管理',1,'SysUserController.addSave()','POST',1,'admin','研发组','/system/user/add','127.0.0.1','内网IP','{\"deptId\":[\"103\"],\"userName\":[\"zhangguobing\"],\"deptName\":[\"研发组\"],\"phonenumber\":[\"13811111111\"],\"email\":[\"zhangguobing@lightnet.com\"],\"loginName\":[\"zhangguobing\"],\"sex\":[\"0\"],\"role\":[\"2\"],\"remark\":[\"\"],\"status\":[\"0\"],\"roleIds\":[\"2\"],\"postIds\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-27 02:56:53'),(134,'菜单管理',1,'SysMenuController.addSave()','POST',1,'admin','研发组','/system/menu/add','127.0.0.1','内网IP','{\"parentId\":[\"0\"],\"menuType\":[\"M\"],\"menuName\":[\"Adam\"],\"url\":[\"\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"4\"],\"icon\":[\"fa fa-archive\"],\"visible\":[\"0\"]}','{\n  \"msg\" : \"操作成功\",\n  \"code\" : 0\n}',0,NULL,'2020-09-28 12:04:26'),(135,'菜单管理',1,'SysMenuController.addSave()','POST',1,'admin','研发组','/system/menu/add','127.0.0.1','内网IP','{\"parentId\":[\"1062\"],\"menuType\":[\"M\"],\"menuName\":[\"客户管理\"],\"url\":[\"/system/customer\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"1\"],\"icon\":[\"fa fa-address-book\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-29 13:39:01'),(136,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','127.0.0.1','内网IP','{\"menuId\":[\"1063\"],\"parentId\":[\"1062\"],\"menuType\":[\"C\"],\"menuName\":[\"客户管理\"],\"url\":[\"/adam/customer\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"1\"],\"icon\":[\"fa fa-address-book\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-09-30 10:27:33'),(137,'菜单管理',1,'SysMenuController.addSave()','POST',1,'admin','研发组','/system/menu/add','127.0.0.1','内网IP','{\"parentId\":[\"1062\"],\"menuType\":[\"M\"],\"menuName\":[\"公司管理\"],\"url\":[\"\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"2\"],\"icon\":[\"fa fa-address-book\"],\"visible\":[\"0\"]}','{\n  \"msg\" : \"操作成功\",\n  \"code\" : 0\n}',0,NULL,'2020-09-30 17:32:21'),(138,'菜单管理',1,'SysMenuController.addSave()','POST',1,'admin','研发组','/system/menu/add','127.0.0.1','内网IP','{\"parentId\":[\"1064\"],\"menuType\":[\"C\"],\"menuName\":[\"公司信息\"],\"url\":[\"/adam/com-info/queryList\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"1\"],\"icon\":[\"\"],\"visible\":[\"0\"]}','{\n  \"msg\" : \"操作成功\",\n  \"code\" : 0\n}',0,NULL,'2020-09-30 17:34:02'),(139,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','127.0.0.1','内网IP','{\"menuId\":[\"1063\"],\"parentId\":[\"1062\"],\"menuType\":[\"C\"],\"menuName\":[\"客户管理\"],\"url\":[\"/adam/user\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"1\"],\"icon\":[\"fa fa-address-book\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-10-09 10:03:47'),(140,'菜单管理',1,'SysMenuController.addSave()','POST',1,'admin','研发组','/system/menu/add','192.168.31.31','内网IP','{\"parentId\":[\"1062\"],\"menuType\":[\"M\"],\"menuName\":[\"交易查询\"],\"url\":[\"\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"3\"],\"icon\":[\"fa fa-bars\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-10-30 06:13:39'),(141,'菜单管理',1,'SysMenuController.addSave()','POST',1,'admin','研发组','/system/menu/add','192.168.31.31','内网IP','{\"parentId\":[\"1066\"],\"menuType\":[\"C\"],\"menuName\":[\"交易订单查询\"],\"url\":[\"\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"1\"],\"icon\":[\"\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-10-30 06:14:40'),(142,'菜单管理',1,'SysMenuController.addSave()','POST',1,'admin','研发组','/system/menu/add','192.168.31.31','内网IP','{\"parentId\":[\"1066\"],\"menuType\":[\"C\"],\"menuName\":[\"下发订单查询\"],\"url\":[\"\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"2\"],\"icon\":[\"\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-10-30 06:15:17'),(143,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','192.168.31.31','内网IP','{\"menuId\":[\"1067\"],\"parentId\":[\"1066\"],\"menuType\":[\"C\"],\"menuName\":[\"充值订单查询\"],\"url\":[\"#\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"1\"],\"icon\":[\"#\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-10-30 06:15:27'),(144,'菜单管理',1,'SysMenuController.addSave()','POST',1,'admin','研发组','/system/menu/add','192.168.31.31','内网IP','{\"parentId\":[\"1066\"],\"menuType\":[\"C\"],\"menuName\":[\"换汇订单查询\"],\"url\":[\"\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"3\"],\"icon\":[\"\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-10-30 06:16:23'),(145,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','192.168.31.31','内网IP','{\"menuId\":[\"1067\"],\"parentId\":[\"1066\"],\"menuType\":[\"C\"],\"menuName\":[\"充值订单查询\"],\"url\":[\"/adam/rechargeList\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"1\"],\"icon\":[\"#\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-10-30 07:51:22'),(146,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','192.168.31.31','内网IP','{\"menuId\":[\"1068\"],\"parentId\":[\"1066\"],\"menuType\":[\"C\"],\"menuName\":[\"下发订单查询\"],\"url\":[\"/adam//payoutList\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"2\"],\"icon\":[\"#\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-10-30 07:51:48'),(147,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','192.168.31.31','内网IP','{\"menuId\":[\"1069\"],\"parentId\":[\"1066\"],\"menuType\":[\"C\"],\"menuName\":[\"换汇订单查询\"],\"url\":[\"/adam/conversionList\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"3\"],\"icon\":[\"#\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-10-30 07:52:04'),(148,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','192.168.31.31','内网IP','{\"menuId\":[\"1067\"],\"parentId\":[\"1066\"],\"menuType\":[\"C\"],\"menuName\":[\"充值订单查询\"],\"url\":[\"/adam/trans-query/rechargeList\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"1\"],\"icon\":[\"#\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-10-30 07:56:22'),(149,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','192.168.31.31','内网IP','{\"menuId\":[\"1068\"],\"parentId\":[\"1066\"],\"menuType\":[\"C\"],\"menuName\":[\"下发订单查询\"],\"url\":[\"/adam/trans-query/payoutList\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"2\"],\"icon\":[\"#\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-10-30 07:56:36'),(150,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','192.168.31.31','内网IP','{\"menuId\":[\"1069\"],\"parentId\":[\"1066\"],\"menuType\":[\"C\"],\"menuName\":[\"换汇订单查询\"],\"url\":[\"/adam/trans-query/conversionList\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"3\"],\"icon\":[\"#\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-10-30 07:57:11'),(151,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','192.168.31.31','内网IP','{\"menuId\":[\"1068\"],\"parentId\":[\"1066\"],\"menuType\":[\"C\"],\"menuName\":[\"下发订单查询\"],\"url\":[\"/adam/trans-query/payoutList\"],\"target\":[\"menuItem\"],\"perms\":[\"adam:trans-query:payoutList\"],\"orderNum\":[\"2\"],\"icon\":[\"#\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-10-30 08:03:28'),(152,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','192.168.31.31','内网IP','{\"menuId\":[\"1067\"],\"parentId\":[\"1066\"],\"menuType\":[\"C\"],\"menuName\":[\"充值订单查询\"],\"url\":[\"/adam/trans-query/rechargeList\"],\"target\":[\"menuItem\"],\"perms\":[\"adam:trans-query:rechargeList\"],\"orderNum\":[\"1\"],\"icon\":[\"#\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-10-30 08:03:42'),(153,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','192.168.31.31','内网IP','{\"menuId\":[\"1069\"],\"parentId\":[\"1066\"],\"menuType\":[\"C\"],\"menuName\":[\"换汇订单查询\"],\"url\":[\"/adam/trans-query/conversionList\"],\"target\":[\"menuItem\"],\"perms\":[\"adam:trans-query:conversionList\"],\"orderNum\":[\"3\"],\"icon\":[\"#\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-10-30 08:04:07'),(154,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','192.168.31.31','内网IP','{\"menuId\":[\"1067\"],\"parentId\":[\"1066\"],\"menuType\":[\"C\"],\"menuName\":[\"充值订单查询\"],\"url\":[\"/adam/trans-query/rechargeListPage\"],\"target\":[\"menuItem\"],\"perms\":[\"adam:trans-query:rechargeList\"],\"orderNum\":[\"1\"],\"icon\":[\"#\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-02 02:56:26'),(155,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','192.168.31.31','内网IP','{\"menuId\":[\"1068\"],\"parentId\":[\"1066\"],\"menuType\":[\"C\"],\"menuName\":[\"下发订单查询\"],\"url\":[\"/adam/trans-query/payoutListPage\"],\"target\":[\"menuItem\"],\"perms\":[\"adam:trans-query:payoutList\"],\"orderNum\":[\"2\"],\"icon\":[\"#\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-02 02:56:39'),(156,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','192.168.31.31','内网IP','{\"menuId\":[\"1069\"],\"parentId\":[\"1066\"],\"menuType\":[\"C\"],\"menuName\":[\"换汇订单查询\"],\"url\":[\"/adam/trans-query/conversionListPage\"],\"target\":[\"menuItem\"],\"perms\":[\"adam:trans-query:conversionList\"],\"orderNum\":[\"3\"],\"icon\":[\"#\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-02 02:56:50'),(157,'字典类型',1,'SysDictTypeController.addSave()','POST',1,'admin','研发组','/system/dict/add','192.168.31.31','内网IP','{\"dictName\":[\"交易币种\"],\"dictType\":[\"adam_trans_currency\"],\"status\":[\"0\"],\"remark\":[\"adam_trans_currency\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-02 08:51:02'),(158,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.31','内网IP','{\"dictLabel\":[\"成功\"],\"dictValue\":[\"success\"],\"dictType\":[\"adam_trans_currency\"],\"cssClass\":[\"\"],\"dictSort\":[\"1\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-02 08:58:15'),(159,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.31','内网IP','{\"dictLabel\":[\"失败\"],\"dictValue\":[\"fail\"],\"dictType\":[\"adam_trans_currency\"],\"cssClass\":[\"\"],\"dictSort\":[\"2\"],\"listClass\":[\"\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-02 08:59:05'),(160,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.31','内网IP','{\"dictLabel\":[\"处理中\"],\"dictValue\":[\"processing\"],\"dictType\":[\"adam_trans_currency\"],\"cssClass\":[\"\"],\"dictSort\":[\"3\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-02 08:59:36'),(161,'字典类型',2,'SysDictTypeController.editSave()','POST',1,'admin','研发组','/system/dict/edit','192.168.31.31','内网IP','{\"dictId\":[\"11\"],\"dictName\":[\"交易币种\"],\"dictType\":[\"adam_recharge_status\"],\"status\":[\"0\"],\"remark\":[\"adam_trans_currency\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-02 09:00:38'),(162,'字典类型',1,'SysDictTypeController.addSave()','POST',1,'admin','研发组','/system/dict/add','192.168.31.31','内网IP','{\"dictName\":[\"交易币种\"],\"dictType\":[\"adam_trans_currency\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-02 09:01:04'),(163,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.31','内网IP','{\"dictLabel\":[\"USD\"],\"dictValue\":[\"USD\"],\"dictType\":[\"adam_trans_currency\"],\"cssClass\":[\"\"],\"dictSort\":[\"1\"],\"listClass\":[\"\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-02 09:01:39'),(164,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.31','内网IP','{\"dictLabel\":[\"GBP\"],\"dictValue\":[\"GBP\"],\"dictType\":[\"adam_trans_currency\"],\"cssClass\":[\"\"],\"dictSort\":[\"2\"],\"listClass\":[\"\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-02 09:01:52'),(165,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.31','内网IP','{\"dictLabel\":[\"EUR\"],\"dictValue\":[\"EUR\"],\"dictType\":[\"adam_trans_currency\"],\"cssClass\":[\"\"],\"dictSort\":[\"3\"],\"listClass\":[\"\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-02 09:02:09'),(166,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.31','内网IP','{\"dictLabel\":[\"CNY\"],\"dictValue\":[\"CNY\"],\"dictType\":[\"adam_trans_currency\"],\"cssClass\":[\"\"],\"dictSort\":[\"3\"],\"listClass\":[\"\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-02 09:02:28'),(167,'字典类型',2,'SysDictTypeController.editSave()','POST',1,'admin','研发组','/system/dict/edit','192.168.31.31','内网IP','{\"dictId\":[\"11\"],\"dictName\":[\"充值交易状态\"],\"dictType\":[\"adam_recharge_status\"],\"status\":[\"0\"],\"remark\":[\"adam_trans_currency\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-02 09:03:09'),(168,'用户管理',5,'SysUserController.export()','POST',1,'admin','研发组','/system/user/export','192.168.31.31','内网IP','{\"deptId\":[\"\"],\"parentId\":[\"\"],\"loginName\":[\"\"],\"phonenumber\":[\"\"],\"status\":[\"\"],\"params[beginTime]\":[\"\"],\"params[endTime]\":[\"\"],\"orderByColumn\":[\"createTime\"],\"isAsc\":[\"desc\"]}','{\r\n  \"msg\" : \"990f0507-9105-4035-8c09-3e9b15f44005_用户数据.xlsx\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-04 10:32:46'),(169,'充值订单导出',5,'com.liquidnet.client.admin.web.controller.adam.transaction.TransactionQueryController.rechargeListExport()','POST',1,'admin','研发组','/adam/trans-query/rechargeListExport','192.168.31.31','内网IP','{\"transactionId\":[\"\"],\"walletNo\":[\"\"],\"currency\":[\"\"],\"transactionAmountBegin\":[\"\"],\"transactionAmountEnd\":[\"\"],\"createDateBegin\":[\"\"],\"createDateEnd\":[\"\"],\"completedDateBegin\":[\"\"],\"completedDateEnd\":[\"\"],\"transactionStatus\":[\"\"],\"orderByColumn\":[\"createTime\"],\"isAsc\":[\"desc\"]}','null',1,'','2020-11-04 11:02:03'),(170,'充值订单导出',5,'com.liquidnet.client.admin.web.controller.adam.transaction.TransactionQueryController.rechargeListExport()','POST',1,'admin','研发组','/adam/trans-query/rechargeListExport','192.168.31.31','内网IP','{\"transactionId\":[\"\"],\"walletNo\":[\"\"],\"currency\":[\"\"],\"transactionAmountBegin\":[\"\"],\"transactionAmountEnd\":[\"\"],\"createDateBegin\":[\"\"],\"createDateEnd\":[\"\"],\"completedDateBegin\":[\"\"],\"completedDateEnd\":[\"\"],\"transactionStatus\":[\"\"],\"orderByColumn\":[\"createTime\"],\"isAsc\":[\"desc\"]}','null',1,'','2020-11-04 11:02:11'),(171,'充值订单导出',5,'com.liquidnet.client.admin.web.controller.adam.transaction.TransactionQueryController.rechargeListExport()','POST',1,'admin','研发组','/adam/trans-query/rechargeListExport','192.168.31.31','内网IP','{\"transactionId\":[\"\"],\"walletNo\":[\"\"],\"currency\":[\"\"],\"transactionAmountBegin\":[\"\"],\"transactionAmountEnd\":[\"\"],\"createDateBegin\":[\"\"],\"createDateEnd\":[\"\"],\"completedDateBegin\":[\"\"],\"completedDateEnd\":[\"\"],\"transactionStatus\":[\"\"],\"orderByColumn\":[\"createTime\"],\"isAsc\":[\"desc\"]}','null',1,'','2020-11-04 11:02:18'),(172,'充值订单导出',5,'com.liquidnet.client.admin.web.controller.adam.transaction.TransactionQueryController.rechargeListExport()','POST',1,'admin','研发组','/adam/trans-query/rechargeListExport','192.168.31.31','内网IP','{\"transactionId\":[\"\"],\"walletNo\":[\"\"],\"currency\":[\"\"],\"transactionAmountBegin\":[\"\"],\"transactionAmountEnd\":[\"\"],\"createDateBegin\":[\"\"],\"createDateEnd\":[\"\"],\"completedDateBegin\":[\"\"],\"completedDateEnd\":[\"\"],\"transactionStatus\":[\"\"],\"orderByColumn\":[\"createTime\"],\"isAsc\":[\"desc\"]}','null',1,'','2020-11-04 11:14:11'),(173,'充值订单导出',5,'com.liquidnet.client.admin.web.controller.adam.transaction.TransactionQueryController.rechargeListExport()','POST',1,'admin','研发组','/adam/trans-query/rechargeListExport','192.168.31.31','内网IP','{\"transactionId\":[\"\"],\"walletNo\":[\"\"],\"currency\":[\"\"],\"transactionAmountBegin\":[\"\"],\"transactionAmountEnd\":[\"\"],\"createDateBegin\":[\"\"],\"createDateEnd\":[\"\"],\"completedDateBegin\":[\"\"],\"completedDateEnd\":[\"\"],\"transactionStatus\":[\"\"],\"orderByColumn\":[\"createTime\"],\"isAsc\":[\"desc\"]}','null',1,'','2020-11-04 11:14:29'),(174,'充值订单导出',5,'com.liquidnet.client.admin.web.controller.adam.transaction.TransactionQueryController.rechargeListExport()','POST',1,'admin','研发组','/adam/trans-query/rechargeListExport','127.0.0.1','内网IP','{\"transactionId\":[\"\"],\"walletNo\":[\"\"],\"currency\":[\"\"],\"transactionAmountBegin\":[\"\"],\"transactionAmountEnd\":[\"\"],\"createDateBegin\":[\"\"],\"createDateEnd\":[\"\"],\"completedDateBegin\":[\"\"],\"completedDateEnd\":[\"\"],\"transactionStatus\":[\"\"],\"orderByColumn\":[\"createTime\"],\"isAsc\":[\"desc\"]}','{\r\n  \"msg\" : \"cec870b8-f6d6-4faa-b1ff-f1743d099eae_rechargeList.xlsx\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-06 02:16:52'),(175,'充值订单导出',5,'com.liquidnet.client.admin.web.controller.adam.transaction.TransactionQueryController.rechargeListExport()','POST',1,'admin','研发组','/adam/trans-query/rechargeListExport','127.0.0.1','内网IP','{\"transactionId\":[\"\"],\"walletNo\":[\"\"],\"currency\":[\"\"],\"transactionAmountBegin\":[\"\"],\"transactionAmountEnd\":[\"\"],\"createDateBegin\":[\"\"],\"createDateEnd\":[\"\"],\"completedDateBegin\":[\"\"],\"completedDateEnd\":[\"\"],\"transactionStatus\":[\"\"],\"orderByColumn\":[\"createTime\"],\"isAsc\":[\"desc\"]}','{\r\n  \"msg\" : \"da2c3a7f-5dba-484f-99cb-2b1df8934e50_rechargeList.xlsx\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-06 02:25:36'),(176,'下发订单导出',5,'com.liquidnet.client.admin.web.controller.adam.transaction.TransactionQueryController.payoutListExport()','POST',1,'admin','研发组','/adam/trans-query/payoutListExport','127.0.0.1','内网IP','{\"transactionId\":[\"\"],\"walletNo\":[\"\"],\"currency\":[\"\"],\"transactionAmountBegin\":[\"\"],\"transactionAmountEnd\":[\"\"],\"transactionDateBegin\":[\"\"],\"transactionDateEnd\":[\"\"],\"executionDateBegin\":[\"\"],\"executionDateEnd\":[\"\"],\"transactionStatus\":[\"\"],\"orderByColumn\":[\"createTime\"],\"isAsc\":[\"desc\"]}','{\r\n  \"msg\" : \"02d86b6d-a465-4fe6-92a4-d1b93e8720c8_payoutList.xlsx\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-06 03:43:00'),(177,'下发订单导出',5,'com.liquidnet.client.admin.web.controller.adam.transaction.TransactionQueryController.payoutListExport()','POST',1,'admin','研发组','/adam/trans-query/payoutListExport','127.0.0.1','内网IP','{\"transactionId\":[\"\"],\"fromWallet\":[\"\"],\"toWallet\":[\"\"],\"fromCurrency\":[\"\"],\"toCurrency\":[\"\"],\"amountType\":[\"\"],\"transactionAmountBegin\":[\"\"],\"transactionAmountEnd\":[\"\"],\"transactionStatus\":[\"\"],\"createDateBegin\":[\"\"],\"createDateEnd\":[\"\"],\"conversionDateBegin\":[\"\"],\"conversionDateEnd\":[\"\"],\"settlementDateBegin\":[\"\"],\"settlementDateEnd\":[\"\"],\"orderByColumn\":[\"createTime\"],\"isAsc\":[\"desc\"]}','{\r\n  \"msg\" : \"4e9b59d9-4e4a-4750-8227-b86455517d51_payoutList.xlsx\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-06 03:44:13'),(178,'充值订单导出',5,'com.liquidnet.client.admin.web.controller.adam.transaction.TransactionQueryController.rechargeListExport()','POST',1,'admin','研发组','/adam/trans-query/rechargeListExport','127.0.0.1','内网IP','{\"transactionId\":[\"\"],\"walletNo\":[\"\"],\"currency\":[\"\"],\"transactionAmountBegin\":[\"\"],\"transactionAmountEnd\":[\"\"],\"createDateBegin\":[\"\"],\"createDateEnd\":[\"\"],\"completedDateBegin\":[\"\"],\"completedDateEnd\":[\"\"],\"transactionStatus\":[\"\"],\"orderByColumn\":[\"createTime\"],\"isAsc\":[\"desc\"]}','{\r\n  \"msg\" : \"cfcb63df-6705-4abb-a468-aa5543d53eec_rechargeList.xlsx\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-06 03:50:19'),(179,'下发订单导出',5,'com.liquidnet.client.admin.web.controller.adam.transaction.TransactionQueryController.payoutListExport()','POST',1,'admin','研发组','/adam/trans-query/payoutListExport','127.0.0.1','内网IP','{\"transactionId\":[\"\"],\"fromWallet\":[\"\"],\"toWallet\":[\"\"],\"fromCurrency\":[\"\"],\"toCurrency\":[\"\"],\"amountType\":[\"\"],\"transactionAmountBegin\":[\"\"],\"transactionAmountEnd\":[\"\"],\"transactionStatus\":[\"\"],\"createDateBegin\":[\"\"],\"createDateEnd\":[\"\"],\"conversionDateBegin\":[\"\"],\"conversionDateEnd\":[\"\"],\"settlementDateBegin\":[\"\"],\"settlementDateEnd\":[\"\"],\"orderByColumn\":[\"createTime\"],\"isAsc\":[\"desc\"]}','{\r\n  \"msg\" : \"d6c9e62f-1a6a-4bca-96f9-873bc3332ac1_payoutList.xlsx\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-06 03:58:50'),(180,'下发订单导出',5,'com.liquidnet.client.admin.web.controller.adam.transaction.TransactionQueryController.payoutListExport()','POST',1,'admin','研发组','/adam/trans-query/payoutListExport','127.0.0.1','内网IP','{\"transactionId\":[\"\"],\"walletNo\":[\"\"],\"currency\":[\"\"],\"transactionAmountBegin\":[\"\"],\"transactionAmountEnd\":[\"\"],\"transactionDateBegin\":[\"\"],\"transactionDateEnd\":[\"\"],\"executionDateBegin\":[\"\"],\"executionDateEnd\":[\"\"],\"transactionStatus\":[\"\"],\"orderByColumn\":[\"createTime\"],\"isAsc\":[\"desc\"]}','{\r\n  \"msg\" : \"b5847c4a-3c8a-48e4-b558-c51d61fd63fd_payoutList.xlsx\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-06 03:59:41'),(181,'下发订单导出',5,'com.liquidnet.client.admin.web.controller.adam.transaction.TransactionQueryController.conversionListExport()','POST',1,'admin','研发组','/adam/trans-query/conversionListExport','127.0.0.1','内网IP','{\"transactionId\":[\"\"],\"fromWallet\":[\"\"],\"toWallet\":[\"\"],\"fromCurrency\":[\"\"],\"toCurrency\":[\"\"],\"amountType\":[\"\"],\"transactionAmountBegin\":[\"\"],\"transactionAmountEnd\":[\"\"],\"transactionStatus\":[\"\"],\"createDateBegin\":[\"\"],\"createDateEnd\":[\"\"],\"conversionDateBegin\":[\"\"],\"conversionDateEnd\":[\"\"],\"settlementDateBegin\":[\"\"],\"settlementDateEnd\":[\"\"],\"orderByColumn\":[\"createTime\"],\"isAsc\":[\"desc\"]}','{\r\n  \"msg\" : \"c32b53d4-71ce-4ff5-88ce-b4b5b0748969_conversionList.xlsx\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-06 04:03:30'),(182,'账户解锁',0,'SysLogininforController.unlock()','POST',1,'admin','研发组','/monitor/logininfor/unlock','127.0.0.1','内网IP','{\"loginName\":[\"admin\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-06 06:37:35'),(183,'菜单管理',1,'SysMenuController.addSave()','POST',1,'admin','研发组','/system/menu/add','192.168.31.229','内网IP','{\"parentId\":[\"0\"],\"menuType\":[\"M\"],\"menuName\":[\"Wallet Management\"],\"url\":[\"\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"5\"],\"icon\":[\"fa fa-globe\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-06 08:55:12'),(184,'菜单管理',1,'SysMenuController.addSave()','POST',1,'admin','研发组','/system/menu/add','192.168.31.229','内网IP','{\"parentId\":[\"1070\"],\"menuType\":[\"M\"],\"menuName\":[\"Wallet Information\"],\"url\":[\"\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"1\"],\"icon\":[\"\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-06 08:56:49'),(185,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','192.168.31.229','内网IP','{\"menuId\":[\"1071\"],\"parentId\":[\"1070\"],\"menuType\":[\"C\"],\"menuName\":[\"Wallet Information\"],\"url\":[\"#\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"1\"],\"icon\":[\"#\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-06 08:58:54'),(186,'下发订单导出',5,'com.liquidnet.client.admin.web.controller.adam.transaction.TransactionQueryController.payoutListExport()','POST',1,'admin','研发组','/adam/trans-query/payoutListExport','127.0.0.1','内网IP','{\"transactionId\":[\"\"],\"walletNo\":[\"\"],\"currency\":[\"\"],\"transactionAmountBegin\":[\"\"],\"transactionAmountEnd\":[\"\"],\"transactionDateBegin\":[\"\"],\"transactionDateEnd\":[\"\"],\"executionDateBegin\":[\"\"],\"executionDateEnd\":[\"\"],\"transactionStatus\":[\"\"],\"orderByColumn\":[\"createTime\"],\"isAsc\":[\"desc\"]}','{\r\n  \"msg\" : \"1e5b0bee-c2aa-4608-93fd-799909e9b8d2_payoutList.xlsx\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-06 09:59:46'),(187,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','192.168.31.229','内网IP','{\"menuId\":[\"1071\"],\"parentId\":[\"1070\"],\"menuType\":[\"C\"],\"menuName\":[\"Wallet Information\"],\"url\":[\"/wallet/information\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"1\"],\"icon\":[\"#\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 03:10:32'),(188,'下发订单导出',5,'com.liquidnet.client.admin.web.controller.adam.transaction.TransactionQueryController.payoutListExport()','POST',1,'admin','研发组','/adam/trans-query/payoutListExport','127.0.0.1','内网IP','{\"transactionId\":[\"\"],\"walletNo\":[\"\"],\"currency\":[\"\"],\"transactionAmountBegin\":[\"\"],\"transactionAmountEnd\":[\"\"],\"transactionDateBegin\":[\"\"],\"transactionDateEnd\":[\"\"],\"executionDateBegin\":[\"\"],\"executionDateEnd\":[\"\"],\"transactionStatus\":[\"\"],\"orderByColumn\":[\"createTime\"],\"isAsc\":[\"desc\"]}','{\r\n  \"msg\" : \"4e20d784-4572-456b-9b05-5dc6047179a5_payoutList.xlsx\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 06:45:25'),(189,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','127.0.0.1','内网IP','{\"menuId\":[\"1066\"],\"parentId\":[\"1062\"],\"menuType\":[\"M\"],\"menuName\":[\"Transaction Details\"],\"url\":[\"#\"],\"target\":[\"menuItem\"],\"perms\":[\"\"],\"orderNum\":[\"3\"],\"icon\":[\"fa fa-bars\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 06:47:58'),(190,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','127.0.0.1','内网IP','{\"menuId\":[\"1068\"],\"parentId\":[\"1066\"],\"menuType\":[\"C\"],\"menuName\":[\"Payout details\"],\"url\":[\"/adam/trans-query/payoutListPage\"],\"target\":[\"menuItem\"],\"perms\":[\"adam:trans-query:payoutList\"],\"orderNum\":[\"2\"],\"icon\":[\"#\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 06:48:16'),(191,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','127.0.0.1','内网IP','{\"menuId\":[\"1067\"],\"parentId\":[\"1066\"],\"menuType\":[\"C\"],\"menuName\":[\"Funding details\"],\"url\":[\"/adam/trans-query/rechargeListPage\"],\"target\":[\"menuItem\"],\"perms\":[\"adam:trans-query:rechargeList\"],\"orderNum\":[\"1\"],\"icon\":[\"#\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 06:48:33'),(192,'菜单管理',2,'SysMenuController.editSave()','POST',1,'admin','研发组','/system/menu/edit','127.0.0.1','内网IP','{\"menuId\":[\"1069\"],\"parentId\":[\"1066\"],\"menuType\":[\"C\"],\"menuName\":[\"Conversion details\"],\"url\":[\"/adam/trans-query/conversionListPage\"],\"target\":[\"menuItem\"],\"perms\":[\"adam:trans-query:conversionList\"],\"orderNum\":[\"3\"],\"icon\":[\"#\"],\"visible\":[\"0\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 06:48:52'),(193,'下发订单导出',5,'com.liquidnet.client.admin.web.controller.adam.transaction.TransactionQueryController.payoutListExport()','POST',1,'admin','研发组','/adam/trans-query/payoutListExport','192.168.31.31','内网IP','{\"transactionId\":[\"\"],\"walletNo\":[\"\"],\"currency\":[\"\"],\"transactionAmountBegin\":[\"\"],\"transactionAmountEnd\":[\"\"],\"transactionDateBegin\":[\"\"],\"transactionDateEnd\":[\"\"],\"executionDateBegin\":[\"\"],\"executionDateEnd\":[\"\"],\"transactionStatus\":[\"\"],\"orderByColumn\":[\"createTime\"],\"isAsc\":[\"desc\"]}','{\r\n  \"msg\" : \"e5606c8a-e4ac-458a-9bbe-b0a21884f6bb_payoutList.xlsx\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 07:38:07'),(194,'字典类型',1,'SysDictTypeController.addSave()','POST',1,'admin','研发组','/system/dict/add','192.168.31.31','内网IP','{\"dictName\":[\"下发交易状态\"],\"dictType\":[\"adam_payout_status\"],\"status\":[\"0\"],\"remark\":[\"下发交易状态\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 07:49:31'),(195,'字典类型',1,'SysDictTypeController.addSave()','POST',1,'admin','研发组','/system/dict/add','192.168.31.31','内网IP','{\"dictName\":[\"换汇交易状态\"],\"dictType\":[\"adam_conversion_status\"],\"status\":[\"0\"],\"remark\":[\"换汇交易状态\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 07:50:19'),(196,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.31','内网IP','{\"dictLabel\":[\"Ready to Process\"],\"dictValue\":[\"Ready to Process\"],\"dictType\":[\"adam_payout_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"1\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 07:51:11'),(197,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.31','内网IP','{\"dictLabel\":[\"Awaiting Funds\"],\"dictValue\":[\"Awaiting Funds\"],\"dictType\":[\"adam_payout_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"2\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 07:51:28'),(198,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.31','内网IP','{\"dictLabel\":[\"Failed\"],\"dictValue\":[\"Failed\"],\"dictType\":[\"adam_payout_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"3\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 07:53:32'),(199,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.31','内网IP','{\"dictLabel\":[\"Cancelled\"],\"dictValue\":[\"Cancelled\"],\"dictType\":[\"adam_payout_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"4\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 07:53:46'),(200,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.31','内网IP','{\"dictLabel\":[\"Processing\"],\"dictValue\":[\"Processing\"],\"dictType\":[\"adam_payout_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"5\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 07:53:59'),(201,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.31','内网IP','{\"dictLabel\":[\"Completed\"],\"dictValue\":[\"Completed\"],\"dictType\":[\"adam_payout_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"6\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 07:54:14'),(202,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.31','内网IP','{\"dictCode\":[\"37\"],\"dictLabel\":[\"Ready to Process\"],\"dictValue\":[\"ready_to_process\"],\"dictType\":[\"adam_payout_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"1\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 07:57:07'),(203,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.31','内网IP','{\"dictCode\":[\"38\"],\"dictLabel\":[\"Awaiting Funds\"],\"dictValue\":[\"awaiting_funds\"],\"dictType\":[\"adam_payout_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"2\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 07:57:14'),(204,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.31','内网IP','{\"dictCode\":[\"41\"],\"dictLabel\":[\"Processing\"],\"dictValue\":[\"processing\"],\"dictType\":[\"adam_payout_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"5\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 07:57:22'),(205,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.31','内网IP','{\"dictCode\":[\"40\"],\"dictLabel\":[\"Cancelled\"],\"dictValue\":[\"cancelled\"],\"dictType\":[\"adam_payout_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"4\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 07:57:30'),(206,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.31','内网IP','{\"dictCode\":[\"39\"],\"dictLabel\":[\"Failed\"],\"dictValue\":[\"failed\"],\"dictType\":[\"adam_payout_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"3\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 07:57:37'),(207,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.31','内网IP','{\"dictCode\":[\"42\"],\"dictLabel\":[\"Completed\"],\"dictValue\":[\"completed\"],\"dictType\":[\"adam_payout_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"6\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 07:57:55'),(208,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.31','内网IP','{\"dictLabel\":[\"Ready to Settle\"],\"dictValue\":[\"ready_to_settle\"],\"dictType\":[\"adam_conversion_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"1\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 08:01:42'),(209,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.31','内网IP','{\"dictLabel\":[\"Failed\"],\"dictValue\":[\"failed\"],\"dictType\":[\"adam_conversion_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"2\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 08:02:02'),(210,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.31','内网IP','{\"dictLabel\":[\"Completed\"],\"dictValue\":[\"completed\"],\"dictType\":[\"adam_conversion_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"3\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 08:02:21'),(211,'参数管理',1,'SysConfigController.addSave()','POST',1,'admin','研发组','/system/config/add','192.168.31.31','内网IP','{\"configName\":[\"sss\"],\"configKey\":[\"sss\"],\"configValue\":[\"ssss\"],\"configType\":[\"Y\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 08:32:28'),(212,'参数管理',3,'SysConfigController.remove()','POST',1,'admin','研发组','/system/config/remove','192.168.31.31','内网IP','{\"ids\":[\"8\"]}','null',1,'内置参数【sss】不能删除 ','2020-11-09 08:32:35'),(213,'参数管理',3,'SysConfigController.remove()','POST',1,'admin','研发组','/system/config/remove','192.168.31.31','内网IP','{\"ids\":[\"8\"]}','null',1,'内置参数【sss】不能删除 ','2020-11-09 08:32:40'),(214,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.31','内网IP','{\"dictCode\":[\"32\"],\"dictLabel\":[\"Processing\"],\"dictValue\":[\"processing\"],\"dictType\":[\"adam_recharge_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"3\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 08:41:37'),(215,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.31','内网IP','{\"dictCode\":[\"31\"],\"dictLabel\":[\"Failed\"],\"dictValue\":[\"fail\"],\"dictType\":[\"adam_recharge_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"2\"],\"listClass\":[\"\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 08:41:49'),(216,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.31','内网IP','{\"dictCode\":[\"30\"],\"dictLabel\":[\"Completed\"],\"dictValue\":[\"success\"],\"dictType\":[\"adam_recharge_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"1\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-11-09 08:41:57'),(217,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"6\"],\"dictLabel\":[\"正常\"],\"dictValue\":[\"1\"],\"dictType\":[\"sys_normal_disable\"],\"cssClass\":[\"\"],\"dictSort\":[\"2\"],\"listClass\":[\"primary\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"正常状态\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-11 17:02:33'),(218,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"7\"],\"dictLabel\":[\"停用\"],\"dictValue\":[\"2\"],\"dictType\":[\"sys_normal_disable\"],\"cssClass\":[\"\"],\"dictSort\":[\"3\"],\"listClass\":[\"danger\"],\"isDefault\":[\"N\"],\"remark\":[\"停用状态\"],\"status\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-11 17:02:42'),(219,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.229','内网IP','{\"dictLabel\":[\"INIT\"],\"dictValue\":[\"0\"],\"dictType\":[\"sys_normal_disable\"],\"cssClass\":[\"\"],\"dictSort\":[\"1\"],\"listClass\":[\"\"],\"isDefault\":[\"Y\"],\"status\":[\"1\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-11 17:03:35'),(220,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"46\"],\"dictLabel\":[\"INIT\"],\"dictValue\":[\"0\"],\"dictType\":[\"sys_normal_disable\"],\"cssClass\":[\"\"],\"dictSort\":[\"1\"],\"listClass\":[\"primary\"],\"isDefault\":[\"Y\"],\"status\":[\"1\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-11 17:03:55'),(221,'字典数据',3,'SysDictDataController.remove()','POST',1,'admin','研发组','/system/dict/data/remove','192.168.31.229','内网IP','{\"ids\":[\"46\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-11 17:04:38'),(222,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"6\"],\"dictLabel\":[\"正常\"],\"dictValue\":[\"0\"],\"dictType\":[\"sys_normal_disable\"],\"cssClass\":[\"\"],\"dictSort\":[\"1\"],\"listClass\":[\"primary\"],\"isDefault\":[\"Y\"],\"remark\":[\"正常状态\"],\"status\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-11 17:04:45'),(223,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"7\"],\"dictLabel\":[\"停用\"],\"dictValue\":[\"1\"],\"dictType\":[\"sys_normal_disable\"],\"cssClass\":[\"\"],\"dictSort\":[\"2\"],\"listClass\":[\"danger\"],\"isDefault\":[\"N\"],\"remark\":[\"停用状态\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-11 17:04:52'),(224,'字典类型',1,'SysDictTypeController.addSave()','POST',1,'admin','研发组','/system/dict/add','192.168.31.229','内网IP','{\"dictName\":[\"Basic Currency\"],\"dictType\":[\"sys_currency\"],\"remark\":[\"Sytem base currency\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-11 17:05:54'),(225,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.229','内网IP','{\"dictLabel\":[\"INIT\"],\"dictValue\":[\"0\"],\"dictType\":[\"sys_currency\"],\"cssClass\":[\"\"],\"dictSort\":[\"1\"],\"listClass\":[\"primary\"],\"isDefault\":[\"Y\"],\"remark\":[\"Initial state\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-11 17:06:45'),(226,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.229','内网IP','{\"dictLabel\":[\"INIT\"],\"dictValue\":[\"0\"],\"dictType\":[\"sys_currency\"],\"cssClass\":[\"\"],\"dictSort\":[\"1\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-11 17:07:17'),(227,'字典数据',3,'SysDictDataController.remove()','POST',1,'admin','研发组','/system/dict/data/remove','192.168.31.229','内网IP','{\"ids\":[\"48\"]}','{\n  \"msg\" : \"操作成功\",\n  \"code\" : 0\n}',0,NULL,'2020-12-11 17:15:34'),(228,'字典类型',9,'SysDictTypeController.clearCache()','GET',1,'admin','研发组','/system/dict/clearCache','192.168.31.229','内网IP',NULL,'{\n  \"msg\" : \"操作成功\",\n  \"code\" : 0\n}',0,NULL,'2020-12-11 17:27:00'),(229,'字典类型',9,'SysDictTypeController.clearCache()','GET',1,'admin','研发组','/system/dict/clearCache','192.168.31.229','内网IP',NULL,'{\n  \"msg\" : \"操作成功\",\n  \"code\" : 0\n}',0,NULL,'2020-12-11 17:27:08'),(230,'字典类型',9,'SysDictTypeController.clearCache()','GET',1,'admin','研发组','/system/dict/clearCache','192.168.31.229','内网IP',NULL,'{\n  \"msg\" : \"操作成功\",\n  \"code\" : 0\n}',0,NULL,'2020-12-11 17:27:09'),(231,'字典类型',9,'SysDictTypeController.clearCache()','GET',1,'admin','研发组','/system/dict/clearCache','192.168.31.229','内网IP',NULL,'{\n  \"msg\" : \"操作成功\",\n  \"code\" : 0\n}',0,NULL,'2020-12-11 17:27:10'),(232,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"6\"],\"dictLabel\":[\"正常\"],\"dictValue\":[\"1\"],\"dictType\":[\"sys_normal_disable\"],\"cssClass\":[\"\"],\"dictSort\":[\"2\"],\"listClass\":[\"primary\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"正常状态\"]}','{\n  \"msg\" : \"操作成功\",\n  \"code\" : 0\n}',0,NULL,'2020-12-11 18:45:40'),(233,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"7\"],\"dictLabel\":[\"停用\"],\"dictValue\":[\"2\"],\"dictType\":[\"sys_normal_disable\"],\"cssClass\":[\"\"],\"dictSort\":[\"3\"],\"listClass\":[\"danger\"],\"isDefault\":[\"N\"],\"remark\":[\"停用状态\"],\"status\":[\"\"]}','{\n  \"msg\" : \"操作成功\",\n  \"code\" : 0\n}',0,NULL,'2020-12-11 18:45:51'),(234,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"7\"],\"dictLabel\":[\"停用\"],\"dictValue\":[\"2\"],\"dictType\":[\"sys_normal_disable\"],\"cssClass\":[\"\"],\"dictSort\":[\"3\"],\"listClass\":[\"danger\"],\"isDefault\":[\"N\"],\"status\":[\"1\"],\"remark\":[\"停用状态\"]}','{\n  \"msg\" : \"操作成功\",\n  \"code\" : 0\n}',0,NULL,'2020-12-11 18:46:28'),(235,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"6\"],\"dictLabel\":[\"正常\"],\"dictValue\":[\"1\"],\"dictType\":[\"sys_normal_disable\"],\"cssClass\":[\"\"],\"dictSort\":[\"2\"],\"listClass\":[\"primary\"],\"isDefault\":[\"Y\"],\"remark\":[\"正常状态\"],\"status\":[\"\"]}','{\n  \"msg\" : \"操作成功\",\n  \"code\" : 0\n}',0,NULL,'2020-12-11 18:46:59'),(236,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"6\"],\"dictLabel\":[\"正常\"],\"dictValue\":[\"0\"],\"dictType\":[\"sys_normal_disable\"],\"cssClass\":[\"\"],\"dictSort\":[\"2\"],\"listClass\":[\"primary\"],\"isDefault\":[\"Y\"],\"status\":[\"1\"],\"remark\":[\"正常状态\"]}','{\n  \"msg\" : \"操作成功\",\n  \"code\" : 0\n}',0,NULL,'2020-12-11 18:49:00'),(237,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"7\"],\"dictLabel\":[\"停用\"],\"dictValue\":[\"1\"],\"dictType\":[\"sys_normal_disable\"],\"cssClass\":[\"\"],\"dictSort\":[\"2\"],\"listClass\":[\"danger\"],\"isDefault\":[\"N\"],\"remark\":[\"停用状态\"]}','{\n  \"msg\" : \"操作成功\",\n  \"code\" : 0\n}',0,NULL,'2020-12-11 18:49:10'),(238,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"6\"],\"dictLabel\":[\"正常\"],\"dictValue\":[\"0\"],\"dictType\":[\"sys_normal_disable\"],\"cssClass\":[\"\"],\"dictSort\":[\"1\"],\"listClass\":[\"primary\"],\"isDefault\":[\"Y\"],\"remark\":[\"正常状态\"]}','{\n  \"msg\" : \"操作成功\",\n  \"code\" : 0\n}',0,NULL,'2020-12-11 18:49:18'),(239,'字典类型',1,'SysDictTypeController.addSave()','POST',1,'admin','研发组','/system/dict/add','192.168.31.229','内网IP','{\"dictName\":[\"Wallet Status\"],\"dictType\":[\"fin_wallet_status\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 14:15:50'),(240,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.229','内网IP','{\"dictLabel\":[\"fin_wallet_status\"],\"dictValue\":[\"0\"],\"dictType\":[\"fin_wallet_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"1\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"INIT\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 14:16:50'),(241,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"1112\"],\"dictLabel\":[\"INIT\"],\"dictValue\":[\"0\"],\"dictType\":[\"fin_wallet_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"1\"],\"listClass\":[\"primary\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 14:17:45'),(242,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.229','内网IP','{\"dictLabel\":[\"NORMAL\"],\"dictValue\":[\"1\"],\"dictType\":[\"fin_wallet_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"2\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 14:18:15'),(243,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"1112\"],\"dictLabel\":[\"INIT\"],\"dictValue\":[\"0\"],\"dictType\":[\"fin_wallet_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"1\"],\"listClass\":[\"default\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 14:18:26'),(244,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"1113\"],\"dictLabel\":[\"NORMAL\"],\"dictValue\":[\"1\"],\"dictType\":[\"fin_wallet_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"2\"],\"listClass\":[\"primary\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 14:18:33'),(245,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"1112\"],\"dictLabel\":[\"INIT\"],\"dictValue\":[\"0\"],\"dictType\":[\"fin_wallet_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"1\"],\"listClass\":[\"info\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 14:19:02'),(246,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"1112\"],\"dictLabel\":[\"INIT\"],\"dictValue\":[\"0\"],\"dictType\":[\"fin_wallet_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"1\"],\"listClass\":[\"warning\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 14:19:13'),(247,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.229','内网IP','{\"dictLabel\":[\"DISABLE\"],\"dictValue\":[\"2\"],\"dictType\":[\"fin_wallet_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"3\"],\"listClass\":[\"info\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 14:19:36'),(248,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"1114\"],\"dictLabel\":[\"DISABLE\"],\"dictValue\":[\"2\"],\"dictType\":[\"fin_wallet_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"3\"],\"listClass\":[\"danger\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 14:19:49'),(249,'字典类型',1,'SysDictTypeController.addSave()','POST',1,'admin','研发组','/system/dict/add','192.168.31.229','内网IP','{\"dictName\":[\"Wallet Pay Status\"],\"dictType\":[\"fin_wallet_pay_status\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 14:21:54'),(250,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.229','内网IP','{\"dictLabel\":[\"NORMAL\"],\"dictValue\":[\"1\"],\"dictType\":[\"fin_wallet_pay_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"1\"],\"listClass\":[\"primary\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 14:35:04'),(251,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.229','内网IP','{\"dictLabel\":[\"NO_IN\"],\"dictValue\":[\"2\"],\"dictType\":[\"fin_wallet_pay_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"2\"],\"listClass\":[\"primary\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 14:35:23'),(252,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.229','内网IP','{\"dictLabel\":[\"NO_OUT\"],\"dictValue\":[\"3\"],\"dictType\":[\"fin_wallet_pay_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"3\"],\"listClass\":[\"primary\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 14:35:38'),(253,'字典数据',1,'SysDictDataController.addSave()','POST',1,'admin','研发组','/system/dict/data/add','192.168.31.229','内网IP','{\"dictLabel\":[\"ARCHIVE\"],\"dictValue\":[\"4\"],\"dictType\":[\"fin_wallet_pay_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"4\"],\"listClass\":[\"warning\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 14:35:55'),(254,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"1118\"],\"dictLabel\":[\"ARCHIVE\"],\"dictValue\":[\"4\"],\"dictType\":[\"fin_wallet_pay_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"4\"],\"listClass\":[\"danger\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 14:36:04'),(255,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"1112\"],\"dictLabel\":[\"Init\"],\"dictValue\":[\"0\"],\"dictType\":[\"fin_wallet_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"1\"],\"listClass\":[\"warning\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 16:07:18'),(256,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"1113\"],\"dictLabel\":[\"Normal\"],\"dictValue\":[\"1\"],\"dictType\":[\"fin_wallet_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"2\"],\"listClass\":[\"primary\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 16:07:26'),(257,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"1114\"],\"dictLabel\":[\"Disable\"],\"dictValue\":[\"2\"],\"dictType\":[\"fin_wallet_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"3\"],\"listClass\":[\"danger\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 16:07:38'),(258,'字典数据',3,'SysDictDataController.remove()','POST',1,'admin','研发组','/system/dict/data/remove','192.168.31.229','内网IP','{\"ids\":[\"1112\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 16:08:09'),(259,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"1115\"],\"dictLabel\":[\"Normal\"],\"dictValue\":[\"1\"],\"dictType\":[\"fin_wallet_pay_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"1\"],\"listClass\":[\"primary\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 16:08:25'),(260,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"1116\"],\"dictLabel\":[\"No_In\"],\"dictValue\":[\"2\"],\"dictType\":[\"fin_wallet_pay_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"2\"],\"listClass\":[\"primary\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 16:08:39'),(261,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"1117\"],\"dictLabel\":[\"No_Out\"],\"dictValue\":[\"3\"],\"dictType\":[\"fin_wallet_pay_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"3\"],\"listClass\":[\"primary\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 16:08:48'),(262,'字典数据',2,'SysDictDataController.editSave()','POST',1,'admin','研发组','/system/dict/data/edit','192.168.31.229','内网IP','{\"dictCode\":[\"1118\"],\"dictLabel\":[\"Archive\"],\"dictValue\":[\"4\"],\"dictType\":[\"fin_wallet_pay_status\"],\"cssClass\":[\"\"],\"dictSort\":[\"4\"],\"listClass\":[\"danger\"],\"isDefault\":[\"Y\"],\"status\":[\"0\"],\"remark\":[\"\"]}','{\r\n  \"msg\" : \"操作成功\",\r\n  \"code\" : 0\r\n}',0,NULL,'2020-12-14 16:08:55');
/*!40000 ALTER TABLE `sys_oper_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_post`
--

DROP TABLE IF EXISTS `sys_post`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_post` (
  `post_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '岗位ID',
  `post_code` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '岗位编码',
  `post_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '岗位名称',
  `post_sort` int(4) NOT NULL COMMENT '显示顺序',
  `status` char(1) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`post_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='岗位信息表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_post`
--

LOCK TABLES `sys_post` WRITE;
/*!40000 ALTER TABLE `sys_post` DISABLE KEYS */;
INSERT INTO `sys_post` VALUES (1,'ceo','董事长',1,'1','admin','2018-03-16 11:33:00','admin','2020-09-25 18:52:59',''),(2,'se','项目经理',2,'1','admin','2018-03-16 11:33:00','admin','2020-09-25 18:53:04',''),(4,'user','普通员工',4,'0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','');
/*!40000 ALTER TABLE `sys_post` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_role`
--

DROP TABLE IF EXISTS `sys_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_role` (
  `role_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `role_name` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '角色名称',
  `role_key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '角色权限字符串',
  `role_sort` int(4) NOT NULL COMMENT '显示顺序',
  `data_scope` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '1' COMMENT '数据范围（1：全部数据权限 2：自定数据权限 3：本部门数据权限 4：本部门及以下数据权限）',
  `status` char(1) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '角色状态（0正常 1停用）',
  `del_flag` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `create_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='角色信息表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_role`
--

LOCK TABLES `sys_role` WRITE;
/*!40000 ALTER TABLE `sys_role` DISABLE KEYS */;
INSERT INTO `sys_role` VALUES (1,'超级管理员','admin',1,'1','0','0','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','超级管理员'),(2,'普通角色','common',2,'2','0','0','admin','2018-03-16 11:33:00','admin','2020-09-25 18:31:32','普通角色'),(100,'管理员','sub_admin',1,'1','0','0','admin','2020-09-25 18:48:41','',NULL,NULL);
/*!40000 ALTER TABLE `sys_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_role_dept`
--

DROP TABLE IF EXISTS `sys_role_dept`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_role_dept` (
  `role_id` bigint(20) NOT NULL COMMENT '角色ID',
  `dept_id` bigint(20) NOT NULL COMMENT '部门ID',
  PRIMARY KEY (`role_id`,`dept_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='角色和部门关联表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_role_dept`
--

LOCK TABLES `sys_role_dept` WRITE;
/*!40000 ALTER TABLE `sys_role_dept` DISABLE KEYS */;
INSERT INTO `sys_role_dept` VALUES (2,100),(2,101),(2,105);
/*!40000 ALTER TABLE `sys_role_dept` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_role_menu`
--

DROP TABLE IF EXISTS `sys_role_menu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_role_menu` (
  `role_id` bigint(20) NOT NULL COMMENT '角色ID',
  `menu_id` bigint(20) NOT NULL COMMENT '菜单ID',
  PRIMARY KEY (`role_id`,`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='角色和菜单关联表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_role_menu`
--

LOCK TABLES `sys_role_menu` WRITE;
/*!40000 ALTER TABLE `sys_role_menu` DISABLE KEYS */;
INSERT INTO `sys_role_menu` VALUES (2,1),(2,107),(2,108),(2,500),(2,501),(2,1035),(2,1036),(2,1037),(2,1038),(2,1039),(2,1040),(2,1041),(2,1042),(2,1043),(2,1044),(2,1045),(2,1046);
/*!40000 ALTER TABLE `sys_role_menu` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_user`
--

DROP TABLE IF EXISTS `sys_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_user` (
  `user_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '用户ID',
  `dept_id` bigint(20) DEFAULT NULL COMMENT '部门ID',
  `login_name` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '登录账号',
  `user_name` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '用户昵称',
  `user_type` varchar(2) COLLATE utf8mb4_unicode_ci DEFAULT '00' COMMENT '用户类型（00系统用户 01注册用户）',
  `email` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '用户邮箱',
  `phonenumber` varchar(11) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '手机号码',
  `sex` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '0' COMMENT '用户性别（0男 1女 2未知）',
  `avatar` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '头像路径',
  `password` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '密码',
  `salt` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '盐加密',
  `status` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '0' COMMENT '帐号状态（0正常 1停用）',
  `del_flag` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `login_ip` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '最后登录IP',
  `login_date` datetime DEFAULT NULL COMMENT '最后登录时间',
  `create_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户信息表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_user`
--

LOCK TABLES `sys_user` WRITE;
/*!40000 ALTER TABLE `sys_user` DISABLE KEYS */;
INSERT INTO `sys_user` VALUES (1,103,'admin','admin','00','ry@163.com','15888888888','0','','29c67a30398638269fe600f73a054934','111111','0','0','192.168.31.229','2020-12-14 16:28:45','admin','2018-03-16 11:33:00','ry','2020-12-14 16:28:44','管理员'),(2,105,'ry','正在映画','00','ry@qq.com','15666666666','1','','8e6d98b90472783cc73c17047ddccf36','222222','0','2','127.0.0.1','2018-03-16 11:33:00','admin','2018-03-16 11:33:00','ry','2018-03-16 11:33:00','测试员'),(100,103,'anjiabin','AnJiabin','00','jiabin.an@lightnet.io','13811114082','0','','aa1dea85bba261861ec17d127ea0465a','69ab6f','0','0','127.0.0.1','2020-09-25 18:34:43','admin','2020-09-25 18:28:31','admin','2020-09-25 18:34:43',''),(101,103,'zhangguobing','zhangguobing','00','zhangguobing@lightnet.com','13811111111','0','','fb28f3b036e993cccf293315124ea374','4b8494','0','0','127.0.0.1','2020-09-27 10:57:12','admin','2020-09-27 02:56:50','','2020-09-27 02:57:13',NULL);
/*!40000 ALTER TABLE `sys_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_user_online`
--

DROP TABLE IF EXISTS `sys_user_online`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_user_online` (
  `sessionId` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '用户会话id',
  `login_name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '登录账号',
  `dept_name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '部门名称',
  `ipaddr` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '登录IP地址',
  `login_location` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '登录地点',
  `browser` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '浏览器类型',
  `os` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '操作系统',
  `status` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '在线状态on_line在线off_line离线',
  `start_timestamp` datetime DEFAULT NULL COMMENT 'session创建时间',
  `last_access_time` datetime DEFAULT NULL COMMENT 'session最后访问时间',
  `expire_time` int(5) DEFAULT '0' COMMENT '超时时间，单位为分钟',
  PRIMARY KEY (`sessionId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='在线用户记录';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_user_online`
--

LOCK TABLES `sys_user_online` WRITE;
/*!40000 ALTER TABLE `sys_user_online` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_user_online` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_user_post`
--

DROP TABLE IF EXISTS `sys_user_post`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_user_post` (
  `user_id` bigint(20) NOT NULL COMMENT '用户ID',
  `post_id` bigint(20) NOT NULL COMMENT '岗位ID',
  PRIMARY KEY (`user_id`,`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户与岗位关联表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_user_post`
--

LOCK TABLES `sys_user_post` WRITE;
/*!40000 ALTER TABLE `sys_user_post` DISABLE KEYS */;
INSERT INTO `sys_user_post` VALUES (1,1),(2,2),(100,4);
/*!40000 ALTER TABLE `sys_user_post` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_user_role`
--

DROP TABLE IF EXISTS `sys_user_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sys_user_role` (
  `user_id` bigint(20) NOT NULL COMMENT '用户ID',
  `role_id` bigint(20) NOT NULL COMMENT '角色ID',
  PRIMARY KEY (`user_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户和角色关联表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_user_role`
--

LOCK TABLES `sys_user_role` WRITE;
/*!40000 ALTER TABLE `sys_user_role` DISABLE KEYS */;
INSERT INTO `sys_user_role` VALUES (1,1),(100,2),(101,2);
/*!40000 ALTER TABLE `sys_user_role` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2020-12-17  8:38:22
