package com.liquidnet.service.account.wallet.dto;

import com.liquidnet.service.account.wallet.dto.base.WalletCallResult;
import com.liquidnet.service.account.wallet.vo.WalletDashboardInfoVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.util.Map;

/**
 * WalletDashboardResult.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/11/9
 */
@ApiModel(value = "WalletDashboardResult", description = "Result of wallet recent transaction")
public class WalletDashboardResult extends WalletCallResult<WalletDashboardParam> {
    private static final long serialVersionUID = 4947141251103097076L;

    @ApiModelProperty(position = 11, value = "Wallet dashboard info list")
    private Map<String, List<WalletDashboardInfoVo>> voMap;

    public WalletDashboardResult() {
    }

    public WalletDashboardResult(Map<String, List<WalletDashboardInfoVo>> voMap) {
        this.voMap = voMap;
    }

    public WalletDashboardResult(String code, String message) {
        super(code, message);
    }

    public Map<String, List<WalletDashboardInfoVo>> getVoMap() {
        return voMap;
    }

}
