package com.liquidnet.service.kylin.controller.partner;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dao.ChildDetailsDao;
import com.liquidnet.service.kylin.dao.ChildListDao;
import com.liquidnet.service.kylin.dto.vo.KylinBuyNoticeVo;
import com.liquidnet.service.kylin.service.impl.partner.KylinBuyNoticePartnerServiceImpl;
import com.liquidnet.service.kylin.service.impl.partner.KylinCheckUserPartnerServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 验票用户表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-21
 */
@Api(tags = "第三方-验票账号")
@RestController
@RequestMapping("partner/checkUser")
public class KylinCheckUserPartnerController {

    @Autowired
    private KylinCheckUserPartnerServiceImpl checkUserPartnerService;

    @PostMapping(value = "")
    @ApiOperation(value = "创建验票账号", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> create(@RequestParam("merchantId") String merchantId,
                                      @RequestParam("name") String name,
                                      @RequestParam("pwd") String pwd,
                                      @RequestParam("mobile") String mobile) {
        return checkUserPartnerService.create(merchantId, name, pwd, mobile);
    }

    @DeleteMapping(value = "")
    @ApiOperation(value = "删除验票账号", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> del(@RequestParam("merchantId") String merchantId,
                                   @RequestParam("checkUserId") String checkUserId) {
        return checkUserPartnerService.del(merchantId, checkUserId);
    }

    @PutMapping(value = "")
    @ApiOperation(value = "修改验票账号", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> change(@RequestParam("merchantId") String merchantId,
                                      @RequestParam("checkUserId") String checkUserId,
                                      @RequestParam("name") String name,
                                      @RequestParam(value = "pwd",required = false) String pwd,
                                      @RequestParam("mobile") String mobile) {
        return checkUserPartnerService.change(merchantId, checkUserId, name, pwd, mobile);
    }

    @GetMapping(value = "list")
    @ApiOperation(value = "验票账号列表", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<ChildListDao>> getCheckUserList(@RequestParam("merchantId") String merchantId,
                                                                    @RequestParam(value = "mobile" , required = false) String mobile,
                                                                    @RequestParam("page") int page,
                                                                    @RequestParam("size") int size) {
        PageInfo<ChildListDao> result = checkUserPartnerService.getCheckUserList(merchantId,mobile,page,size);
        if (null == result) {
            return ResponseDto.failure("查询失败");
        } else {
            return ResponseDto.success(result);
        }
    }

    @GetMapping(value = "details")
    @ApiOperation(value = "验票账号详情", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<ChildDetailsDao> details(@RequestParam("merchantId") String merchantId,
                                                @RequestParam("checkUserId") String checkUserId) {
        ResponseDto<ChildDetailsDao> result = checkUserPartnerService.details(merchantId,checkUserId);
        if (null == result) {
            return ResponseDto.failure("查询失败");
        } else {
            return result;
        }
    }

}
