package com.liquidnet.service.sweet.dto.vo;

import com.liquidnet.service.sweet.entity.SweetIntegralActivity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class IntegralActivityVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -303399210433737206L;

    @ApiModelProperty(value = "活动id")
    private String integralActivityId;

    @ApiModelProperty(value = "活动名称")
    private String activityTitle;

    @ApiModelProperty(value = "活动图片")
    private String activityImg;

    @ApiModelProperty(value = "活动类型 1转盘")
    private Integer activityType;

    @ApiModelProperty(value = "活动玩一次所需积分")
    private Integer activityNum;

    @ApiModelProperty(value = "预估玩此活动的总人数")
    private Integer estimatedNum;

    @ApiModelProperty(value = "活动时间类型 1长期 2开始结束时间")
    private Integer timeType;

    @ApiModelProperty(value = "如果活动有时间限制 开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "如果活动有时间限制 结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "快递费用类型 1包邮 2到付")
    private Integer expressFeeType;

    @ApiModelProperty(value = "活动规则")
    private String activityRules;

    @ApiModelProperty(value = "概率公示")
    private String probabilityPublicity;

    @ApiModelProperty(value = "是否上线 1未上线 2已上线")
    private Integer isOnline;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createdAt;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updatedAt;

    @ApiModelProperty(value = "奖品列表")
    private List<IntegralActivityPrizeVo> prizeList;

    @ApiModelProperty(value = "奖品列表 积分、券")
    private List<IntegralActivityPrizeVo> prizeList1;

    @ApiModelProperty(value = "奖品列表 实物、会员")
    private List<IntegralActivityPrizeVo> prizeList2;

    private static final IntegralActivityVo obj = new IntegralActivityVo();
    public static IntegralActivityVo getNew() {
        try {
            return (IntegralActivityVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new IntegralActivityVo();
        }
    }

    public IntegralActivityVo copy(SweetIntegralActivity source) {
        if (null == this) return this;
        this.setIntegralActivityId(source.getIntegralActivityId());
        this.setActivityTitle(source.getActivityTitle());
        this.setActivityImg(source.getActivityImg());
        this.setActivityType(source.getActivityType());
        this.setActivityNum(source.getActivityNum());
        this.setEstimatedNum(source.getEstimatedNum());
        this.setTimeType(source.getTimeType());
        this.setStartTime(source.getStartTime());
        this.setEndTime(source.getEndTime());
        this.setExpressFeeType(source.getExpressFeeType());
        this.setActivityRules(source.getActivityRules());
        this.setProbabilityPublicity(source.getProbabilityPublicity());
        this.setIsOnline(source.getIsOnline());
        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());
        return this;
    }

}
