package com.liquidnet.service.platform.controller.ticketSystem;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.platform.param.ticketSystem.*;
import com.liquidnet.service.platform.service.ticketSystem.ITicketSystemService;
import com.liquidnet.service.platform.vo.ticketSystem.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.List;

@Api(tags = "票务平台")
@RestController
@RequestMapping("st")
public class TicketSystemController {

    @Autowired
    ITicketSystemService ticketSystemService;

    @GetMapping("type/list")
    @ApiOperation("查询标准演出类型")
    public ResponseDto<List<STPTListVo>> getPerformanceTypeList() {
        String accessToken = ticketSystemService.getAccessToken();
        List<STPTListVo> vo = ticketSystemService.getPerformanceTypeList(accessToken);
        return ResponseDto.success(vo);
    }

    @GetMapping("field/list")
    @ApiOperation("查询标准演出场所")
    public ResponseDto<List<STFieldListVo>> getFieldList(STFieldListParam fieldListParam) {
        String accessToken = ticketSystemService.getAccessToken();
        List<STFieldListVo> vo = ticketSystemService.getFieldList(accessToken, fieldListParam);
        return ResponseDto.success(vo);
    }

    @PostMapping("field/insert")
    @ApiOperation("新增演出场厅")
    public ResponseDto<STFieldChangeVo> insertField(STInsertFieldParam insertFieldParam) {
        String accessToken = ticketSystemService.getAccessToken();
        STFieldChangeVo vo = ticketSystemService.insertField(accessToken, insertFieldParam);
        return ResponseDto.success(vo);
    }


    @PostMapping("performance/insert")
    @ApiOperation("上报演出场次")
    public ResponseDto<String> insertPerformance(STInsertPerformanceParam insertPerformanceParam) {
        String accessToken = ticketSystemService.getAccessToken();
        String vo = ticketSystemService.insertPerformance(accessToken, insertPerformanceParam);
        return ResponseDto.success(vo);
    }

    @PostMapping("performance/update")
    @ApiOperation("更新上报的演出项目数据")
    public ResponseDto<Boolean> updatePerformance(STUpdatePerformanceParam updatePerformanceParam) {
        String accessToken = ticketSystemService.getAccessToken();
        boolean vo = ticketSystemService.updatePerformance(accessToken, updatePerformanceParam);
        return ResponseDto.success(vo);
    }

    @PostMapping("times/update")
    @ApiOperation("更新上报的场次数据")
    public ResponseDto<Boolean> updateTimes(STUpdateTimesParam updateTimesParam) {
        String accessToken = ticketSystemService.getAccessToken();
        boolean vo = ticketSystemService.updateTimes(accessToken, updateTimesParam);
        return ResponseDto.success(vo);
    }

    @PostMapping("ticketPrice/insert")
    @ApiOperation("上报票价信息")
    public ResponseDto<Boolean> insertTicketPrice(STInsertTicketPriceParam insertTicketPriceParam) {
        String accessToken = ticketSystemService.getAccessToken();
        boolean vo = ticketSystemService.insertTicketPrice(accessToken, insertTicketPriceParam);
        return ResponseDto.success(vo);
    }

    @PostMapping("ticketPrice/del")
    @ApiOperation("新增演出场厅")
    public ResponseDto<Boolean> delTicketPrice(STDelTicketPriceParam delTicketPriceParam) {
        String accessToken = ticketSystemService.getAccessToken();
        boolean vo = ticketSystemService.delTicketPrice(accessToken, delTicketPriceParam);
        return ResponseDto.success(vo);
    }

    @PostMapping("ticket/insert")
    @ApiOperation("上报票信息")
    public ResponseDto<Boolean> insertTicket(STInsertTicketParam insertTicketParam) {
        String accessToken = ticketSystemService.getAccessToken();
        boolean vo = ticketSystemService.insertTicket(accessToken, insertTicketParam);
        return ResponseDto.success(vo);
    }

    @PostMapping("ticket/del")
    @ApiOperation("删除票信息")
    public ResponseDto<Boolean> delTicket(STDelTicketParam delTicketParam) {
        String accessToken = ticketSystemService.getAccessToken();
        boolean vo = ticketSystemService.delTicket(accessToken, delTicketParam);
        return ResponseDto.success(vo);
    }


    @PostMapping("order/insert")
    @ApiOperation("上报订单信息")
    public ResponseDto<Boolean> insertOrder(STInsertOrderParam insertOrderParam) {
        String accessToken = ticketSystemService.getAccessToken();
        boolean vo = ticketSystemService.insertOrder(accessToken, insertOrderParam);
        return ResponseDto.success(vo);
    }

    @PostMapping("order/refund")
    @ApiOperation("上报退票信息")
    public ResponseDto<Boolean> refundOrder(STRefundOrderParam refundOrderParam) {
        String accessToken = ticketSystemService.getAccessToken();
        Boolean vo = ticketSystemService.refundOrder(accessToken, refundOrderParam);
        return ResponseDto.success(vo);
    }

    @PostMapping("check/insert")
    @ApiOperation("上报检票数据")
    public ResponseDto<Boolean> insertCheck(List<CheckVo> ticketList) {
        String accessToken = ticketSystemService.getAccessToken();
        boolean vo = ticketSystemService.insertCheck(accessToken, ticketList);
        return ResponseDto.success(vo);
    }

}
