package com.liquidnet.service.platform.vo.ticketSystem;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel
public class STPTListVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 4073256621782131607L;
    @ApiModelProperty(value = "演出类型id")
    private Integer typeId;
    @ApiModelProperty(value = "演出类型名称]")
    private String typeName;
    @ApiModelProperty(value = "演出类型父id[10，一级类型父id为空]")
    private Integer parentTypeId;
    @ApiModelProperty(value = "层级[1：一级类型，2：二级类型]")
    private Integer level;
    @ApiModelProperty(value = "备注")
    private Integer remark;
    @ApiModelProperty(value = "备注")
    private STPTListVo children;

    private static final STPTListVo obj = new STPTListVo();

    public static STPTListVo getNew() {
        try {
            return (STPTListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new STPTListVo();
    }

}
