package com.liquidnet.service.dragon.constant;

/**
 *
 */
public class DragonConstant {

    public static final String REFUND_TYPE_APP_ALIPAY="APPALIPAY";//,"App内支付宝支付"),
    public static final String REFUND_TYPE_APP_WEPAY="APPWEPAY";//,"App内微信支付"),
    public static final String REFUND_TYPE_APP_IAP="APPIAP";//,"App内IAP(In-App Purchase)支付，iOS虚拟道具支付"),
    public static final String REFUND_TYPE_WAP_ALIPAY="WAPALIPAY";//,"手机网页内支付宝支付"),
    public static final String REFUND_TYPE_WAP_WEPAY="WAPWEPAY";//,"手机网页调起微信支付"),
    public static final String REFUND_TYPE_WEB_ALIPAY="WEBALIPAY";//,"电脑网页内支付宝即时到账支付"),
    public static final String REFUND_TYPE_WEB_WEPAY="WEBWEPAY";//,"电脑网页内微信二维码支付，用户打开微信扫码支付"),
    public static final String REFUND_TYPE_JS_WEPAY="JSWEPAY";//,"微信内网页、微信公众号"),
    public static final String REFUND_TYPE_APPLET_WEPAY="APPLETWEPAY";//,"微信小程序");

    public enum payChannelEnum{
        ALIPAY("alipay","支付宝"),
        WEPAY ("wePay","微信"),
        CLOUDPAY("cloudPay","云闪付");
        private String code;
        private String message;
        payChannelEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }
    }
    /**
     * 支付状态
     */
    public enum payStatusEnum{
        STATUS_UNPAID("0","未支付，或支付中"),
        STATUS_PAID("1","已支付"),
        STATUS_SUCCESS("2","已支付，通知成功，交易结束"),
        STATUS_FAIL("3","已支付，通知失败，交易结束"),
        STATUS_EXPIRE("4","已支付，通知超时，交易结束");

        private String code;
        private String message;
        payStatusEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }
    }

    /**
     * 退款状态
     */
    public enum refundStatusEnum{
        STATUS_UNFILLED("0","未处理"),
        STATUS_REFUNDED("1","退款成功"),
        STATUS_SUCCESS("2","退款成功，通知成功，交易结束"),
        STATUS_FAIL("3","退款成功，通知失败，交易结束"),
        STATUS_EXPIRE("4","退款成功，通知超时，交易结束"),
        STATUS_REFUNDING("5","正在退款"),
        STATUS_ERROR("6","退款失败"),
        STATUS_ERROR_SUCCESS("7","退款失败，通知成功，交易结束"),
        STATUS_ERROR_FAIL("8","退款失败，通知失败，交易结束"),
        STATUS_ERROR_EXPIRE("9","退款失败，通知超时，交易结束");

        private String code;
        private String message;
        refundStatusEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return code;
        }
    }

    /**
     * 支付业务类型
     */
    public enum bussinessTypeEnum{
        TYPE_TICKET("TICKET","票务购买（实物购买）"),
        TYPE_PRODUCT("PRODUCT","商品购买（实物购买）"),
        TYPE_COST("COST","活动资费（活动成本费、活动报名费）"),
        TYPE_MBEANS("MBEANS","点豆充值（虚拟道具）"),
        TYPE_LIVE("LIVE","直播付费（数字资产）"),
        TYPE_VIDEO("VIDEO","点播付费（数字资产）"),
        TYPE_VIP("VIP","会员购买（数字+实物资产）"),
        TYPE_CLUB("CLUB","会员购买（数字+实物资产）"),
        TYPE_STRAWBERRY("STRAWBERRY","现场购买 (实物资产)");

        private String code;
        private String message;
        bussinessTypeEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }
    }

    /**
     * 支付类型
     */
    public enum payTypeEnum{
        PAYMENT_TYPE_APP_ALIPAY("APPALIPAY","App内支付宝支付"),
        PAYMENT_TYPE_APP_WEPAY("APPWEPAY","App内微信支付"),
        PAYMENT_TYPE_APP_IAP("APPIAP","App内IAP(In-App Purchase)支付，iOS虚拟道具支付"),
        PAYMENT_TYPE_WAP_ALIPAY("WAPALIPAY","手机网页内支付宝支付"),
        PAYMENT_TYPE_WAP_WEPAY("WAPWEPAY","手机网页调起微信支付"),
        PAYMENT_TYPE_WEB_ALIPAY("WEBALIPAY","电脑网页内支付宝即时到账支付"),
        PAYMENT_TYPE_WEB_WEPAY("WEBWEPAY","电脑网页内微信二维码支付，用户打开微信扫码支付"),
        PAYMENT_TYPE_JS_WEPAY("JSWEPAY","微信内网页、微信公众号"),
        PAYMENT_TYPE_APPLET_WEPAY("APPLETWEPAY","微信小程序");

        private String code;
        private String message;
        payTypeEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }
    }

    /**
     * 退款类型
     */
    public enum refundTypeEnum{
        REFUND_TYPE_APP_ALIPAY("APPALIPAY","App内支付宝支付"),
        REFUND_TYPE_APP_WEPAY("APPWEPAY","App内微信支付"),
        REFUND_TYPE_APP_IAP("APPIAP","App内IAP(In-App Purchase)支付，iOS虚拟道具支付"),
        REFUND_TYPE_WAP_ALIPAY("WAPALIPAY","手机网页内支付宝支付"),
        REFUND_TYPE_WAP_WEPAY("WAPWEPAY","手机网页调起微信支付"),
        REFUND_TYPE_WEB_ALIPAY("WEBALIPAY","电脑网页内支付宝即时到账支付"),
        REFUND_TYPE_WEB_WEPAY("WEBWEPAY","电脑网页内微信二维码支付，用户打开微信扫码支付"),
        REFUND_TYPE_JS_WEPAY("JSWEPAY","微信内网页、微信公众号"),
        REFUND_TYPE_APPLET_WEPAY("APPLETWEPAY","微信小程序");

        private String code;
        private String message;
        refundTypeEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return code;
        }
    }

    /**
     * MYSQL_REDIS_QUEUE
     */
    public enum mysqlRedisQueueEnum{
        DRAGON_PAY_KEY("dragon-pay","同步数据-支付"),
        DRAGON_REFUND_KEY ("dragon-refund","同步数据-退款"),
        DRAGON_PAY_GROUP("dragon-pay-group","同步数据-支付-组"),
        DRAGON_REFUND_GROUP ("dragon-refund-group","同步数据-退款-组");
        private String code;
        private String message;
        mysqlRedisQueueEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return code;
        }
    }

    /**
     * CHANNEL_REDIS_QUEUE
     */
    public enum channelRedisQueueEnum{
        WECHAT_PAY_KEY("wechat-pay","微信-支付-回调"),
        WECHAT_REFUND_KEY("wechat-pay","微信-退款-回调"),
        ALIPAY_PAY_KEY("alipay-pay","支付宝-支付-回调"),
        ALIPAY_REFUND_KEY ("alipay-refund","支付宝-退款-回调"),
        WECHAT_PAY_GROUP("wechat-pay-group","微信-支付-回调-组"),
        WECHAT_REFUND_GROUP("wechat-pay-group","微信-退款-回调-组"),
        ALIPAY_PAY_GROUP("alipay-pay-group","支付宝-支付-回调-组"),
        ALIPAY_REFUND_GROUP ("alipay-refund-group","支付宝-退款-回调-组");
        private String code;
        private String message;
        channelRedisQueueEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }
    }

    /**
     * CHANNEL_REFUND_URL
     */
    public enum channelRefundUrlEnum{
        JSAPI_REFUND_URL("https://api.mch.weixin.qq.com/v3/refund/domestic/refunds","JSAPI-退款-接口"),
        APP_REFUND_URL("https://api.mch.weixin.qq.com/v3/refund/domestic/refunds","APP-退款-接口"),
        H5_REFUND_URL("https://api.mch.weixin.qq.com/v3/refund/domestic/refunds","H5-退款-接口"),
        NATIVE_REFUND_URL ("https://api.mch.weixin.qq.com/v3/refund/domestic/refunds","NATIVE-退款-接口"),
        MCH_REFUND_URL("https://api.mch.weixin.qq.com/v3/refund/domestic/refunds","小程序-退款-接口");
        private String code;
        private String message;
        channelRefundUrlEnum(String code, String message) {
            this.code = code;
            this.message = message;
        }
    }
}
