use dev_ln_scene;
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_service_support;
create table goblin_service_support
(
    mid        bigint auto_increment primary key,
    ssid       varchar(30)  not null comment '服务支持id',
    name       varchar(50)  not null comment '服务支持的名称',
    `desc`     varchar(256) null comment '服务支持描述',
    url        varchar(256) null comment '服务支持的图片地址',
    del_flg    char default '0' comment '删除标记[0-未删除|1-删除]',
    created_by varchar(64)  not null,
    created_at datetime     not null,
    updated_by varchar(64)  null,
    updated_at datetime     null,
    deleted_by varchar(64)  null,
    deleted_at datetime     null,
    comment    varchar(500)
) engine = InnoDB comment '服务支持';

create unique index uidx_gss_service_support_id on goblin_service_support (ssid);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_self_extag;
create table goblin_self_extag
(
    mid      bigint auto_increment primary key,
    tag_id   varchar(30)  not null comment '标签id',
    tag_name varchar(50)  not null comment '标签名称',
    tag_desc varchar(128) null comment '标签描述',
    tag_pic  varchar(256) null comment '标签图片',
    tag_type char         null comment '标签类型[1-音乐人|2-艺术家|3-IP]',
    sort     int  default 0 comment '排序[数值越小,排序越前]',
    del_flg  char default '0' comment '删除标记[0-未删除|1-删除]',
    comment  varchar(255)
) engine = InnoDB comment '平台专属标签';

create unique index uidx_gse_tag_id on goblin_self_extag (tag_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_self_goods_tag;
create table goblin_self_goods_tag
(
    mid      bigint auto_increment primary key,
    tag_id   varchar(30) not null comment '标签id',
    tag_name varchar(30) not null comment '标签名称',
    tag_desc varchar(50) null comment '标签说明',
    tag_type char default '0' comment '保留字段',
    sort     int  default 0 comment '排序[数值越小,排序越前]',
    del_flg  char default '0' comment '删除标记[0-未删除|1-删除]',
    comment  varchar(255)
) engine = InnoDB comment '平台商品标签';

create unique index uidx_gsgt_tag_id on goblin_self_goods_tag (tag_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_self_goods_category;
create table goblin_self_goods_category
(
    mid        bigint auto_increment primary key,
    cate_id    varchar(30) not null comment '商铺分类id',
    name       varchar(50) not null comment '分类名称',
    sort       int  default 0 comment '排序[数值越小,排序越前]',
    grade      char        null comment '分类层级[1-一级|2-二级|3-三级]',
    cate_pid   varchar(30) null comment '分类父id',
    ne_isbn    char default '0' comment '是否需要填写ISBN[0-否|1-是]',
    del_flg    char default '0' comment '删除标记[0-未删除|1-删除]',
    created_by varchar(64) not null,
    created_at datetime    not null,
    updated_by varchar(64) null,
    updated_at datetime    null,
    deleted_by varchar(64) null,
    deleted_at datetime    null,
    comment    varchar(255)
) engine = InnoDB comment '平台商品分类';

create unique index uidx_gsgc_cate_id on goblin_self_goods_category (cate_id);
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_store_info;
create table goblin_store_info
(
    mid            bigint auto_increment primary key,
    store_id       varchar(64)  not null comment '店铺id',
    uid            varchar(64)  not null comment '店主UID',
    store_name     varchar(128) not null comment '店铺名称',
    logo_pic       varchar(256) null comment '店铺LOGO',
    background_pic varchar(256) null comment '店铺背景图',
    introduce      varchar(500) null comment '店铺介绍',
    status         char          default '0' comment '店铺状态[0-填写资料中|1-店铺审核中|2-审核不通过|3-审核通过|4-停业|5-营业]',
    reason         varchar(256) null comment '拒绝原因',
    store_type     char          default '1' comment '店铺类型[1-普通店铺|2-加盟|3-连锁|5-直营]',
    cert_type      char         not null comment '认证类型[1-企业/公司|2-个体工商户]',
    ave_score      decimal(8, 2) default 0.0 comment '店铺评分',
    service_acc    varchar(128) null comment '客服账号',# ==
    validity       datetime     null comment '店铺有效期',
    created_by     varchar(64)  not null,
    created_at     datetime     not null,
    updated_by     varchar(64)  null,
    updated_at     datetime     null,
    deleted_by     varchar(64)  null,
    deleted_at     datetime     null,
    comment        varchar(500)
) engine = InnoDB comment '店铺基础信息';

create unique index uidx_gsi_store_id on goblin_store_info (store_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_store_certification;
create table goblin_store_certification
(
    mid                  bigint auto_increment primary key,
    store_id             varchar(64)  not null comment '店铺id',
    person_cert_type     char default '0' comment '证件类型[1-二代居民身份证]',
    person_name          varchar(32)  null comment '证件姓名',
    person_cert_fpic     varchar(256) null comment '证件正面照',
    person_cert_bpic     varchar(256) null comment '证件背面照',
    person_cert_spic     varchar(256) null comment '证件背面照',
    person_cert_code     varchar(32)  null comment '证件号',
    person_cert_validity datetime     null comment '证件有效期',
    person_cert_lasting  char         null comment '证件是否长期有效[0-否|1-是]',
    del_flg              char default '0' comment '删除标记[0-未删除|1-删除]',
    province_id          varchar(32)  null comment '省id',
    province_name        varchar(32)  null comment '省名称',
    city_id              varchar(32)  null comment '市id',
    city_name            varchar(32)  null comment '市名称',
    county_id            varchar(32)  null comment '县id',
    county_name          varchar(32)  null comment '县名称',
    bus_address          varchar(128) null comment '详细地址',
    bus_name             varchar(64)  null comment '商户名称',
    bus_cert_pic         varchar(256) null comment '营业执照照片',
    bus_quality_pic      varchar(256) null comment '资质证书',
    bus_cert_code        varchar(64)  null comment '统一社会信用代码',
    bus_cert_validity    datetime     null comment '营业执照有效期',
    bus_cert_lasting     char default '0' comment '证件是否长期有效[0-否|1-是]',
    created_by           varchar(64)  not null,
    created_at           datetime     not null,
    updated_by           varchar(64)  null,
    updated_at           datetime     null,
    deleted_by           varchar(64)  null,
    deleted_at           datetime     null,
    comment              varchar(500)
) engine = InnoDB comment '店铺认证信息';

create unique index uidx_gsc_store_id on goblin_store_certification (store_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_store_config;
create table goblin_store_config
(
    mid         bigint auto_increment primary key,
    store_id    varchar(64) not null comment '店铺id',
    config_name varchar(50) comment '参数名称',
    config_key  varchar(100) comment '参数键名',
    config_val  varchar(500) comment '参数键值',
    config_desc varchar(100) comment '参数描述',
    config_type char default '0' comment '保留字段',
    created_by  varchar(64) not null,
    created_at  datetime    not null,
    updated_by  varchar(64) null,
    updated_at  datetime    null,
    comment     varchar(500)
) engine = InnoDB comment '店铺设置';

create index idx_gsc_store_id on goblin_store_config (store_id);

# insert into goblin_store_config (store_id, config_name, config_key, config_val, created_by, created_at)
# values (0, '联系客服', 'switch_show_customer_service', 'Y', 'admin', sysdate()),
#        (0, '售罄展示', 'switch_show_sold_out', 'Y', 'admin', sysdate()),
#        (0, '库存不足', 'boundary_warning_stock', '5', 'admin', sysdate());
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_store_goods_category;
create table goblin_store_goods_category
(
    mid        bigint auto_increment primary key,
    store_id   varchar(64) not null comment '店铺id',
    cate_id    varchar(30) not null comment '分类id',
    name       varchar(50) not null comment '分类名称',
    sort       int  default 0 comment '排序[数值越小,排序越前]',
    grade      char        null comment '分类层级[1-一级|2-二级|3-三级]',
    cate_pid   varchar(30) null comment '父级分类id',
    ne_isbn    char default '0' comment '是否需要填写ISBN[0-否|1-是]',
    del_flg    char default '0' comment '删除标记[0-未删除|1-删除]',
    created_by varchar(64) not null,
    created_at datetime    not null,
    updated_by varchar(64) null,
    updated_at datetime    null,
    deleted_by varchar(64) null,
    deleted_at datetime    null,
    comment    varchar(255)
) engine = InnoDB comment '商铺商品分类';

create index idx_gsgc_store_id on goblin_store_goods_category (store_id);
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_service_support;
create table goblin_goods_service_support
(
    mid     bigint auto_increment primary key,
    spu_id  varchar(64) not null comment '商品id',
    ssid    varchar(30) not null comment '服务支持id，对应 goblin_service_support.ssid',
    del_flg char default '0' comment '删除标记[0-未删除|1-删除]',
    comment varchar(255)
) engine = InnoDB comment '商品关联服务支持';

create index idx_ggss_service_support_id on goblin_goods_service_support (ssid);
create index idx_ggss_spu_id on goblin_goods_service_support (spu_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_spu_tag;
create table goblin_goods_spu_tag
(
    mid        bigint auto_increment primary key,
    spu_id     varchar(64) not null comment '商品id',
    tag_id     varchar(30) not null comment '标签id，对应 goblin_self_goods_tag.tag_id | goblin_self_extag.tag_id',
    tag_belong char default '0' comment '标签所属[0-普通标签|1-专属标签]',
    del_flg    char default '0' comment '删除标记[0-未删除|1-删除]',
    comment    varchar(255)
) engine = InnoDB comment '商品关联标签';

create index idx_ggst_tag_id on goblin_goods_spu_tag (tag_id);
create index idx_ggst_spu_id on goblin_goods_spu_tag (spu_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods;
create table goblin_goods
(
    mid                bigint auto_increment primary key,
    spu_id             varchar(64)      not null comment '商品id',
    spu_no             varchar(45)      not null comment '商品编码',
    name               varchar(128)     not null comment '商品名称',
    subtitle           varchar(256)     null comment '商品副标题',

    sell_price         decimal(20, 2)   null comment '销售价',
    intro              varchar(256)     null comment '商品简介',
    details            text             null comment '详情',
    cover_pic          varchar(256)     null comment '封面图片地址',
    video              varchar(256)     null comment '商品视频地址',
    spec_mode          char default '1' not null comment '规格展现方式[1-常规|2-组合]',

    store_id           varchar(64)      null comment '商品的店铺id，如果是平台的则为0',
    cate_fid           varchar(30)      null comment '平台一级分类id',
    cate_sid           varchar(30)      null comment '平台二级分类id',
    cate_tid           varchar(30)      null comment '平台三级分类id',
    store_cate_fid     varchar(30)      null comment '店铺一级分类id',
    store_cate_sid     varchar(30)      null comment '店铺二级分类id',
    store_cate_tid     varchar(30)      null comment '店铺三级分类id',
    brand_id           varchar(30)      not null comment '品牌id',

    spu_appear         char default '0' not null comment '自定义展示[0-默认展示|1-隐藏不可购买]',
    spu_validity       datetime         null comment '商品有效期',
    status             char default '0' null comment '审核状态[0-编辑中|1-审核中|2-审核不通过|3-审核通过]',
    reason             varchar(500)     null comment '审核拒绝原因',
    shelves_status     char default '0' null comment '商品上架状态[0-待上架|1-下架|2-违规|3-上架]',
    virtual_flg        char default '0' comment '是否虚拟商品[0-否|1-是]',
    del_flg            char default '0' comment '删除标记[0-未删除|1-删除]',

    shelves_handle     char default '1' comment '上架处理方式[1-等待手动上架|2-直接上架售卖|3-预约定时上架]',
    shelves_time       datetime         null comment '上架处理方式为3-预约定时上架时需要指定]',

    shelves_at         datetime         null comment '上架时间',
    created_by         varchar(64)      not null,
    created_at         datetime         not null,
    updated_by         varchar(64)      null,
    updated_at         datetime         null,
    deleted_by         varchar(64)      null,
    deleted_at         datetime         null,
    logistics_template varchar(64)      null comment '物流模版id',
    comment            varchar(500)
) engine = InnoDB comment '商品信息';

create unique index uidx_gg_spu_id on goblin_goods (spu_id);
create index idx_gg_store_id on goblin_goods (store_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_image;
create table goblin_goods_image
(
    mid     bigint auto_increment primary key,
    spu_id  varchar(64)  not null comment '商品id',
    url     varchar(256) not null comment '图片地址',
    del_flg char default '0' comment '删除标记[0-未删除|1-删除]'
) engine = InnoDB comment '商品图片';

create index idx_ggi_spu_id on goblin_goods_image (spu_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_sku;
create table goblin_goods_sku
(
    sku_id             varchar(64)      not null primary key,
    spu_id             varchar(64)      not null comment '商品id',
    sku_no             varchar(45)      not null comment '单品的编号',
    name               varchar(256)     not null comment '单品的名称',
    subtitle           varchar(256)     null comment '单品的副标题',

    sku_pic            varchar(256)     null comment '单品默认图片的url',
    sku_isbn           varchar(100)     null comment 'ISBN，针对CD/图书等',
    stock              int              not null comment '总库存',
    sku_stock          int              not null comment '单品库存',
    warning_stock      int              null comment '预警库存',
    price              decimal(20, 2)   not null comment '单品价格',
    price_member       decimal(20, 2)   not null comment '会员价格',
    weight             decimal(20, 2)   not null comment '单品的重量',
    buy_factor         char default '0' comment '购买限制[0-全部用户|1-仅会员|2-指定用户]',
    buy_limit          varchar(256)     null comment '购买限制为2-指定用户时必填指定用户',

    sku_appear         char default '0' not null comment '自定义展示[0-默认展示|1-隐藏不可购买]',
    sku_validity       datetime         null comment '单品有效期',
    status             char default '0' null comment '审核状态[0-初始编辑|1-审核中|2-审核不通过|3-审核通过]',
    reason             varchar(1024)    null comment '审核拒绝原因',
    shelves_status     char default '0' comment '单品上架状态[0-待上架|1-下架|2-违规|3-上架]',
    virtual_flg        char default '0' comment '是否是虚拟商品[0-否|1-是]',
    del_flg            char default '0' comment '删除标记[0-未删除|1删除]',

    shelves_at         datetime         null comment '上架时间',
    created_by         varchar(64)      not null,
    created_at         datetime         not null,
    updated_by         varchar(64)      null,
    updated_at         datetime         null,
    deleted_by         varchar(64)      null,
    deleted_at         datetime         null,
    logistics_template varchar(64)      null comment '物流模版id',
    comment            varchar(500)
) engine = InnoDB comment '商品单品';

create index idx_ggs_spu_id on goblin_goods_sku (spu_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_spu_spec_value;
create table goblin_goods_spu_spec_value
(
    id           bigint auto_increment primary key,
    spu_id       varchar(64)  not null comment '商品id，对应 goblin_goods.spu_id',
    spec_id      varchar(30)  not null comment '规格id，对应 goblin_goods_spec.spec_id',
    spec_vid     varchar(30)  not null comment '规格值id，对应 goblin_goods_spec_value.spec_vid',
#     url          varchar(256) null comment '规格值的图片地址',
    value_remark varchar(100) not null comment '规格值',
    del_flg      char default '0' comment '删除标记[0-未删除|1-删除]'
) engine = InnoDB comment '商品关联规格值';

create index idx_ggssv_spu_id on goblin_goods_spu_spec_value (spu_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_sku_spec_value;
create table goblin_goods_sku_spec_value
(
    id           bigint auto_increment primary key,
    spu_id       varchar(64)  not null comment '商品id，对应 goblin_goods.spu_id',
    sku_id       varchar(64)  not null comment '单品id，对应 goblin_goods_sku.sku_id',
    spec_id      varchar(30)  not null comment '规格id，对应 goblin_goods_spec.spec_id',
    spec_vid     varchar(30)  not null comment '规格值id，对应 goblin_goods_spec_value.spec_vid',
    value_remark varchar(100) not null comment '规格值',
    del_flg      char default '0' comment '删除标记[0-未删除|1-删除]'
) engine = InnoDB comment '单品关联规格值';

create index idx_ggssv_sku_id on goblin_goods_sku_spec_value (sku_id);
create index idx_ggssv_spec_id on goblin_goods_sku_spec_value (spec_id);
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_spec_value;
create table goblin_goods_spec_value
(
    id         varchar(64)  not null primary key,
    spec_vid   varchar(30)  not null comment '规格id，对应 goblin_goods_spec.spec_id',
    spec_vname varchar(128) not null comment '规格值的名称',
    spec_vsort int  default 0 comment '排序，数值越小排序越前',
    del_flg    char default '0' comment '删除标记[0-未删除|1-删除]',
    created_by varchar(64)  not null,
    created_at datetime     not null,
    updated_by varchar(64)  null,
    updated_at datetime     null,
    deleted_by varchar(64)  null,
    deleted_at datetime     null,
    comment    varchar(255)
) engine = InnoDB comment '商品规格值';

create index idx_ggsv_spec_vid on goblin_goods_spec_value (spec_vid);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_spec;
create table goblin_goods_spec
(
    id         bigint auto_increment primary key,
    spec_id    varchar(30) not null comment '规格id',
    spec_name  varchar(45) not null comment '规格名称',
    spec_alias varchar(45) null comment '规格别名',
    spec_sort  int  default 0 comment '排序，数值越小排序越前',
    del_flg    char default '0' comment '删除标记[0-未删除|1-删除]',
    created_by varchar(64) not null,
    created_at datetime    not null,
    updated_by varchar(64) null,
    updated_at datetime    null,
    deleted_by varchar(64) null,
    deleted_at datetime    null,
    comment    varchar(255)
) charset = utf8 comment '商品规格';

create unique index uidx_ggs_spec_id on goblin_goods_spec (spec_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_category_spec;
create table goblin_goods_category_spec
(
    id      bigint auto_increment primary key,
    cate_id varchar(30) not null comment '分类id，对应 goblin_self_goods_category.cate_id',
    spec_id varchar(30) not null comment '规格id，对应 goblin_goods_spec.spec_id',
    del_flg char default '0' comment '删除标记[0-未删除|1-删除'
) engine = InnoDB comment '分类关联规格';

create index idx_ggcs_cate_id on goblin_goods_category_spec (cate_id);

# -- >>------------------------------------------------------------------------------------
DROP TABLE IF EXISTS `goblin_front_banner`;
CREATE TABLE `goblin_front_banner` (
  `mid` bigint NOT NULL COMMENT '主键',
  `pic_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '图片路径',
  `indexs` int DEFAULT NULL COMMENT '排序',
  `jump_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '1、票务2、H5',
  `start_time` timestamp NULL DEFAULT NULL COMMENT '开启时间',
  `end_time` timestamp NULL DEFAULT NULL COMMENT '结束时间',
  `activity_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '活动url',
  `ticket_name` varbinary(255) DEFAULT NULL COMMENT '票务名字',
  `banner_type` int DEFAULT NULL COMMENT '1、首页顶部位置2、首页中部位置',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  `banner_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'bannerId',
  `del_tag` int DEFAULT NULL COMMENT '0未删除1已删除',
  PRIMARY KEY (`mid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='轮播图';


# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------

# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------

# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------