package com.liquidnet.service.order.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.codec.vo.EncryptedReq;
import com.liquidnet.service.goblin.dto.vo.GoblinNftPayResultVo;
import com.liquidnet.service.goblin.param.GoblinNftOrderPayAgainParam;
import com.liquidnet.service.goblin.param.GoblinNftOrderPayCallbackParam;
import com.liquidnet.service.goblin.param.GoblinNftOrderPayParam;
import com.liquidnet.service.goblin.param.GoblinNftOrderRefundCallbackParam;
import com.liquidnet.service.goblin.service.IGoblinNftOrderService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

@Api(tags = "NFT-支付相关")
@RestController
@RequestMapping("/goblin/nft")
public class GoblinNftOrderController {

    @Autowired
    IGoblinNftOrderService iGoblinNftOrderService;

    @PostMapping("pre")
    @ApiOperation("下单(加密)")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<GoblinNftPayResultVo> checkOrder(@RequestBody EncryptedReq<GoblinNftOrderPayParam> payParam) {
        return iGoblinNftOrderService.checkOrder(payParam.getData());
    }

    @PostMapping("fc7bce6d6c2213b866f76493f92224b8")
    @ApiOperation("下单(非加密)")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<GoblinNftPayResultVo> checkOrder(@RequestBody GoblinNftOrderPayParam payParam) {
        return iGoblinNftOrderService.checkOrder(payParam);
    }

    @PostMapping("payAgain")
//    @ApiOperation("再次支付")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<GoblinNftPayResultVo> payAgain(@RequestBody @Valid GoblinNftOrderPayAgainParam param) {
        return iGoblinNftOrderService.payAgain(param);
    }

    @PostMapping("checkPayment")
    @ApiOperation("订单状态")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id", example = "1"),
    })
    public ResponseDto<Integer> checkOrderResult(@RequestParam("orderId") @Valid String orderId) {
        return iGoblinNftOrderService.checkOrderResult(orderId);
    }

    @PostMapping("syncOrder")
    @ApiOperation("支付回调")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public String syncOrder(@ModelAttribute @Valid GoblinNftOrderPayCallbackParam syncOrderParam) {
        return iGoblinNftOrderService.syncOrder(syncOrderParam);
    }

    @ApiOperation(value = "退款回调")
    @PostMapping(value = "refundSyncOrder")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public String refundSyncOrder(GoblinNftOrderRefundCallbackParam refundCallbackParam) {
        return iGoblinNftOrderService.refundSyncOrder(refundCallbackParam);
    }

}
