package com.liquidnet.service.sweet.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.service.impl.SweetWechatLoginServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "小程序登陆")
@RestController
@RequestMapping("/wechatLogin")
public class SweetWechatLoginController {

    @Autowired
    private SweetWechatLoginServiceImpl sweetLoginService;

    @GetMapping("userInfo")
    @ApiOperation("code获取用户信息")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "code", value = "微信code", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "encryptedData", value = "encryptedData", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "iv", value = "iv", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "1草莓 2五百里 3mdsk"),
    })
    public ResponseDto userInfo(
            @RequestParam() String code,
            @RequestParam() String encryptedData,
            @RequestParam() String iv,
            @RequestParam(defaultValue = "1") Integer type
    ) {
        return sweetLoginService.userInfo(code, encryptedData, iv, type);
    }

}
