package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyQueryUserTradeAllListReqDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/8 16:27
 */
@ApiModel(value = "GalaxyQueryUserTradeAllListReqDto", description = "用户所有进出NFT信息查询")
@Data
public class GalaxyQueryUserTradeAllListReqDto extends GalaxyBaseReqDto implements Serializable,Cloneable{
    @ApiModelProperty(position = 1, required = true, value = "blockChainAddress")
    @NotBlank(message = "区块链地址不能为空！")
    private String blockChainAddress;

    @ApiModelProperty(position = 1, required = true, value = "seriesId(可选，默认为0查询全部)")
    private String seriesId = "0";

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyQueryUserTradeAllListReqDto obj = new GalaxyQueryUserTradeAllListReqDto();

    public static GalaxyQueryUserTradeAllListReqDto getNew() {
        try {
            return (GalaxyQueryUserTradeAllListReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyQueryUserTradeAllListReqDto();
        }
    }
}
