package com.liquidnet.service.sweet.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.service.impl.SweetTemplateServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "公众号模版消息")
@RestController
@RequestMapping("/sweet-template")
public class SweetTemplateController {

    @Autowired
    private SweetTemplateServiceImpl sweetTemplateService;

    @GetMapping("send")
    @ApiOperation("发送模版消息")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "code", value = "微信code", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "encryptedData", value = "encryptedData", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "iv", value = "iv", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "type", value = "1草莓 2五百里 3mdsk"),
    })
    public ResponseDto send(
            @RequestParam() String code,
            @RequestParam() String encryptedData,
            @RequestParam() String iv,
            @RequestParam(defaultValue = "1") Integer type
    ) {
        sweetTemplateService.sendMsg();
        return ResponseDto.success();
    }

    @PostMapping("remind")
    @ApiOperation("提醒记录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "unionId", value = "微信unionId", required = true),
            @ApiImplicitParam(type = "form", dataType = "String", name = "performancesId", value = "演出ID", required = true),
    })
    public ResponseDto remind(
            @RequestParam() String unionId,
            @RequestParam() String performancesId
    ) {
        return sweetTemplateService.remind(unionId, performancesId);
    }

}
