create database if not exists ln_scene character set utf8mb4 collate utf8mb4_unicode_ci;
use ln_scene;
-- >>------------------------------------------------------------------------------------
drop table if exists adam_third_party;
create table adam_third_party
(
    mid        int unsigned auto_increment primary key,
    uid        varchar(64) default '',
    open_id    varchar(64) comment '第三方ID',
    avatar     varchar(255) comment '第三方头像',
    nickname   varchar(64) comment '第三方昵称',
    platform   varchar(20) comment '平台名称',
    state      tinyint comment '0-INIT,1-NORMAL,2-INVALID',
    created_at datetime,
    updated_at datetime,
    comment    text
) engine = InnoDB comment '用户第三方账号信息';

create unique index uidx_third_party_uid_open_id on adam_third_party (uid, open_id);
-- >>------------------------------------------------------------------------------------
# drop table if exists adam_login;
# create table adam_login
# (
#     mid         int unsigned auto_increment primary key,
#     mobile      varchar(16),
#     platform    varchar(20) comment '平台名称',
#     entrance    varchar(20) comment '入口标记:Wechat、H5、App',
#     source      varchar(20) comment '来源终端',
#     version     varchar(20) comment '终端版本',
#     client_ip   varchar(20),
#     client_area varchar(30),
#     created_at  datetime
# ) engine = InnoDB comment '登录记录';
# create index idx_login_mobile on adam_login (mobile);
-- >>------------------------------------------------------------------------------------
# drop table if exists adam_device_token;
# create table adam_device_token
# (
#     mid        int unsigned auto_increment primary key,
#     uid        varchar(64)  not null,
#     android    varchar(255) null,
#     ios        varchar(255) null,
#     ipad       varchar(255) null,
#     is_last    tinyint,
#     created_at datetime     not null,
#     updated_at datetime,
#     comment    text
# ) engine = InnoDB comment 'TOKEN';
#
# create index idx_device_token_uid on adam_device_token (uid);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_user;
create table adam_user
(
    mid        int unsigned auto_increment primary key,
    uid        varchar(64) not null,
    mobile     varchar(30) not null,
    passwd     varchar(64),
    pay_code   varchar(64),
    state      tinyint comment '1-NORMAL,2-INVALID',
    created_at datetime    not null,
    updated_at datetime,
    closed_at  datetime,
    comment    text
) ENGINE = InnoDB comment '用户';

create unique index uidx_user_uid on adam_user (uid);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_user_info;
create table adam_user_info
(
    mid        int unsigned auto_increment primary key,
    uid        varchar(64) not null,
    nickname   varchar(32) comment '昵称',
    sex        varchar(32) comment '性别',
    birthday   date comment '生日YYYY-MM-DD',
    area       varchar(100) comment '常住地/区域',
    signature  varchar(255) comment '个性签名',
    avatar     varchar(255) comment '头像',
    background varchar(255) comment '背景图',
    qr_code    varchar(255) comment '身份二维码',
    qr_pic     varchar(255) comment '身份二维码',
    tag_me     varchar(500) comment '音乐标签',
    comment    text
) engine = InnoDB comment '用户信息';

create unique index idx_user_info_uid on adam_user_info (uid);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_real_name;
create table adam_real_name
(
    mid          int unsigned auto_increment primary key,
    real_name_id varchar(64)                not null,
    uid          varchar(64)                not null,
    type         enum ('1','2','3','4','5') not null default '1' comment '1-大陆身份证,2-港澳通行证,3-台胞证,4-护照,5-军官证',
    name         varchar(30)                not null comment '真实姓名',
    id_card      varchar(50)                not null comment '证件号码',
    state        tinyint                    not null comment '0-INIT,1-NORMAL,2-INVALID',
    created_at   datetime                   not null,
    updated_at   datetime,
    comment      text
) engine = InnoDB comment '实名信息';

create unique index idx_real_name_uid on adam_real_name (uid);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_enters;
create table adam_enters
(
    mid        int unsigned auto_increment primary key,
    #     `user_id` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
    enters_id  varchar(64) not null,
    uid        varchar(64) not null comment '用户id',
    type       tinyint     not null default '1' comment '1-大陆身份证,2-港澳通行证,3-台胞证,4-护照,5-军官证',
    name       varchar(50) not null default '' comment '入场人名称',
    mobile     varchar(20) not null default '' comment '入场人手机号',
    id_card    varchar(20) not null default '' comment '入场人身份号码，或护照号码',
    is_default boolean     not null default false comment '是否为默认:0-否,1-是，第一个入默认1',
    #     is_certification enum ('yes','no')          not null default 'no' comment '入场人的身份证号是否认证',
    state      tinyint     not null comment '状态:0-INIT,1-NORMAL,2-INVALID',
    created_at datetime    not null,
    updated_at datetime,
    deleted_at datetime,
    comment    text
) engine = InnoDB comment ='入场人';

create unique index uidx_enters_id on adam_enters (enters_id);
create index idx_enters_uid on adam_enters (uid);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_addresses;
create table adam_addresses
(
    mid          int unsigned auto_increment not null primary key,
    addresses_id varchar(64)                 not null,
    uid          varchar(64)                 not null,
    name         varchar(30)                 not null comment '姓名',
    phone        varchar(30)                 not null comment '手机号',
    province     varchar(30)                 not null comment '省份',
    city         varchar(30)                 not null comment '城市',
    county       varchar(30)                 not null comment '区县',
    address      varchar(100)                not null comment '详细地址',
    is_default   boolean                     not null default false comment '是否为默认:0-否,1-是,第一个默认1',
    #     is_certification enum ('yes','no')          not null default 'no' comment '入场人的身份证号是否认证',
    state        tinyint                     not null comment '状态:0-INIT,1-NORMAL,2-INVALID',
    created_at   datetime                    not null,
    updated_at   datetime,
    deleted_at   datetime,
    comment      text
) engine = InnoDB comment '收货地址';

create unique index uidx_addresses_id on adam_addresses (addresses_id);
create index idx_addresses_uid on adam_addresses (uid);
-- >>------------------------------------------------------------------------------------
# drop table if exists adam_feedback;
# create table adam_feedback
# (
#     mid           int unsigned auto_increment                                  not null primary key,
#     uid           varchar(64)                                                  not null,
#     type          enum ('complaints', 'bug', 'order', 'video', 'other')        not null comment '反馈类型',
#     comment       varchar(255)                                                 not null comment '反馈内容',
#     reply_comment varchar(255)                                                 null comment '回复内容',
#     source        varchar(255)                                                 not null comment '来源终端',
#     version       varchar(255)                                                 not null comment '终端版本',
#     model         varchar(255)                              default ''         not null comment '设备',
#     status        enum ('notreply', 'replied', 'processed') default 'notreply' not null comment '状态',
#     mobile        varchar(50)                                                  not null comment '手机号',
#     admin_id      int                                       default 0          not null comment '处理人',
#     admin_name    varchar(255)                              default ''         not null comment '处理人姓名',
#     admin_time    datetime                                                     null comment '处理时间',
#     created_at    datetime                                                     not null,
#     updated_at    datetime
# ) engine = InnoDB comment '反馈';
-- >>------------------------------------------------------------------------------------
drop table if exists adam_collection;
create table adam_collection
(
    mid        int unsigned auto_increment primary key,
    uid        varchar(64)       not null,
    content_id varchar(64)       not null,
    type       varchar(30)       not null comment '收藏类型:VIDEO,TICKET,SITE,ARTIST,BAND,BRAND,STYLE,GOODS,MUSIC,SONG',
    state      tinyint default 1 not null comment '1-正常,2-删除',
    created_at datetime          not null,
    updated_at datetime,
    comment    text
) engine = InnoDB comment '收藏';

create unique index uidx_collection_uid_content_id on adam_collection (uid, content_id);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_disposed;
create table adam_disposed
(
    mid        int unsigned auto_increment not null primary key,
    uid        varchar(64)                 not null,
    content_id int unsigned                not null,
    type       varchar(30)                 not null comment '想去类型:TICKET',
    state      tinyint default 1           not null comment '1-正常,2-删除',
    created_at datetime                    not null,
    updated_at datetime,
    comment    text
) engine = InnoDB comment '想去';
create index idx_disposed_uid on adam_disposed (uid);
create index idx_disposed_content on adam_disposed (content_id);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_member;
create table adam_member
(
    mid               int unsigned auto_increment primary key,
    member_id         varchar(255) comment '会员id',
    name              varchar(64),
    title             varchar(100),
    sub_title         varchar(255) NOT NULL DEFAULT '' COMMENT '副标题',
    icon              varchar(255),
    avatar            varchar(255),
    start_no          varchar(20) comment '起始会员号',
    type              tinyint comment '会员类型',
    interests_detail  text comment '权益详情',
    #     gift_pack_id     varchar(64) comment '礼包ID',
    notes             text         NOT NULL COMMENT '注意事项',
    created_at        datetime,
    updated_at        datetime,
    is_notice         tinyint comment '是否展示须知',
    notice_info       text comment '须知内容',
    notice_title      varchar(255),
    need_question     int                   default 0 comment '是否需要答题 0不需要 1需要',
    display_agreement int          NOT NULL DEFAULT '0' COMMENT '是否打开0否1是',
    state             int          NOT NULL COMMENT '状态:1-NORMAL,2-INVALID',
    limitation        int                   default 0 comment '限购数量，0不限购',
    comment           text
);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_member_price;
create table adam_member_price
(
    mid             int unsigned auto_increment primary key,
    member_price_id varchar(64) comment '会员价格id',
    member_id       varchar(64)                                                  NOT NULL comment '会员种类ID',
    state           tinyint                                                      NOT NULL DEFAULT '0' COMMENT '0不可用、1上线中、2已下线',
    name            varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '会员包名称',
    price           decimal(8, 2)                                                NOT NULL DEFAULT '0.00' COMMENT '会员包价格',
    price_fixed     decimal(8, 2) comment '折扣价',
    days            int                                                          NOT NULL DEFAULT '0' COMMENT '会员包天数',
    detail          text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci        NOT NULL COMMENT '会员包须知',
    created_at      datetime,
    updated_at      datetime,
    comment         text
);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_member_order;
create table adam_member_order
(
    mid             int unsigned auto_increment primary key,
    order_no        varchar(64),
    uid             varchar(64),
    mode            tinyint comment '购买方式:0-购买会员,1-购买会员码',
    price           decimal(8, 2) comment '原价',
    price_paid      decimal(8, 2) comment '实际支付',
    member_name     varchar(64),
    member_id       varchar(255) comment '会员id',
    member_price_id varchar(255) comment '会员价格id',
    days            int      default 0 comment '购买天数',
    state           tinyint comment '订单状态',
    member_no       varchar(20) comment '会员号',
    device_from     varchar(20) comment '支付终端:app,wap,js,applet',
    pay_type        varchar(20) comment '支付方式:alipay,wepay',
    pay_no          varchar(64) comment '支付订单',
    birthday        date     default null comment '用户生日',
    payment_at      datetime default null comment '支付时间',
    created_at      datetime,
    updated_at      datetime,
    client_ip       varchar(50),
    source          varchar(20),
    version         varchar(20),
    comment         text
);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_user_member;
create table adam_user_member
(
    mid        int unsigned auto_increment primary key,
    uid        varchar(64)  not null,
    member_id  varchar(255) comment '会员类型id',
    member_no  int unsigned not null,
    state      tinyint comment '1-NORMAL,2-INVALID',
    expiry_at  datetime comment '到期日期',
    created_at datetime,
    updated_at datetime,
    comment    text
);
-- >>------------------------------------------------------------------------------------
drop table if exists adam_member_code;
create table adam_member_code
(
    mid             int unsigned auto_increment primary key,
    code            varchar(20) comment '会员码',
    type            int          default 0 comment '0用户购买1提前制作',
    member_id       varchar(255) comment '会员ID',
    member_price_id varchar(255) comment '会员价格ID',
    member_no       varchar(20) comment '预留会员号',
    state           tinyint comment '0-未用,1-已用,2-失效',
    created_at      datetime,
    updated_at      datetime,
    buy_order_no    varchar(255) default null comment '购买会员码订单号',
    buy_uid         varchar(255) default null comment '购买会员码用户id',
    buy_at          datetime     default null comment '购买时间',
    use_order_no    varchar(64)  default null comment '消费订单号',
    use_uid         varchar(64)  default null comment '消费用户ID',
    use_at          datetime     default null,
    comment         text
);
-- >>------------------------------------------------------------------------------------
-- >>------------------------------------------------------------------------------------
-- >>------------------------------------------------------------------------------------
